/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.BaseProjectOperator;
import org.apache.pinot.core.operator.blocks.results.DistinctResultsBlock;
import org.apache.pinot.core.operator.query.DictionaryBasedDistinctOperator;
import org.apache.pinot.core.operator.query.DistinctOperator;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.plan.ProjectPlanNode;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.SegmentContext;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.reader.NullValueVectorReader;

public class DistinctPlanNode
implements PlanNode {
    private final IndexSegment _indexSegment;
    private final SegmentContext _segmentContext;
    private final QueryContext _queryContext;

    public DistinctPlanNode(SegmentContext segmentContext, QueryContext queryContext) {
        this._indexSegment = segmentContext.getIndexSegment();
        this._segmentContext = segmentContext;
        this._queryContext = queryContext;
    }

    public Operator<DistinctResultsBlock> run() {
        DataSource dataSource;
        String column;
        List<ExpressionContext> expressions = this._queryContext.getSelectExpressions();
        if (this._queryContext.getFilter() == null && expressions.size() == 1 && (column = expressions.get(0).getIdentifier()) != null && (dataSource = this._indexSegment.getDataSource(column)).getDictionary() != null) {
            if (!this._queryContext.isNullHandlingEnabled()) {
                return new DictionaryBasedDistinctOperator(dataSource, this._queryContext);
            }
            NullValueVectorReader nullValueReader = dataSource.getNullValueVector();
            if (nullValueReader == null || nullValueReader.getNullBitmap().isEmpty()) {
                return new DictionaryBasedDistinctOperator(dataSource, this._queryContext);
            }
        }
        Operator projectOperator = new ProjectPlanNode(this._segmentContext, this._queryContext, expressions, 10000).run();
        return new DistinctOperator(this._indexSegment, this._queryContext, (BaseProjectOperator<?>)projectOperator);
    }
}

