/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.common.request.context.predicate.JsonMatchPredicate;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.common.request.context.predicate.RegexpLikePredicate;
import org.apache.pinot.common.request.context.predicate.TextContainsPredicate;
import org.apache.pinot.common.request.context.predicate.TextMatchPredicate;
import org.apache.pinot.common.request.context.predicate.VectorSimilarityPredicate;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.filter.BitmapBasedFilterOperator;
import org.apache.pinot.core.operator.filter.EmptyFilterOperator;
import org.apache.pinot.core.operator.filter.ExpressionFilterOperator;
import org.apache.pinot.core.operator.filter.FilterOperatorUtils;
import org.apache.pinot.core.operator.filter.H3InclusionIndexFilterOperator;
import org.apache.pinot.core.operator.filter.H3IndexFilterOperator;
import org.apache.pinot.core.operator.filter.JsonMatchFilterOperator;
import org.apache.pinot.core.operator.filter.MatchAllFilterOperator;
import org.apache.pinot.core.operator.filter.TextContainsFilterOperator;
import org.apache.pinot.core.operator.filter.TextMatchFilterOperator;
import org.apache.pinot.core.operator.filter.VectorSimilarityFilterOperator;
import org.apache.pinot.core.operator.filter.predicate.FSTBasedRegexpPredicateEvaluatorFactory;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluatorProvider;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.local.realtime.impl.invertedindex.NativeMutableTextIndex;
import org.apache.pinot.segment.local.segment.index.readers.text.NativeTextIndexReader;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.SegmentContext;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.reader.JsonIndexReader;
import org.apache.pinot.segment.spi.index.reader.NullValueVectorReader;
import org.apache.pinot.segment.spi.index.reader.TextIndexReader;
import org.apache.pinot.segment.spi.index.reader.VectorIndexReader;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.exception.BadQueryRequestException;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class FilterPlanNode
implements PlanNode {
    private final IndexSegment _indexSegment;
    private final SegmentContext _segmentContext;
    private final QueryContext _queryContext;
    private final FilterContext _filter;
    private final List<Pair<Predicate, PredicateEvaluator>> _predicateEvaluators = new ArrayList<Pair<Predicate, PredicateEvaluator>>(4);

    public FilterPlanNode(SegmentContext segmentContext, QueryContext queryContext) {
        this(segmentContext, queryContext, null);
    }

    public FilterPlanNode(SegmentContext segmentContext, QueryContext queryContext, @Nullable FilterContext filter) {
        this._indexSegment = segmentContext.getIndexSegment();
        this._segmentContext = segmentContext;
        this._queryContext = queryContext;
        this._filter = filter != null ? filter : this._queryContext.getFilter();
    }

    public BaseFilterOperator run() {
        MutableRoaringBitmap queryableDocIdsSnapshot = this._segmentContext.getQueryableDocIdsSnapshot();
        int numDocs = this._indexSegment.getSegmentMetadata().getTotalDocs();
        if (this._filter != null) {
            BaseFilterOperator filterOperator = this.constructPhysicalOperator(this._filter, numDocs);
            if (queryableDocIdsSnapshot != null) {
                BitmapBasedFilterOperator validDocFilter = new BitmapBasedFilterOperator((ImmutableRoaringBitmap)queryableDocIdsSnapshot, false, numDocs);
                return FilterOperatorUtils.getAndFilterOperator(this._queryContext, Arrays.asList(filterOperator, validDocFilter), numDocs);
            }
            return filterOperator;
        }
        if (queryableDocIdsSnapshot != null) {
            return new BitmapBasedFilterOperator((ImmutableRoaringBitmap)queryableDocIdsSnapshot, false, numDocs);
        }
        return new MatchAllFilterOperator(numDocs);
    }

    public List<Pair<Predicate, PredicateEvaluator>> getPredicateEvaluators() {
        return this._predicateEvaluators;
    }

    private boolean canApplyH3IndexForDistanceCheck(Predicate predicate, FunctionContext function) {
        if (predicate.getType() != Predicate.Type.RANGE) {
            return false;
        }
        String functionName = function.getFunctionName();
        if (!functionName.equals("st_distance") && !functionName.equals("stdistance")) {
            return false;
        }
        List arguments = function.getArguments();
        if (arguments.size() != 2) {
            throw new BadQueryRequestException("Expect 2 arguments for function: ST_Distance");
        }
        String columnName = null;
        boolean findLiteral = false;
        for (ExpressionContext argument : arguments) {
            if (argument.getType() == ExpressionContext.Type.IDENTIFIER) {
                columnName = argument.getIdentifier();
                continue;
            }
            if (argument.getType() != ExpressionContext.Type.LITERAL) continue;
            findLiteral = true;
        }
        return columnName != null && this._indexSegment.getDataSource(columnName).getH3Index() != null && findLiteral && this._queryContext.isIndexUseAllowed(columnName, FieldConfig.IndexType.H3);
    }

    private boolean canApplyH3IndexForInclusionCheck(Predicate predicate, FunctionContext function) {
        if (predicate.getType() != Predicate.Type.EQ) {
            return false;
        }
        String functionName = function.getFunctionName();
        if (!functionName.equals("stwithin") && !functionName.equals("stcontains")) {
            return false;
        }
        List arguments = function.getArguments();
        if (arguments.size() != 2) {
            throw new BadQueryRequestException("Expect 2 arguments for function: " + functionName);
        }
        if (functionName.equals("stwithin")) {
            if (((ExpressionContext)arguments.get(0)).getType() == ExpressionContext.Type.IDENTIFIER && ((ExpressionContext)arguments.get(1)).getType() == ExpressionContext.Type.LITERAL) {
                String columnName = ((ExpressionContext)arguments.get(0)).getIdentifier();
                return this._indexSegment.getDataSource(columnName).getH3Index() != null && this._queryContext.isIndexUseAllowed(columnName, FieldConfig.IndexType.H3);
            }
            return false;
        }
        if (((ExpressionContext)arguments.get(1)).getType() == ExpressionContext.Type.IDENTIFIER && ((ExpressionContext)arguments.get(0)).getType() == ExpressionContext.Type.LITERAL) {
            String columnName = ((ExpressionContext)arguments.get(1)).getIdentifier();
            return this._indexSegment.getDataSource(columnName).getH3Index() != null && this._queryContext.isIndexUseAllowed(columnName, FieldConfig.IndexType.H3);
        }
        return false;
    }

    private BaseFilterOperator constructPhysicalOperator(FilterContext filter, int numDocs) {
        switch (filter.getType()) {
            case AND: {
                List childFilters = filter.getChildren();
                ArrayList<BaseFilterOperator> childFilterOperators = new ArrayList<BaseFilterOperator>(childFilters.size());
                for (FilterContext childFilter : childFilters) {
                    BaseFilterOperator childFilterOperator = this.constructPhysicalOperator(childFilter, numDocs);
                    if (childFilterOperator.isResultEmpty()) {
                        return EmptyFilterOperator.getInstance();
                    }
                    if (childFilterOperator.isResultMatchingAll()) continue;
                    childFilterOperators.add(childFilterOperator);
                }
                return FilterOperatorUtils.getAndFilterOperator(this._queryContext, childFilterOperators, numDocs);
            }
            case OR: {
                List childFilters = filter.getChildren();
                ArrayList<BaseFilterOperator> childFilterOperators = new ArrayList<BaseFilterOperator>(childFilters.size());
                for (FilterContext childFilter : childFilters) {
                    BaseFilterOperator childFilterOperator = this.constructPhysicalOperator(childFilter, numDocs);
                    if (childFilterOperator.isResultMatchingAll()) {
                        return new MatchAllFilterOperator(numDocs);
                    }
                    if (childFilterOperator.isResultEmpty()) continue;
                    childFilterOperators.add(childFilterOperator);
                }
                return FilterOperatorUtils.getOrFilterOperator(this._queryContext, childFilterOperators, numDocs);
            }
            case NOT: {
                List childFilters = filter.getChildren();
                assert (childFilters.size() == 1);
                BaseFilterOperator childFilterOperator = this.constructPhysicalOperator((FilterContext)childFilters.get(0), numDocs);
                return FilterOperatorUtils.getNotFilterOperator(this._queryContext, childFilterOperator, numDocs);
            }
            case PREDICATE: {
                Predicate predicate = filter.getPredicate();
                ExpressionContext lhs = predicate.getLhs();
                if (lhs.getType() == ExpressionContext.Type.FUNCTION) {
                    if (this.canApplyH3IndexForDistanceCheck(predicate, lhs.getFunction())) {
                        return new H3IndexFilterOperator(this._indexSegment, this._queryContext, predicate, numDocs);
                    }
                    if (this.canApplyH3IndexForInclusionCheck(predicate, lhs.getFunction())) {
                        return new H3InclusionIndexFilterOperator(this._indexSegment, this._queryContext, predicate, numDocs);
                    }
                    return new ExpressionFilterOperator(this._indexSegment, this._queryContext, predicate, numDocs);
                }
                String column = lhs.getIdentifier();
                DataSource dataSource = this._indexSegment.getDataSource(column);
                switch (predicate.getType()) {
                    case TEXT_CONTAINS: {
                        TextIndexReader textIndexReader = dataSource.getTextIndex();
                        if (!(textIndexReader instanceof NativeTextIndexReader) && !(textIndexReader instanceof NativeMutableTextIndex)) {
                            throw new UnsupportedOperationException("TEXT_CONTAINS is supported only on native text index");
                        }
                        return new TextContainsFilterOperator(textIndexReader, (TextContainsPredicate)predicate, numDocs);
                    }
                    case TEXT_MATCH: {
                        TextIndexReader textIndexReader = dataSource.getTextIndex();
                        Preconditions.checkState((textIndexReader != null ? 1 : 0) != 0, (String)"Cannot apply TEXT_MATCH on column: %s without text index", (Object)column);
                        if (textIndexReader instanceof NativeTextIndexReader || textIndexReader instanceof NativeMutableTextIndex) {
                            throw new UnsupportedOperationException("TEXT_MATCH is not supported on native text index");
                        }
                        return new TextMatchFilterOperator(textIndexReader, (TextMatchPredicate)predicate, numDocs);
                    }
                    case REGEXP_LIKE: {
                        PredicateEvaluator predicateEvaluator = dataSource.getFSTIndex() != null ? FSTBasedRegexpPredicateEvaluatorFactory.newFSTBasedEvaluator((RegexpLikePredicate)predicate, dataSource.getFSTIndex(), dataSource.getDictionary()) : PredicateEvaluatorProvider.getPredicateEvaluator(predicate, dataSource.getDictionary(), dataSource.getDataSourceMetadata().getDataType());
                        this._predicateEvaluators.add((Pair<Predicate, PredicateEvaluator>)Pair.of((Object)predicate, (Object)predicateEvaluator));
                        return FilterOperatorUtils.getLeafFilterOperator(this._queryContext, predicateEvaluator, dataSource, numDocs);
                    }
                    case JSON_MATCH: {
                        JsonIndexReader jsonIndex = dataSource.getJsonIndex();
                        Preconditions.checkState((jsonIndex != null ? 1 : 0) != 0, (String)"Cannot apply JSON_MATCH on column: %s without json index", (Object)column);
                        return new JsonMatchFilterOperator(jsonIndex, (JsonMatchPredicate)predicate, numDocs);
                    }
                    case VECTOR_SIMILARITY: {
                        VectorIndexReader vectorIndex = dataSource.getVectorIndex();
                        Preconditions.checkState((vectorIndex != null ? 1 : 0) != 0, (String)"Cannot apply VECTOR_SIMILARITY on column: %s without vector index", (Object)column);
                        return new VectorSimilarityFilterOperator(vectorIndex, (VectorSimilarityPredicate)predicate, numDocs);
                    }
                    case IS_NULL: {
                        NullValueVectorReader nullValueVector = dataSource.getNullValueVector();
                        if (nullValueVector != null) {
                            return new BitmapBasedFilterOperator(nullValueVector.getNullBitmap(), false, numDocs);
                        }
                        return EmptyFilterOperator.getInstance();
                    }
                    case IS_NOT_NULL: {
                        NullValueVectorReader nullValueVector = dataSource.getNullValueVector();
                        if (nullValueVector != null) {
                            return new BitmapBasedFilterOperator(nullValueVector.getNullBitmap(), true, numDocs);
                        }
                        return new MatchAllFilterOperator(numDocs);
                    }
                }
                PredicateEvaluator predicateEvaluator = PredicateEvaluatorProvider.getPredicateEvaluator(predicate, dataSource, this._queryContext);
                this._predicateEvaluators.add((Pair<Predicate, PredicateEvaluator>)Pair.of((Object)predicate, (Object)predicateEvaluator));
                return FilterOperatorUtils.getLeafFilterOperator(this._queryContext, predicateEvaluator, dataSource, numDocs);
            }
            case CONSTANT: {
                return filter.isConstantTrue() ? new MatchAllFilterOperator(numDocs) : EmptyFilterOperator.getInstance();
            }
        }
        throw new IllegalStateException();
    }
}

