/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.pinot.common.proto.Plan;
import org.apache.pinot.common.utils.DataSchema;

public class PinotExplainedRelNode
extends AbstractRelNode {
    private final String _type;
    private final Map<String, Plan.ExplainNode.AttributeValue> _attributes;
    private final List<RelNode> _inputs;
    private final DataSchema _dataSchema;

    public PinotExplainedRelNode(RelOptCluster cluster, String type, Map<String, Plan.ExplainNode.AttributeValue> attributes, DataSchema dataSchema, List<? extends RelNode> inputs) {
        this(cluster, RelTraitSet.createEmpty(), type, attributes, dataSchema, inputs);
    }

    public PinotExplainedRelNode(RelOptCluster cluster, RelTraitSet traitSet, String type, Map<String, Plan.ExplainNode.AttributeValue> attributes, DataSchema dataSchema, List<? extends RelNode> inputs) {
        super(cluster, traitSet);
        this._type = type;
        this._attributes = attributes;
        this._inputs = new ArrayList<RelNode>(inputs);
        this._dataSchema = dataSchema;
    }

    protected RelDataType deriveRowType() {
        int size = this._dataSchema.size();
        ArrayList<RelDataTypeFieldImpl> fields = new ArrayList<RelDataTypeFieldImpl>(size);
        RelDataTypeFactory typeFactory = this.getCluster().getTypeFactory();
        for (int i = 0; i < size; ++i) {
            String columnName = this._dataSchema.getColumnName(i);
            DataSchema.ColumnDataType columnDataType = this._dataSchema.getColumnDataType(i);
            RelDataType type = columnDataType.toType(typeFactory);
            fields.add(new RelDataTypeFieldImpl(columnName, i, type));
        }
        return new RelRecordType(fields);
    }

    public List<RelNode> getInputs() {
        return Collections.unmodifiableList(this._inputs);
    }

    public void replaceInput(int ordinalInParent, RelNode p) {
        this._inputs.set(ordinalInParent, p);
    }

    public String getRelTypeName() {
        return this._type;
    }

    public RelWriter explainTerms(RelWriter pw) {
        RelWriter relWriter = super.explainTerms(pw);
        int inputSize = this.getInputs().size();
        if (inputSize == 1) {
            relWriter.input("input", this.getInputs().get(0));
        } else if (inputSize > 1) {
            for (int i = 0; i < inputSize; ++i) {
                relWriter.input("input#" + i, this.getInputs().get(i));
            }
        }
        block7: for (Map.Entry<String, Plan.ExplainNode.AttributeValue> entry : this._attributes.entrySet()) {
            Plan.ExplainNode.AttributeValue value = entry.getValue();
            switch (value.getValueCase()) {
                case LONG: {
                    relWriter.item(entry.getKey(), (Object)value.getLong());
                    continue block7;
                }
                case STRING: {
                    relWriter.item(entry.getKey(), (Object)value.getString());
                    continue block7;
                }
                case BOOL: {
                    relWriter.item(entry.getKey(), (Object)value.getBool());
                    continue block7;
                }
                case STRINGLIST: {
                    relWriter.item(entry.getKey(), (Object)value.getStringList().getValuesList());
                    continue block7;
                }
            }
            relWriter.item(entry.getKey(), (Object)"unknown value");
        }
        return relWriter;
    }

    public Map<String, Plan.ExplainNode.AttributeValue> getAttributes() {
        return Collections.unmodifiableMap(this._attributes);
    }
}

