/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.TimeSeriesContext;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.BaseProjectOperator;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.operator.blocks.results.TimeSeriesResultsBlock;
import org.apache.pinot.core.operator.timeseries.TimeSeriesAggregationOperator;
import org.apache.pinot.core.plan.FilterPlanNode;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.plan.ProjectPlanNode;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.SegmentContext;
import org.apache.pinot.tsdb.spi.series.TimeSeriesBuilderFactory;
import org.apache.pinot.tsdb.spi.series.TimeSeriesBuilderFactoryProvider;

public class TimeSeriesPlanNode
implements PlanNode {
    private final SegmentContext _segmentContext;
    private final QueryContext _queryContext;
    private final TimeSeriesContext _timeSeriesContext;
    private final TimeSeriesBuilderFactory _seriesBuilderFactory;

    public TimeSeriesPlanNode(SegmentContext segmentContext, QueryContext queryContext) {
        this._segmentContext = segmentContext;
        this._queryContext = queryContext;
        this._timeSeriesContext = Objects.requireNonNull(queryContext.getTimeSeriesContext(), "Missing time-series context in TimeSeriesPlanNode");
        this._seriesBuilderFactory = TimeSeriesBuilderFactoryProvider.getSeriesBuilderFactory((String)this._timeSeriesContext.getLanguage());
    }

    public Operator<TimeSeriesResultsBlock> run() {
        FilterPlanNode filterPlanNode = new FilterPlanNode(this._segmentContext, this._queryContext);
        ProjectPlanNode projectPlanNode = new ProjectPlanNode(this._segmentContext, this._queryContext, this.getProjectPlanNodeExpressions(), 10000, filterPlanNode.run());
        Operator projectionOperator = projectPlanNode.run();
        return new TimeSeriesAggregationOperator(this._timeSeriesContext.getTimeColumn(), this._timeSeriesContext.getTimeUnit(), this._timeSeriesContext.getOffsetSeconds(), this._timeSeriesContext.getAggInfo(), this._timeSeriesContext.getValueExpression(), this.getGroupByColumns(), this._timeSeriesContext.getTimeBuckets(), (BaseProjectOperator<? extends ValueBlock>)projectionOperator, this._seriesBuilderFactory, this._segmentContext.getIndexSegment().getSegmentMetadata());
    }

    private List<ExpressionContext> getProjectPlanNodeExpressions() {
        ArrayList<ExpressionContext> result = new ArrayList<ExpressionContext>(this._queryContext.getSelectExpressions());
        if (CollectionUtils.isNotEmpty(this._queryContext.getGroupByExpressions())) {
            result.addAll(this._queryContext.getGroupByExpressions());
        }
        result.add(this._queryContext.getTimeSeriesContext().getValueExpression());
        result.add(ExpressionContext.forIdentifier((String)this._queryContext.getTimeSeriesContext().getTimeColumn()));
        return result;
    }

    private List<String> getGroupByColumns() {
        if (this._queryContext.getGroupByExpressions() == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> groupByColumns = new ArrayList<String>();
        for (ExpressionContext expression : this._queryContext.getGroupByExpressions()) {
            Preconditions.checkState((expression.getType() == ExpressionContext.Type.IDENTIFIER ? 1 : 0) != 0);
            groupByColumns.add(expression.getIdentifier());
        }
        return groupByColumns;
    }
}

