/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan.maker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.common.utils.config.QueryOptionsUtils;
import org.apache.pinot.core.plan.AcquireReleaseColumnsSegmentPlanNode;
import org.apache.pinot.core.plan.AggregationPlanNode;
import org.apache.pinot.core.plan.CombinePlanNode;
import org.apache.pinot.core.plan.DistinctPlanNode;
import org.apache.pinot.core.plan.GlobalPlanImplV0;
import org.apache.pinot.core.plan.GroupByPlanNode;
import org.apache.pinot.core.plan.InstanceResponsePlanNode;
import org.apache.pinot.core.plan.Plan;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.plan.SelectionPlanNode;
import org.apache.pinot.core.plan.StreamingInstanceResponsePlanNode;
import org.apache.pinot.core.plan.StreamingSelectionPlanNode;
import org.apache.pinot.core.plan.TimeSeriesPlanNode;
import org.apache.pinot.core.plan.maker.PlanMaker;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.executor.ResultsBlockStreamer;
import org.apache.pinot.core.query.prefetch.FetchPlanner;
import org.apache.pinot.core.query.prefetch.FetchPlannerRegistry;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.utils.QueryContextUtils;
import org.apache.pinot.segment.spi.FetchContext;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.SegmentContext;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstancePlanMakerImplV2
implements PlanMaker {
    public static final String MAX_EXECUTION_THREADS_KEY = "max.execution.threads";
    public static final int DEFAULT_MAX_EXECUTION_THREADS = -1;
    public static final String MAX_INITIAL_RESULT_HOLDER_CAPACITY_KEY = "max.init.group.holder.capacity";
    public static final int DEFAULT_MAX_INITIAL_RESULT_HOLDER_CAPACITY = 10000;
    public static final String MIN_INITIAL_INDEXED_TABLE_CAPACITY_KEY = "min.init.indexed.table.capacity";
    public static final int DEFAULT_MIN_INITIAL_INDEXED_TABLE_CAPACITY = 128;
    public static final String NUM_GROUPS_LIMIT_KEY = "num.groups.limit";
    public static final int DEFAULT_NUM_GROUPS_LIMIT = 100000;
    public static final String MIN_SEGMENT_GROUP_TRIM_SIZE_KEY = "min.segment.group.trim.size";
    public static final int DEFAULT_MIN_SEGMENT_GROUP_TRIM_SIZE = -1;
    public static final String MIN_SERVER_GROUP_TRIM_SIZE_KEY = "min.server.group.trim.size";
    public static final int DEFAULT_MIN_SERVER_GROUP_TRIM_SIZE = 5000;
    public static final String GROUPBY_TRIM_THRESHOLD_KEY = "groupby.trim.threshold";
    public static final int DEFAULT_GROUPBY_TRIM_THRESHOLD = 1000000;
    private static final Logger LOGGER = LoggerFactory.getLogger(InstancePlanMakerImplV2.class);
    private final FetchPlanner _fetchPlanner = FetchPlannerRegistry.getPlanner();
    private int _maxExecutionThreads = -1;
    private int _maxInitialResultHolderCapacity = 10000;
    private int _minInitialIndexedTableCapacity = 128;
    private int _numGroupsLimit = 100000;
    private int _minSegmentGroupTrimSize = -1;
    private int _minServerGroupTrimSize = 5000;
    private int _groupByTrimThreshold = 1000000;

    @Override
    public void init(PinotConfiguration queryExecutorConfig) {
        this._maxExecutionThreads = queryExecutorConfig.getProperty(MAX_EXECUTION_THREADS_KEY, -1);
        this._maxInitialResultHolderCapacity = queryExecutorConfig.getProperty(MAX_INITIAL_RESULT_HOLDER_CAPACITY_KEY, 10000);
        this._minInitialIndexedTableCapacity = queryExecutorConfig.getProperty(MIN_INITIAL_INDEXED_TABLE_CAPACITY_KEY, 128);
        this._numGroupsLimit = queryExecutorConfig.getProperty(NUM_GROUPS_LIMIT_KEY, 100000);
        Preconditions.checkState((this._maxInitialResultHolderCapacity <= this._numGroupsLimit ? 1 : 0) != 0, (String)"Invalid configuration: maxInitialResultHolderCapacity: %d must be smaller or equal to numGroupsLimit: %d", (int)this._maxInitialResultHolderCapacity, (int)this._numGroupsLimit);
        Preconditions.checkState((this._minInitialIndexedTableCapacity <= this._numGroupsLimit ? 1 : 0) != 0, (String)"Invalid configuration: minInitialIndexedTableCapacity: %d must be smaller or equal to numGroupsLimit: %d", (int)this._minInitialIndexedTableCapacity, (int)this._numGroupsLimit);
        this._minSegmentGroupTrimSize = queryExecutorConfig.getProperty(MIN_SEGMENT_GROUP_TRIM_SIZE_KEY, -1);
        this._minServerGroupTrimSize = queryExecutorConfig.getProperty(MIN_SERVER_GROUP_TRIM_SIZE_KEY, 5000);
        this._groupByTrimThreshold = queryExecutorConfig.getProperty(GROUPBY_TRIM_THRESHOLD_KEY, 1000000);
        Preconditions.checkState((this._groupByTrimThreshold > 0 ? 1 : 0) != 0, (String)"Invalid configurable: groupByTrimThreshold: %d must be positive", (int)this._groupByTrimThreshold);
        LOGGER.info("Initialized plan maker with maxExecutionThreads: {}, maxInitialResultHolderCapacity: {}, numGroupsLimit: {}, minSegmentGroupTrimSize: {}, minServerGroupTrimSize: {}, groupByTrimThreshold: {}", new Object[]{this._maxExecutionThreads, this._maxInitialResultHolderCapacity, this._numGroupsLimit, this._minSegmentGroupTrimSize, this._minServerGroupTrimSize, this._groupByTrimThreshold});
    }

    @VisibleForTesting
    public void setMaxInitialResultHolderCapacity(int maxInitialResultHolderCapacity) {
        this._maxInitialResultHolderCapacity = maxInitialResultHolderCapacity;
    }

    @VisibleForTesting
    public void setMinInitialIndexedTableCapacity(int minInitialIndexedTableCapacity) {
        this._minInitialIndexedTableCapacity = minInitialIndexedTableCapacity;
    }

    @VisibleForTesting
    public void setNumGroupsLimit(int numGroupsLimit) {
        this._numGroupsLimit = numGroupsLimit;
    }

    @VisibleForTesting
    public void setMinSegmentGroupTrimSize(int minSegmentGroupTrimSize) {
        this._minSegmentGroupTrimSize = minSegmentGroupTrimSize;
    }

    @VisibleForTesting
    public void setMinServerGroupTrimSize(int minServerGroupTrimSize) {
        this._minServerGroupTrimSize = minServerGroupTrimSize;
    }

    @VisibleForTesting
    public void setGroupByTrimThreshold(int groupByTrimThreshold) {
        this._groupByTrimThreshold = groupByTrimThreshold;
    }

    @Override
    public Plan makeInstancePlan(List<SegmentContext> segmentContexts, QueryContext queryContext, ExecutorService executorService, ServerMetrics serverMetrics) {
        List<FetchContext> fetchContexts;
        this.applyQueryOptions(queryContext);
        int numSegments = segmentContexts.size();
        ArrayList<PlanNode> planNodes = new ArrayList<PlanNode>(numSegments);
        if (queryContext.isEnablePrefetch()) {
            fetchContexts = new ArrayList(numSegments);
            for (SegmentContext segmentContext : segmentContexts) {
                FetchContext fetchContext = this._fetchPlanner.planFetchForProcessing(segmentContext.getIndexSegment(), queryContext);
                fetchContexts.add(fetchContext);
                planNodes.add(new AcquireReleaseColumnsSegmentPlanNode(this.makeSegmentPlanNode(segmentContext, queryContext), segmentContext, fetchContext));
            }
        } else {
            fetchContexts = Collections.emptyList();
            for (SegmentContext segmentContext : segmentContexts) {
                planNodes.add(this.makeSegmentPlanNode(segmentContext, queryContext));
            }
        }
        CombinePlanNode combinePlanNode = new CombinePlanNode(planNodes, queryContext, executorService, null);
        return new GlobalPlanImplV0(new InstanceResponsePlanNode(combinePlanNode, segmentContexts, fetchContexts, queryContext));
    }

    private void applyQueryOptions(QueryContext queryContext) {
        Map<String, String> queryOptions = queryContext.getQueryOptions();
        queryContext.setSkipUpsert(QueryOptionsUtils.isSkipUpsert(queryOptions));
        queryContext.setSkipStarTree(QueryOptionsUtils.isSkipStarTree(queryOptions));
        queryContext.setSkipScanFilterReorder(QueryOptionsUtils.isSkipScanFilterReorder(queryOptions));
        queryContext.setSkipIndexes(QueryOptionsUtils.getSkipIndexes(queryOptions));
        Integer maxExecutionThreadsFromQuery = QueryOptionsUtils.getMaxExecutionThreads(queryOptions);
        int maxExecutionThreads = maxExecutionThreadsFromQuery != null ? (this._maxExecutionThreads > 0 ? Math.min(this._maxExecutionThreads, maxExecutionThreadsFromQuery) : maxExecutionThreadsFromQuery) : this._maxExecutionThreads;
        queryContext.setMaxExecutionThreads(maxExecutionThreads);
        if (QueryContextUtils.isAggregationQuery(queryContext) && queryContext.getGroupByExpressions() != null) {
            Integer maxInitialResultHolderCapacity = QueryOptionsUtils.getMaxInitialResultHolderCapacity(queryOptions);
            if (maxInitialResultHolderCapacity != null) {
                queryContext.setMaxInitialResultHolderCapacity(maxInitialResultHolderCapacity);
            } else {
                queryContext.setMaxInitialResultHolderCapacity(this._maxInitialResultHolderCapacity);
            }
            Integer minInitialIndexedTableCapacity = QueryOptionsUtils.getMinInitialIndexedTableCapacity(queryOptions);
            if (minInitialIndexedTableCapacity != null) {
                queryContext.setMinInitialIndexedTableCapacity(minInitialIndexedTableCapacity);
            } else {
                queryContext.setMinInitialIndexedTableCapacity(this._minInitialIndexedTableCapacity);
            }
            Integer numGroupsLimit = QueryOptionsUtils.getNumGroupsLimit(queryOptions);
            if (numGroupsLimit != null) {
                queryContext.setNumGroupsLimit(numGroupsLimit);
            } else {
                queryContext.setNumGroupsLimit(this._numGroupsLimit);
            }
            Integer minSegmentGroupTrimSizeFromQuery = QueryOptionsUtils.getMinSegmentGroupTrimSize(queryOptions);
            if (minSegmentGroupTrimSizeFromQuery != null) {
                queryContext.setMinSegmentGroupTrimSize(minSegmentGroupTrimSizeFromQuery);
            } else {
                queryContext.setMinSegmentGroupTrimSize(this._minSegmentGroupTrimSize);
            }
            Integer minServerGroupTrimSizeFromQuery = QueryOptionsUtils.getMinServerGroupTrimSize(queryOptions);
            int minServerGroupTrimSize = minServerGroupTrimSizeFromQuery != null ? minServerGroupTrimSizeFromQuery : this._minServerGroupTrimSize;
            queryContext.setMinServerGroupTrimSize(minServerGroupTrimSize);
            Integer groupTrimThreshold = QueryOptionsUtils.getGroupTrimThreshold(queryOptions);
            if (groupTrimThreshold != null) {
                queryContext.setGroupTrimThreshold(groupTrimThreshold);
            } else {
                queryContext.setGroupTrimThreshold(this._groupByTrimThreshold);
            }
        }
    }

    @Override
    public PlanNode makeSegmentPlanNode(SegmentContext segmentContext, QueryContext queryContext) {
        InstancePlanMakerImplV2.rewriteQueryContextWithHints(queryContext, segmentContext.getIndexSegment());
        if (QueryContextUtils.isTimeSeriesQuery(queryContext)) {
            return new TimeSeriesPlanNode(segmentContext, queryContext);
        }
        if (QueryContextUtils.isAggregationQuery(queryContext)) {
            List<ExpressionContext> groupByExpressions = queryContext.getGroupByExpressions();
            if (groupByExpressions != null) {
                return new GroupByPlanNode(segmentContext, queryContext);
            }
            return new AggregationPlanNode(segmentContext, queryContext);
        }
        if (QueryContextUtils.isSelectionQuery(queryContext)) {
            return new SelectionPlanNode(segmentContext, queryContext);
        }
        assert (QueryContextUtils.isDistinctQuery(queryContext));
        return new DistinctPlanNode(segmentContext, queryContext);
    }

    @Override
    public Plan makeStreamingInstancePlan(List<SegmentContext> segmentContexts, QueryContext queryContext, ExecutorService executorService, ResultsBlockStreamer streamer, ServerMetrics serverMetrics) {
        List<FetchContext> fetchContexts;
        this.applyQueryOptions(queryContext);
        int numSegments = segmentContexts.size();
        ArrayList<PlanNode> planNodes = new ArrayList<PlanNode>(numSegments);
        if (queryContext.isEnablePrefetch()) {
            fetchContexts = new ArrayList(numSegments);
            for (SegmentContext segmentContext : segmentContexts) {
                FetchContext fetchContext = this._fetchPlanner.planFetchForProcessing(segmentContext.getIndexSegment(), queryContext);
                fetchContexts.add(fetchContext);
                planNodes.add(new AcquireReleaseColumnsSegmentPlanNode(this.makeStreamingSegmentPlanNode(segmentContext, queryContext), segmentContext, fetchContext));
            }
        } else {
            fetchContexts = Collections.emptyList();
            for (SegmentContext segmentContext : segmentContexts) {
                planNodes.add(this.makeStreamingSegmentPlanNode(segmentContext, queryContext));
            }
        }
        CombinePlanNode combinePlanNode = new CombinePlanNode(planNodes, queryContext, executorService, streamer);
        return new GlobalPlanImplV0(new StreamingInstanceResponsePlanNode(combinePlanNode, segmentContexts, fetchContexts, queryContext, streamer));
    }

    @Override
    public PlanNode makeStreamingSegmentPlanNode(SegmentContext segmentContext, QueryContext queryContext) {
        if (QueryContextUtils.isSelectionOnlyQuery(queryContext) && queryContext.getLimit() != 0) {
            InstancePlanMakerImplV2.rewriteQueryContextWithHints(queryContext, segmentContext.getIndexSegment());
            return new StreamingSelectionPlanNode(segmentContext, queryContext);
        }
        return this.makeSegmentPlanNode(segmentContext, queryContext);
    }

    @VisibleForTesting
    public static void rewriteQueryContextWithHints(QueryContext queryContext, IndexSegment indexSegment) {
        FilterContext havingFilter;
        FilterContext filter;
        List<OrderByExpressionContext> orderByExpressions;
        List<ExpressionContext> groupByExpressions;
        Map<ExpressionContext, ExpressionContext> expressionOverrideHints = queryContext.getExpressionOverrideHints();
        if (MapUtils.isEmpty(expressionOverrideHints)) {
            return;
        }
        List<ExpressionContext> selectExpressions = queryContext.getSelectExpressions();
        selectExpressions.replaceAll(expression -> InstancePlanMakerImplV2.overrideWithExpressionHints(expression, indexSegment, expressionOverrideHints));
        List<Pair<AggregationFunction, FilterContext>> filtAggrFuns = queryContext.getFilteredAggregationFunctions();
        if (filtAggrFuns != null) {
            for (Pair<AggregationFunction, FilterContext> filteredAggregationFunction : filtAggrFuns) {
                FilterContext right = (FilterContext)filteredAggregationFunction.getRight();
                if (right == null) continue;
                Predicate predicate = right.getPredicate();
                predicate.setLhs(InstancePlanMakerImplV2.overrideWithExpressionHints(predicate.getLhs(), indexSegment, expressionOverrideHints));
            }
        }
        if (CollectionUtils.isNotEmpty(groupByExpressions = queryContext.getGroupByExpressions())) {
            groupByExpressions.replaceAll(expression -> InstancePlanMakerImplV2.overrideWithExpressionHints(expression, indexSegment, expressionOverrideHints));
        }
        if (CollectionUtils.isNotEmpty(orderByExpressions = queryContext.getOrderByExpressions())) {
            orderByExpressions.replaceAll(expression -> new OrderByExpressionContext(InstancePlanMakerImplV2.overrideWithExpressionHints(expression.getExpression(), indexSegment, expressionOverrideHints), expression.isAsc()));
        }
        if ((filter = queryContext.getFilter()) != null) {
            InstancePlanMakerImplV2.overrideWithExpressionHints(filter, indexSegment, expressionOverrideHints);
        }
        if ((havingFilter = queryContext.getHavingFilter()) != null) {
            InstancePlanMakerImplV2.overrideWithExpressionHints(havingFilter, indexSegment, expressionOverrideHints);
        }
    }

    @VisibleForTesting
    public static void overrideWithExpressionHints(FilterContext filter, IndexSegment indexSegment, Map<ExpressionContext, ExpressionContext> expressionOverrideHints) {
        if (filter.getChildren() != null) {
            for (FilterContext child : filter.getChildren()) {
                InstancePlanMakerImplV2.overrideWithExpressionHints(child, indexSegment, expressionOverrideHints);
            }
        } else {
            Predicate predicate = filter.getPredicate();
            predicate.setLhs(InstancePlanMakerImplV2.overrideWithExpressionHints(predicate.getLhs(), indexSegment, expressionOverrideHints));
        }
    }

    @VisibleForTesting
    public static ExpressionContext overrideWithExpressionHints(ExpressionContext expression, IndexSegment indexSegment, Map<ExpressionContext, ExpressionContext> expressionOverrideHints) {
        if (expression.getType() != ExpressionContext.Type.FUNCTION) {
            return expression;
        }
        ExpressionContext overrideExpression = expressionOverrideHints.get(expression);
        if (overrideExpression != null && overrideExpression.getIdentifier() != null && indexSegment.getColumnNames().contains(overrideExpression.getIdentifier())) {
            return overrideExpression;
        }
        expression.getFunction().getArguments().replaceAll(argument -> InstancePlanMakerImplV2.overrideWithExpressionHints(argument, indexSegment, expressionOverrideHints));
        return expression;
    }
}

