/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation;

import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.query.aggregation.AggregationExecutor;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;

public class DefaultAggregationExecutor
implements AggregationExecutor {
    protected final AggregationFunction[] _aggregationFunctions;
    protected final AggregationResultHolder[] _aggregationResultHolders;

    public DefaultAggregationExecutor(AggregationFunction[] aggregationFunctions) {
        this._aggregationFunctions = aggregationFunctions;
        int numAggregationFunctions = aggregationFunctions.length;
        this._aggregationResultHolders = new AggregationResultHolder[numAggregationFunctions];
        for (int i = 0; i < numAggregationFunctions; ++i) {
            this._aggregationResultHolders[i] = aggregationFunctions[i].createAggregationResultHolder();
        }
    }

    @Override
    public void aggregate(ValueBlock valueBlock) {
        int numAggregationFunctions = this._aggregationFunctions.length;
        int length = valueBlock.getNumDocs();
        for (int i = 0; i < numAggregationFunctions; ++i) {
            AggregationFunction aggregationFunction = this._aggregationFunctions[i];
            aggregationFunction.aggregate(length, this._aggregationResultHolders[i], AggregationFunctionUtils.getBlockValSetMap(aggregationFunction, valueBlock));
        }
    }

    @Override
    public List<Object> getResult() {
        int numFunctions = this._aggregationFunctions.length;
        ArrayList<Object> aggregationResults = new ArrayList<Object>(numFunctions);
        for (int i = 0; i < numFunctions; ++i) {
            aggregationResults.add(this._aggregationFunctions[i].extractAggregationResult(this._aggregationResultHolders[i]));
        }
        return aggregationResults;
    }
}

