/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.datasketches.tuple.aninteger.IntegerSummary;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AvgAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AvgMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AvgValueIntegerTupleSketchAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.BooleanAndAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.BooleanOrAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.ChildExprMinMaxAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.CountAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.CountMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.CovarianceAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctAvgAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctAvgMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountBitmapAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountBitmapMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountCPCSketchAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountHLLAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountHLLMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountHLLPlusAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountHLLPlusMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountIntegerTupleSketchAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountRawCPCSketchAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountRawHLLAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountRawHLLMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountRawHLLPlusAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountRawHLLPlusMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountRawThetaSketchAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountRawULLAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountSmartHLLAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountThetaSketchAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctCountULLAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctSumAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctSumMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.FastHLLAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.FirstDoubleValueWithTimeAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.FirstFloatValueWithTimeAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.FirstIntValueWithTimeAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.FirstLongValueWithTimeAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.FirstStringValueWithTimeAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.FourthMomentAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.FrequentLongsSketchAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.FrequentStringsSketchAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.HistogramAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.IdSetAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.IntegerTupleSketchAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.LastDoubleValueWithTimeAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.LastFloatValueWithTimeAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.LastIntValueWithTimeAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.LastLongValueWithTimeAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.LastStringValueWithTimeAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.MaxAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.MaxMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.MinAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.MinMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.MinMaxRangeAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.MinMaxRangeMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.ModeAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.ParentExprMinMaxAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileEstAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileEstMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileKLLAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileKLLMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileRawEstAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileRawEstMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileRawKLLAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileRawKLLMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileRawTDigestAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileRawTDigestMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileSmartTDigestAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileTDigestAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.PercentileTDigestMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.SegmentPartitionedDistinctCountAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.StUnionAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.SumAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.SumMVAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.SumPrecisionAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.SumValuesIntegerTupleSketchAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.VarianceAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.array.ArrayAggDistinctDoubleFunction;
import org.apache.pinot.core.query.aggregation.function.array.ArrayAggDistinctFloatFunction;
import org.apache.pinot.core.query.aggregation.function.array.ArrayAggDistinctIntFunction;
import org.apache.pinot.core.query.aggregation.function.array.ArrayAggDistinctLongFunction;
import org.apache.pinot.core.query.aggregation.function.array.ArrayAggDistinctStringFunction;
import org.apache.pinot.core.query.aggregation.function.array.ArrayAggDoubleFunction;
import org.apache.pinot.core.query.aggregation.function.array.ArrayAggFloatFunction;
import org.apache.pinot.core.query.aggregation.function.array.ArrayAggIntFunction;
import org.apache.pinot.core.query.aggregation.function.array.ArrayAggLongFunction;
import org.apache.pinot.core.query.aggregation.function.array.ArrayAggStringFunction;
import org.apache.pinot.core.query.aggregation.function.array.ListAggDistinctFunction;
import org.apache.pinot.core.query.aggregation.function.array.ListAggFunction;
import org.apache.pinot.core.query.aggregation.function.array.SumArrayDoubleAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.array.SumArrayLongAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.funnel.FunnelCountAggregationFunctionFactory;
import org.apache.pinot.core.query.aggregation.function.funnel.window.FunnelCompleteCountAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.funnel.window.FunnelMatchStepAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.funnel.window.FunnelMaxStepAggregationFunction;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.exception.BadQueryRequestException;

public class AggregationFunctionFactory {
    private AggregationFunctionFactory() {
    }

    public static AggregationFunction getAggregationFunction(FunctionContext function, boolean nullHandlingEnabled) {
        try {
            String upperCaseFunctionName = AggregationFunctionType.getNormalizedAggregationFunctionName((String)function.getFunctionName());
            List arguments = function.getArguments();
            int numArguments = arguments.size();
            ExpressionContext firstArgument = (ExpressionContext)arguments.get(0);
            if (upperCaseFunctionName.startsWith("PERCENTILE")) {
                String remainingFunctionName = upperCaseFunctionName.substring(10);
                if (remainingFunctionName.equals("SMARTTDIGEST")) {
                    return new PercentileSmartTDigestAggregationFunction(arguments, nullHandlingEnabled);
                }
                if (remainingFunctionName.equals("KLL")) {
                    return new PercentileKLLAggregationFunction(arguments, nullHandlingEnabled);
                }
                if (remainingFunctionName.equals("KLLMV")) {
                    return new PercentileKLLMVAggregationFunction(arguments);
                }
                if (remainingFunctionName.equals("RAWKLL")) {
                    return new PercentileRawKLLAggregationFunction(arguments, nullHandlingEnabled);
                }
                if (remainingFunctionName.equals("RAWKLLMV")) {
                    return new PercentileRawKLLMVAggregationFunction(arguments);
                }
                if (numArguments == 1) {
                    if (remainingFunctionName.matches("\\d+")) {
                        return new PercentileAggregationFunction(firstArgument, AggregationFunctionFactory.parsePercentileToInt(remainingFunctionName), nullHandlingEnabled);
                    }
                    if (remainingFunctionName.matches("EST\\d+")) {
                        String percentileString = remainingFunctionName.substring(3);
                        return new PercentileEstAggregationFunction(firstArgument, AggregationFunctionFactory.parsePercentileToInt(percentileString), nullHandlingEnabled);
                    }
                    if (remainingFunctionName.matches("RAWEST\\d+")) {
                        String percentileString = remainingFunctionName.substring(6);
                        return new PercentileRawEstAggregationFunction(firstArgument, AggregationFunctionFactory.parsePercentileToInt(percentileString), nullHandlingEnabled);
                    }
                    if (remainingFunctionName.matches("TDIGEST\\d+")) {
                        String percentileString = remainingFunctionName.substring(7);
                        return new PercentileTDigestAggregationFunction(firstArgument, AggregationFunctionFactory.parsePercentileToInt(percentileString), nullHandlingEnabled);
                    }
                    if (remainingFunctionName.matches("RAWTDIGEST\\d+")) {
                        String percentileString = remainingFunctionName.substring(10);
                        return new PercentileRawTDigestAggregationFunction(firstArgument, AggregationFunctionFactory.parsePercentileToInt(percentileString), nullHandlingEnabled);
                    }
                    if (remainingFunctionName.matches("\\d+MV")) {
                        String percentileString = remainingFunctionName.substring(0, remainingFunctionName.length() - 2);
                        return new PercentileMVAggregationFunction(firstArgument, AggregationFunctionFactory.parsePercentileToInt(percentileString));
                    }
                    if (remainingFunctionName.matches("EST\\d+MV")) {
                        String percentileString = remainingFunctionName.substring(3, remainingFunctionName.length() - 2);
                        return new PercentileEstMVAggregationFunction(firstArgument, AggregationFunctionFactory.parsePercentileToInt(percentileString));
                    }
                    if (remainingFunctionName.matches("RAWEST\\d+MV")) {
                        String percentileString = remainingFunctionName.substring(6, remainingFunctionName.length() - 2);
                        return new PercentileRawEstMVAggregationFunction(firstArgument, AggregationFunctionFactory.parsePercentileToInt(percentileString));
                    }
                    if (remainingFunctionName.matches("TDIGEST\\d+MV")) {
                        String percentileString = remainingFunctionName.substring(7, remainingFunctionName.length() - 2);
                        return new PercentileTDigestMVAggregationFunction(firstArgument, AggregationFunctionFactory.parsePercentileToInt(percentileString));
                    }
                    if (remainingFunctionName.matches("RAWTDIGEST\\d+MV")) {
                        String percentileString = remainingFunctionName.substring(10, remainingFunctionName.length() - 2);
                        return new PercentileRawTDigestMVAggregationFunction(firstArgument, AggregationFunctionFactory.parsePercentileToInt(percentileString));
                    }
                } else if (numArguments == 2) {
                    double percentile = ((ExpressionContext)arguments.get(1)).getLiteral().getDoubleValue();
                    Preconditions.checkArgument((percentile >= 0.0 && percentile <= 100.0 ? 1 : 0) != 0, (String)"Invalid percentile: %s", (Object)percentile);
                    if (remainingFunctionName.isEmpty()) {
                        return new PercentileAggregationFunction(firstArgument, percentile, nullHandlingEnabled);
                    }
                    if (remainingFunctionName.equals("EST")) {
                        return new PercentileEstAggregationFunction(firstArgument, percentile, nullHandlingEnabled);
                    }
                    if (remainingFunctionName.equals("RAWEST")) {
                        return new PercentileRawEstAggregationFunction(firstArgument, percentile, nullHandlingEnabled);
                    }
                    if (remainingFunctionName.equals("TDIGEST")) {
                        return new PercentileTDigestAggregationFunction(firstArgument, percentile, nullHandlingEnabled);
                    }
                    if (remainingFunctionName.equals("RAWTDIGEST")) {
                        return new PercentileRawTDigestAggregationFunction(firstArgument, percentile, nullHandlingEnabled);
                    }
                    if (remainingFunctionName.equals("MV")) {
                        return new PercentileMVAggregationFunction(firstArgument, percentile);
                    }
                    if (remainingFunctionName.equals("ESTMV")) {
                        return new PercentileEstMVAggregationFunction(firstArgument, percentile);
                    }
                    if (remainingFunctionName.equals("RAWESTMV")) {
                        return new PercentileRawEstMVAggregationFunction(firstArgument, percentile);
                    }
                    if (remainingFunctionName.equals("TDIGESTMV")) {
                        return new PercentileTDigestMVAggregationFunction(firstArgument, percentile);
                    }
                    if (remainingFunctionName.equals("RAWTDIGESTMV")) {
                        return new PercentileRawTDigestMVAggregationFunction(firstArgument, percentile);
                    }
                } else if (numArguments == 3) {
                    double percentile = ((ExpressionContext)arguments.get(1)).getLiteral().getDoubleValue();
                    Preconditions.checkArgument((percentile >= 0.0 && percentile <= 100.0 ? 1 : 0) != 0, (String)"Invalid percentile: %s", (Object)percentile);
                    int compressionFactor = ((ExpressionContext)arguments.get(2)).getLiteral().getIntValue();
                    Preconditions.checkArgument((compressionFactor >= 0 ? 1 : 0) != 0, (String)"Invalid compressionFactor: %d", (int)compressionFactor);
                    if (remainingFunctionName.equals("TDIGEST")) {
                        return new PercentileTDigestAggregationFunction(firstArgument, percentile, compressionFactor, nullHandlingEnabled);
                    }
                    if (remainingFunctionName.equals("RAWTDIGEST")) {
                        return new PercentileRawTDigestAggregationFunction(firstArgument, percentile, compressionFactor, nullHandlingEnabled);
                    }
                    if (remainingFunctionName.equals("TDIGESTMV")) {
                        return new PercentileTDigestMVAggregationFunction(firstArgument, percentile, compressionFactor);
                    }
                    if (remainingFunctionName.equals("RAWTDIGESTMV")) {
                        return new PercentileRawTDigestMVAggregationFunction(firstArgument, percentile, compressionFactor);
                    }
                }
                throw new IllegalArgumentException("Invalid percentile function: " + function);
            }
            AggregationFunctionType functionType = AggregationFunctionType.valueOf((String)upperCaseFunctionName);
            switch (functionType) {
                case COUNT: {
                    return new CountAggregationFunction(arguments, nullHandlingEnabled);
                }
                case MIN: {
                    return new MinAggregationFunction(arguments, nullHandlingEnabled);
                }
                case MAX: {
                    return new MaxAggregationFunction(arguments, nullHandlingEnabled);
                }
                case SUM: 
                case SUM0: {
                    return new SumAggregationFunction(arguments, nullHandlingEnabled);
                }
                case SUMPRECISION: {
                    return new SumPrecisionAggregationFunction(arguments, nullHandlingEnabled);
                }
                case AVG: {
                    return new AvgAggregationFunction(arguments, nullHandlingEnabled);
                }
                case MODE: {
                    return new ModeAggregationFunction(arguments, nullHandlingEnabled);
                }
                case FIRSTWITHTIME: {
                    Preconditions.checkArgument((numArguments == 3 ? 1 : 0) != 0, (String)"FIRST_WITH_TIME expects 3 arguments, got: %s. The function can be used as firstWithTime(dataColumn, timeColumn, 'dataType')", (int)numArguments);
                    ExpressionContext timeCol = (ExpressionContext)arguments.get(1);
                    ExpressionContext dataTypeExp = (ExpressionContext)arguments.get(2);
                    Preconditions.checkArgument((dataTypeExp.getType() == ExpressionContext.Type.LITERAL ? 1 : 0) != 0, (String)"FIRST_WITH_TIME expects the 3rd argument to be literal, got: %s. The function can be used as firstWithTime(dataColumn, timeColumn, 'dataType')", (Object)dataTypeExp.getType());
                    FieldSpec.DataType dataType = FieldSpec.DataType.valueOf((String)dataTypeExp.getLiteral().getStringValue().toUpperCase());
                    switch (dataType) {
                        case BOOLEAN: {
                            return new FirstIntValueWithTimeAggregationFunction(firstArgument, timeCol, nullHandlingEnabled, true);
                        }
                        case INT: {
                            return new FirstIntValueWithTimeAggregationFunction(firstArgument, timeCol, nullHandlingEnabled, false);
                        }
                        case LONG: {
                            return new FirstLongValueWithTimeAggregationFunction(firstArgument, timeCol, nullHandlingEnabled);
                        }
                        case FLOAT: {
                            return new FirstFloatValueWithTimeAggregationFunction(firstArgument, timeCol, nullHandlingEnabled);
                        }
                        case DOUBLE: {
                            return new FirstDoubleValueWithTimeAggregationFunction(firstArgument, timeCol, nullHandlingEnabled);
                        }
                        case STRING: {
                            return new FirstStringValueWithTimeAggregationFunction(firstArgument, timeCol, nullHandlingEnabled);
                        }
                    }
                    throw new IllegalArgumentException("Unsupported data type for FIRST_WITH_TIME: " + dataType);
                }
                case LISTAGG: {
                    Preconditions.checkArgument((numArguments == 2 || numArguments == 3 ? 1 : 0) != 0, (String)"LISTAGG expects 2 arguments, got: %s. The function can be used as listAgg([distinct] expression, 'separator')", (int)numArguments);
                    ExpressionContext separatorExpression = (ExpressionContext)arguments.get(1);
                    Preconditions.checkArgument((separatorExpression.getType() == ExpressionContext.Type.LITERAL ? 1 : 0) != 0, (String)"LISTAGG expects the 2nd argument to be literal, got: %s. The function can be used as listAgg([distinct] expression, 'separator')", (Object)separatorExpression.getType());
                    String separator = separatorExpression.getLiteral().getStringValue();
                    boolean isDistinct = false;
                    if (numArguments == 3) {
                        ExpressionContext isDistinctListAggExp = (ExpressionContext)arguments.get(2);
                        isDistinct = isDistinctListAggExp.getLiteral().getBooleanValue();
                    }
                    if (isDistinct) {
                        return new ListAggDistinctFunction((ExpressionContext)arguments.get(0), separator, nullHandlingEnabled);
                    }
                    return new ListAggFunction((ExpressionContext)arguments.get(0), separator, nullHandlingEnabled);
                }
                case SUMARRAYLONG: {
                    return new SumArrayLongAggregationFunction(arguments);
                }
                case SUMARRAYDOUBLE: {
                    return new SumArrayDoubleAggregationFunction(arguments);
                }
                case ARRAYAGG: {
                    Preconditions.checkArgument((numArguments >= 2 ? 1 : 0) != 0, (String)"ARRAY_AGG expects 2 or 3 arguments, got: %s. The function can be used as arrayAgg(dataColumn, 'dataType', ['isDistinct'])", (int)numArguments);
                    ExpressionContext dataTypeExp = (ExpressionContext)arguments.get(1);
                    Preconditions.checkArgument((dataTypeExp.getType() == ExpressionContext.Type.LITERAL ? 1 : 0) != 0, (String)"ARRAY_AGG expects the 2nd argument to be literal, got: %s. The function can be used as arrayAgg(dataColumn, 'dataType', ['isDistinct'])", (Object)dataTypeExp.getType());
                    FieldSpec.DataType dataType = FieldSpec.DataType.valueOf((String)dataTypeExp.getLiteral().getStringValue().toUpperCase());
                    boolean isDistinct = false;
                    if (numArguments == 3) {
                        ExpressionContext isDistinctExp = (ExpressionContext)arguments.get(2);
                        Preconditions.checkArgument((isDistinctExp.getType() == ExpressionContext.Type.LITERAL ? 1 : 0) != 0, (String)"ARRAY_AGG expects the 3rd argument to be literal, got: %s. The function can be used as arrayAgg(dataColumn, 'dataType', ['isDistinct'])", (Object)isDistinctExp.getType());
                        isDistinct = isDistinctExp.getLiteral().getBooleanValue();
                    }
                    if (isDistinct) {
                        switch (dataType) {
                            case BOOLEAN: 
                            case INT: {
                                return new ArrayAggDistinctIntFunction(firstArgument, dataType, nullHandlingEnabled);
                            }
                            case LONG: 
                            case TIMESTAMP: {
                                return new ArrayAggDistinctLongFunction(firstArgument, dataType, nullHandlingEnabled);
                            }
                            case FLOAT: {
                                return new ArrayAggDistinctFloatFunction(firstArgument, nullHandlingEnabled);
                            }
                            case DOUBLE: {
                                return new ArrayAggDistinctDoubleFunction(firstArgument, nullHandlingEnabled);
                            }
                            case STRING: {
                                return new ArrayAggDistinctStringFunction(firstArgument, nullHandlingEnabled);
                            }
                        }
                        throw new IllegalArgumentException("Unsupported data type for ARRAY_AGG: " + dataType);
                    }
                    switch (dataType) {
                        case BOOLEAN: 
                        case INT: {
                            return new ArrayAggIntFunction(firstArgument, dataType, nullHandlingEnabled);
                        }
                        case LONG: 
                        case TIMESTAMP: {
                            return new ArrayAggLongFunction(firstArgument, dataType, nullHandlingEnabled);
                        }
                        case FLOAT: {
                            return new ArrayAggFloatFunction(firstArgument, nullHandlingEnabled);
                        }
                        case DOUBLE: {
                            return new ArrayAggDoubleFunction(firstArgument, nullHandlingEnabled);
                        }
                        case STRING: {
                            return new ArrayAggStringFunction(firstArgument, nullHandlingEnabled);
                        }
                    }
                    throw new IllegalArgumentException("Unsupported data type for ARRAY_AGG: " + dataType);
                }
                case LASTWITHTIME: {
                    Preconditions.checkArgument((numArguments == 3 ? 1 : 0) != 0, (String)"LAST_WITH_TIME expects 3 arguments, got: %s. The function can be used as lastWithTime(dataColumn, timeColumn, 'dataType')", (int)numArguments);
                    ExpressionContext timeCol = (ExpressionContext)arguments.get(1);
                    ExpressionContext dataTypeExp = (ExpressionContext)arguments.get(2);
                    Preconditions.checkArgument((dataTypeExp.getType() == ExpressionContext.Type.LITERAL ? 1 : 0) != 0, (String)"LAST_WITH_TIME expects the 3rd argument to be literal, got: %s. The function can be used as lastWithTime(dataColumn, timeColumn, 'dataType')", (Object)dataTypeExp.getType());
                    FieldSpec.DataType dataType = FieldSpec.DataType.valueOf((String)dataTypeExp.getLiteral().getStringValue().toUpperCase());
                    switch (dataType) {
                        case BOOLEAN: {
                            return new LastIntValueWithTimeAggregationFunction(firstArgument, timeCol, nullHandlingEnabled, true);
                        }
                        case INT: {
                            return new LastIntValueWithTimeAggregationFunction(firstArgument, timeCol, nullHandlingEnabled, false);
                        }
                        case LONG: {
                            return new LastLongValueWithTimeAggregationFunction(firstArgument, timeCol, nullHandlingEnabled);
                        }
                        case FLOAT: {
                            return new LastFloatValueWithTimeAggregationFunction(firstArgument, timeCol, nullHandlingEnabled);
                        }
                        case DOUBLE: {
                            return new LastDoubleValueWithTimeAggregationFunction(firstArgument, timeCol, nullHandlingEnabled);
                        }
                        case STRING: {
                            return new LastStringValueWithTimeAggregationFunction(firstArgument, timeCol, nullHandlingEnabled);
                        }
                    }
                    throw new IllegalArgumentException("Unsupported data type for LAST_WITH_TIME: " + dataType);
                }
                case MINMAXRANGE: {
                    return new MinMaxRangeAggregationFunction(arguments, nullHandlingEnabled);
                }
                case DISTINCTCOUNT: {
                    return new DistinctCountAggregationFunction(arguments, nullHandlingEnabled);
                }
                case DISTINCTCOUNTBITMAP: {
                    return new DistinctCountBitmapAggregationFunction(arguments);
                }
                case SEGMENTPARTITIONEDDISTINCTCOUNT: {
                    return new SegmentPartitionedDistinctCountAggregationFunction(arguments);
                }
                case DISTINCTCOUNTHLL: {
                    return new DistinctCountHLLAggregationFunction(arguments);
                }
                case DISTINCTCOUNTRAWHLL: {
                    return new DistinctCountRawHLLAggregationFunction(arguments);
                }
                case DISTINCTCOUNTSMARTHLL: {
                    return new DistinctCountSmartHLLAggregationFunction(arguments);
                }
                case FASTHLL: {
                    return new FastHLLAggregationFunction(arguments);
                }
                case DISTINCTCOUNTTHETASKETCH: {
                    return new DistinctCountThetaSketchAggregationFunction(arguments);
                }
                case DISTINCTCOUNTRAWTHETASKETCH: {
                    return new DistinctCountRawThetaSketchAggregationFunction(arguments);
                }
                case DISTINCTSUM: {
                    return new DistinctSumAggregationFunction(arguments, nullHandlingEnabled);
                }
                case DISTINCTAVG: {
                    return new DistinctAvgAggregationFunction(arguments, nullHandlingEnabled);
                }
                case IDSET: {
                    return new IdSetAggregationFunction(arguments);
                }
                case COUNTMV: {
                    return new CountMVAggregationFunction(arguments);
                }
                case MINMV: {
                    return new MinMVAggregationFunction(arguments);
                }
                case MAXMV: {
                    return new MaxMVAggregationFunction(arguments);
                }
                case SUMMV: {
                    return new SumMVAggregationFunction(arguments);
                }
                case AVGMV: {
                    return new AvgMVAggregationFunction(arguments);
                }
                case MINMAXRANGEMV: {
                    return new MinMaxRangeMVAggregationFunction(arguments);
                }
                case DISTINCTCOUNTMV: {
                    return new DistinctCountMVAggregationFunction(arguments);
                }
                case DISTINCTCOUNTBITMAPMV: {
                    return new DistinctCountBitmapMVAggregationFunction(arguments);
                }
                case DISTINCTCOUNTHLLMV: {
                    return new DistinctCountHLLMVAggregationFunction(arguments);
                }
                case DISTINCTCOUNTRAWHLLMV: {
                    return new DistinctCountRawHLLMVAggregationFunction(arguments);
                }
                case DISTINCTCOUNTHLLPLUS: {
                    return new DistinctCountHLLPlusAggregationFunction(arguments);
                }
                case DISTINCTCOUNTRAWHLLPLUS: {
                    return new DistinctCountRawHLLPlusAggregationFunction(arguments);
                }
                case DISTINCTCOUNTHLLPLUSMV: {
                    return new DistinctCountHLLPlusMVAggregationFunction(arguments);
                }
                case DISTINCTCOUNTRAWHLLPLUSMV: {
                    return new DistinctCountRawHLLPlusMVAggregationFunction(arguments);
                }
                case DISTINCTSUMMV: {
                    return new DistinctSumMVAggregationFunction(arguments);
                }
                case DISTINCTAVGMV: {
                    return new DistinctAvgMVAggregationFunction(arguments);
                }
                case STUNION: {
                    return new StUnionAggregationFunction(arguments);
                }
                case HISTOGRAM: {
                    return new HistogramAggregationFunction(arguments);
                }
                case COVARPOP: {
                    return new CovarianceAggregationFunction(arguments, false);
                }
                case COVARSAMP: {
                    return new CovarianceAggregationFunction(arguments, true);
                }
                case BOOLAND: {
                    return new BooleanAndAggregationFunction(arguments, nullHandlingEnabled);
                }
                case BOOLOR: {
                    return new BooleanOrAggregationFunction(arguments, nullHandlingEnabled);
                }
                case VARPOP: {
                    return new VarianceAggregationFunction(arguments, false, false, nullHandlingEnabled);
                }
                case VARSAMP: {
                    return new VarianceAggregationFunction(arguments, true, false, nullHandlingEnabled);
                }
                case STDDEVPOP: {
                    return new VarianceAggregationFunction(arguments, false, true, nullHandlingEnabled);
                }
                case STDDEVSAMP: {
                    return new VarianceAggregationFunction(arguments, true, true, nullHandlingEnabled);
                }
                case SKEWNESS: {
                    return new FourthMomentAggregationFunction(arguments, FourthMomentAggregationFunction.Type.SKEWNESS);
                }
                case KURTOSIS: {
                    return new FourthMomentAggregationFunction(arguments, FourthMomentAggregationFunction.Type.KURTOSIS);
                }
                case FOURTHMOMENT: {
                    return new FourthMomentAggregationFunction(arguments, FourthMomentAggregationFunction.Type.MOMENT);
                }
                case DISTINCTCOUNTTUPLESKETCH: {
                    return new DistinctCountIntegerTupleSketchAggregationFunction(arguments, IntegerSummary.Mode.Sum);
                }
                case DISTINCTCOUNTRAWINTEGERSUMTUPLESKETCH: {
                    return new IntegerTupleSketchAggregationFunction(arguments, IntegerSummary.Mode.Sum);
                }
                case SUMVALUESINTEGERSUMTUPLESKETCH: {
                    return new SumValuesIntegerTupleSketchAggregationFunction(arguments, IntegerSummary.Mode.Sum);
                }
                case AVGVALUEINTEGERSUMTUPLESKETCH: {
                    return new AvgValueIntegerTupleSketchAggregationFunction(arguments, IntegerSummary.Mode.Sum);
                }
                case PINOTPARENTAGGEXPRMAX: {
                    return new ParentExprMinMaxAggregationFunction(arguments, true);
                }
                case PINOTPARENTAGGEXPRMIN: {
                    return new ParentExprMinMaxAggregationFunction(arguments, false);
                }
                case PINOTCHILDAGGEXPRMAX: {
                    return new ChildExprMinMaxAggregationFunction(arguments, true);
                }
                case PINOTCHILDAGGEXPRMIN: {
                    return new ChildExprMinMaxAggregationFunction(arguments, false);
                }
                case EXPRMAX: 
                case EXPRMIN: {
                    throw new IllegalArgumentException("Aggregation function: " + functionType + " is only supported in selection without alias.");
                }
                case FUNNELCOUNT: {
                    return new FunnelCountAggregationFunctionFactory(arguments).get();
                }
                case FUNNELMAXSTEP: {
                    return new FunnelMaxStepAggregationFunction(arguments);
                }
                case FUNNELMATCHSTEP: {
                    return new FunnelMatchStepAggregationFunction(arguments);
                }
                case FUNNELCOMPLETECOUNT: {
                    return new FunnelCompleteCountAggregationFunction(arguments);
                }
                case FREQUENTSTRINGSSKETCH: {
                    return new FrequentStringsSketchAggregationFunction(arguments);
                }
                case FREQUENTLONGSSKETCH: {
                    return new FrequentLongsSketchAggregationFunction(arguments);
                }
                case DISTINCTCOUNTCPCSKETCH: {
                    return new DistinctCountCPCSketchAggregationFunction(arguments);
                }
                case DISTINCTCOUNTRAWCPCSKETCH: {
                    return new DistinctCountRawCPCSketchAggregationFunction(arguments);
                }
                case DISTINCTCOUNTULL: {
                    return new DistinctCountULLAggregationFunction(arguments);
                }
                case DISTINCTCOUNTRAWULL: {
                    return new DistinctCountRawULLAggregationFunction(arguments);
                }
            }
            throw new IllegalArgumentException("Unsupported aggregation function type: " + functionType);
        }
        catch (Exception e) {
            throw new BadQueryRequestException("Invalid aggregation function: " + function + "; Reason: " + e.getMessage());
        }
    }

    private static int parsePercentileToInt(String percentileString) {
        int percentile = Integer.parseInt(percentileString);
        Preconditions.checkArgument((percentile >= 0 && percentile <= 100 ? 1 : 0) != 0, (String)"Invalid percentile: %s", (int)percentile);
        return percentile;
    }
}

