/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.util.List;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.TupleSketchIterator;
import org.apache.datasketches.tuple.aninteger.IntegerSummary;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.query.aggregation.function.IntegerTupleSketchAggregationFunction;
import org.apache.pinot.segment.local.customobject.TupleIntSketchAccumulator;
import org.apache.pinot.segment.spi.AggregationFunctionType;

public class AvgValueIntegerTupleSketchAggregationFunction
extends IntegerTupleSketchAggregationFunction {
    public AvgValueIntegerTupleSketchAggregationFunction(List<ExpressionContext> arguments, IntegerSummary.Mode mode) {
        super(arguments, mode);
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.AVGVALUEINTEGERSUMTUPLESKETCH;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.LONG;
    }

    @Override
    public Comparable extractFinalResult(TupleIntSketchAccumulator accumulator) {
        accumulator.setNominalEntries(this._nominalEntries);
        accumulator.setSetOperations(this._setOps);
        accumulator.setThreshold(this._accumulatorThreshold);
        Sketch result = accumulator.getResult();
        if (result.isEmpty() || result.getRetainedEntries() == 0) {
            return null;
        }
        TupleSketchIterator summaries = result.iterator();
        double retainedTotal = 0.0;
        while (summaries.next()) {
            retainedTotal += (double)((IntegerSummary)summaries.getSummary()).getValue();
        }
        double estimate = retainedTotal / (double)result.getRetainedEntries();
        return Long.valueOf(Math.round(estimate));
    }
}

