/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.DummyAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.DummyGroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;

public abstract class ChildAggregationFunction
implements AggregationFunction<Long, Long> {
    private static final int CHILD_AGGREGATION_FUNCTION_ID_OFFSET = 0;
    private static final int CHILD_AGGREGATION_FUNCTION_COLUMN_KEY_OFFSET = 1;
    private final ExpressionContext _childFunctionKeyInParent;
    private final List<ExpressionContext> _resultNameOperands;
    private final ExpressionContext _childFunctionID;

    ChildAggregationFunction(List<ExpressionContext> operands) {
        this._childFunctionID = operands.get(0);
        this._childFunctionKeyInParent = operands.get(1);
        this._resultNameOperands = operands.subList(2, operands.size());
    }

    @Override
    public List<ExpressionContext> getInputExpressions() {
        ArrayList<ExpressionContext> expressionContexts = new ArrayList<ExpressionContext>();
        expressionContexts.add(this._childFunctionID);
        expressionContexts.add(this._childFunctionKeyInParent);
        expressionContexts.addAll(this._resultNameOperands);
        return expressionContexts;
    }

    @Override
    public final AggregationResultHolder createAggregationResultHolder() {
        return new DummyAggregationResultHolder();
    }

    @Override
    public final GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new DummyGroupByResultHolder();
    }

    @Override
    public final void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
    }

    @Override
    public final void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
    }

    @Override
    public final void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
    }

    @Override
    public final Long extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        return 0L;
    }

    @Override
    public final Long extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        return 0L;
    }

    @Override
    public final Long merge(Long intermediateResult1, Long intermediateResult2) {
        return 0L;
    }

    @Override
    public final DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.LONG;
    }

    @Override
    public final DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.UNKNOWN;
    }

    @Override
    public final Long extractFinalResult(Long longValue) {
        return 0L;
    }

    @Override
    public Long mergeFinalResult(Long finalResult1, Long finalResult2) {
        return 0L;
    }

    @Override
    public final String getResultColumnName() {
        String type = this.getType().getName().toLowerCase();
        return "pinotchildagg" + type + "(" + this._resultNameOperands.stream().map(ExpressionContext::toString).collect(Collectors.joining(",")) + ")@" + type + this._childFunctionID.getLiteral().getStringValue() + "_" + this._childFunctionKeyInParent.toString();
    }

    @Override
    public final String toExplainString() {
        StringBuilder stringBuilder = new StringBuilder("pinotchildagg").append("_").append(this.getType().getName()).append('(');
        int numArguments = this.getInputExpressions().size();
        if (numArguments > 0) {
            stringBuilder.append(this.getInputExpressions().get(0).toString());
            for (int i = 1; i < numArguments; ++i) {
                stringBuilder.append(", ").append(this.getInputExpressions().get(i).toString());
            }
        }
        return stringBuilder.append(')').toString();
    }
}

