/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.DoubleAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.NullableSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.DoubleGroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.roaringbitmap.RoaringBitmap;

public class CountAggregationFunction
extends NullableSingleInputAggregationFunction<Long, Long> {
    private static final String COUNT_STAR_RESULT_COLUMN_NAME = "count(*)";
    private static final double DEFAULT_INITIAL_VALUE = 0.0;
    private static final ExpressionContext STAR_TREE_COUNT_STAR_EXPRESSION = ExpressionContext.forIdentifier((String)"*");

    public CountAggregationFunction(List<ExpressionContext> arguments, boolean nullHandlingEnabled) {
        this(CountAggregationFunction.verifySingleArgument(arguments, "COUNT"), nullHandlingEnabled && (arguments.get(0).getType() == ExpressionContext.Type.IDENTIFIER && !arguments.get(0).getIdentifier().equals("*") || arguments.get(0).getType() == ExpressionContext.Type.FUNCTION));
    }

    protected CountAggregationFunction(ExpressionContext expression, boolean nullHandlingEnabled) {
        super(expression, nullHandlingEnabled);
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.COUNT;
    }

    @Override
    public String getResultColumnName() {
        return this._nullHandlingEnabled ? super.getResultColumnName() : COUNT_STAR_RESULT_COLUMN_NAME;
    }

    @Override
    public List<ExpressionContext> getInputExpressions() {
        return this._nullHandlingEnabled ? super.getInputExpressions() : Collections.emptyList();
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new DoubleAggregationResultHolder(0.0);
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new DoubleGroupByResultHolder(initialCapacity, maxCapacity, 0.0);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        if (blockValSetMap.isEmpty()) {
            aggregationResultHolder.setValue(aggregationResultHolder.getDoubleResult() + (double)length);
        } else if (this._nullHandlingEnabled) {
            assert (blockValSetMap.size() == 1);
            BlockValSet blockValSet = blockValSetMap.values().iterator().next();
            RoaringBitmap nullBitmap = blockValSet.getNullBitmap();
            int numNulls = 0;
            if (nullBitmap != null) {
                numNulls = nullBitmap.getCardinality();
            }
            assert (numNulls <= length);
            aggregationResultHolder.setValue(aggregationResultHolder.getDoubleResult() + (double)(length - numNulls));
        } else {
            long[] valueArray = blockValSetMap.get(STAR_TREE_COUNT_STAR_EXPRESSION).getLongValuesSV();
            long count = 0L;
            for (int i = 0; i < length; ++i) {
                count += valueArray[i];
            }
            aggregationResultHolder.setValue(aggregationResultHolder.getDoubleResult() + (double)count);
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        if (blockValSetMap.isEmpty()) {
            for (int i = 0; i < length; ++i) {
                int groupKey = groupKeyArray[i];
                groupByResultHolder.setValueForKey(groupKey, groupByResultHolder.getDoubleResult(groupKey) + 1.0);
            }
        } else if (this._nullHandlingEnabled) {
            assert (blockValSetMap.size() == 1);
            BlockValSet blockValSet = blockValSetMap.values().iterator().next();
            this.forEachNotNull(length, blockValSet, (int from, int to) -> {
                for (int i = from; i < to; ++i) {
                    int groupKey = groupKeyArray[i];
                    groupByResultHolder.setValueForKey(groupKey, groupByResultHolder.getDoubleResult(groupKey) + 1.0);
                }
            });
        } else {
            long[] valueArray = blockValSetMap.get(STAR_TREE_COUNT_STAR_EXPRESSION).getLongValuesSV();
            for (int i = 0; i < length; ++i) {
                int groupKey = groupKeyArray[i];
                groupByResultHolder.setValueForKey(groupKey, groupByResultHolder.getDoubleResult(groupKey) + (double)valueArray[i]);
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        if (blockValSetMap.isEmpty()) {
            for (int i = 0; i < length; ++i) {
                for (int groupKey : groupKeysArray[i]) {
                    groupByResultHolder.setValueForKey(groupKey, groupByResultHolder.getDoubleResult(groupKey) + 1.0);
                }
            }
        } else if (this._nullHandlingEnabled) {
            assert (blockValSetMap.size() == 1);
            BlockValSet blockValSet = blockValSetMap.values().iterator().next();
            this.forEachNotNull(length, blockValSet, (int from, int to) -> {
                for (int i = from; i < to; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        groupByResultHolder.setValueForKey(groupKey, groupByResultHolder.getDoubleResult(groupKey) + 1.0);
                    }
                }
            });
        } else {
            long[] valueArray = blockValSetMap.get(STAR_TREE_COUNT_STAR_EXPRESSION).getLongValuesSV();
            for (int i = 0; i < length; ++i) {
                long value = valueArray[i];
                for (int groupKey : groupKeysArray[i]) {
                    groupByResultHolder.setValueForKey(groupKey, groupByResultHolder.getDoubleResult(groupKey) + (double)value);
                }
            }
        }
    }

    @Override
    public Long extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        return (long)aggregationResultHolder.getDoubleResult();
    }

    @Override
    public Long extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        return (long)groupByResultHolder.getDoubleResult(groupKey);
    }

    @Override
    public Long merge(Long intermediateResult1, Long intermediateResult2) {
        return intermediateResult1 + intermediateResult2;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.LONG;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.LONG;
    }

    @Override
    public Long extractFinalResult(Long intermediateResult) {
        return intermediateResult;
    }

    @Override
    public Long mergeFinalResult(Long finalResult1, Long finalResult2) {
        return finalResult1 + finalResult2;
    }

    @Override
    public String toExplainString() {
        StringBuilder stringBuilder = new StringBuilder(this.getType().getName()).append('(');
        int numArguments = this.getInputExpressions().size();
        if (numArguments > 0) {
            stringBuilder.append(this.getInputExpressions().get(0).toString());
            for (int i = 1; i < numArguments; ++i) {
                stringBuilder.append(", ").append(this.getInputExpressions().get(i).toString());
            }
        } else {
            stringBuilder.append("*");
        }
        return stringBuilder.append(')').toString();
    }
}

