/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.core.query.aggregation.utils.StatisticalAggregationFunctionUtils;
import org.apache.pinot.segment.local.customobject.CovarianceTuple;
import org.apache.pinot.segment.spi.AggregationFunctionType;

public class CovarianceAggregationFunction
implements AggregationFunction<CovarianceTuple, Double> {
    private static final double DEFAULT_FINAL_RESULT = Double.NEGATIVE_INFINITY;
    protected final ExpressionContext _expression1;
    protected final ExpressionContext _expression2;
    protected final boolean _isSample;

    public CovarianceAggregationFunction(List<ExpressionContext> arguments, boolean isSample) {
        this._expression1 = arguments.get(0);
        this._expression2 = arguments.get(1);
        this._isSample = isSample;
    }

    @Override
    public AggregationFunctionType getType() {
        if (this._isSample) {
            return AggregationFunctionType.COVARSAMP;
        }
        return AggregationFunctionType.COVARPOP;
    }

    @Override
    public String getResultColumnName() {
        return this.getType().getName().toLowerCase() + "(" + this._expression1 + "," + this._expression2 + ")";
    }

    @Override
    public List<ExpressionContext> getInputExpressions() {
        ArrayList<ExpressionContext> inputExpressions = new ArrayList<ExpressionContext>();
        inputExpressions.add(this._expression1);
        inputExpressions.add(this._expression2);
        return inputExpressions;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[] values1 = StatisticalAggregationFunctionUtils.getValSet(blockValSetMap, this._expression1);
        double[] values2 = StatisticalAggregationFunctionUtils.getValSet(blockValSetMap, this._expression2);
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXY = 0.0;
        for (int i = 0; i < length; ++i) {
            sumX += values1[i];
            sumY += values2[i];
            sumXY += values1[i] * values2[i];
        }
        this.setAggregationResult(aggregationResultHolder, sumX, sumY, sumXY, length);
    }

    protected void setAggregationResult(AggregationResultHolder aggregationResultHolder, double sumX, double sumY, double sumXY, long count) {
        CovarianceTuple covarianceTuple = (CovarianceTuple)aggregationResultHolder.getResult();
        if (covarianceTuple == null) {
            aggregationResultHolder.setValue(new CovarianceTuple(sumX, sumY, sumXY, count));
        } else {
            covarianceTuple.apply(sumX, sumY, sumXY, count);
        }
    }

    protected void setGroupByResult(int groupKey, GroupByResultHolder groupByResultHolder, double sumX, double sumY, double sumXY, long count) {
        CovarianceTuple covarianceTuple = (CovarianceTuple)groupByResultHolder.getResult(groupKey);
        if (covarianceTuple == null) {
            groupByResultHolder.setValueForKey(groupKey, new CovarianceTuple(sumX, sumY, sumXY, count));
        } else {
            covarianceTuple.apply(sumX, sumY, sumXY, count);
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[] values1 = StatisticalAggregationFunctionUtils.getValSet(blockValSetMap, this._expression1);
        double[] values2 = StatisticalAggregationFunctionUtils.getValSet(blockValSetMap, this._expression2);
        for (int i = 0; i < length; ++i) {
            this.setGroupByResult(groupKeyArray[i], groupByResultHolder, values1[i], values2[i], values1[i] * values2[i], 1L);
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[] values1 = StatisticalAggregationFunctionUtils.getValSet(blockValSetMap, this._expression1);
        double[] values2 = StatisticalAggregationFunctionUtils.getValSet(blockValSetMap, this._expression2);
        for (int i = 0; i < length; ++i) {
            for (int groupKey : groupKeysArray[i]) {
                this.setGroupByResult(groupKey, groupByResultHolder, values1[i], values2[i], values1[i] * values2[i], 1L);
            }
        }
    }

    @Override
    public CovarianceTuple extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        CovarianceTuple covarianceTuple = (CovarianceTuple)aggregationResultHolder.getResult();
        if (covarianceTuple == null) {
            return new CovarianceTuple(0.0, 0.0, 0.0, 0L);
        }
        return covarianceTuple;
    }

    @Override
    public CovarianceTuple extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        return (CovarianceTuple)groupByResultHolder.getResult(groupKey);
    }

    @Override
    public CovarianceTuple merge(CovarianceTuple intermediateResult1, CovarianceTuple intermediateResult2) {
        intermediateResult1.apply(intermediateResult2);
        return intermediateResult1;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.DOUBLE;
    }

    @Override
    public Double extractFinalResult(CovarianceTuple covarianceTuple) {
        long count = covarianceTuple.getCount();
        if (count == 0L) {
            return Double.NEGATIVE_INFINITY;
        }
        double sumX = covarianceTuple.getSumX();
        double sumY = covarianceTuple.getSumY();
        double sumXY = covarianceTuple.getSumXY();
        if (this._isSample) {
            if (count - 1L == 0L) {
                return Double.NEGATIVE_INFINITY;
            }
            return sumXY / (double)(count - 1L) - sumX * sumY / (double)(count * (count - 1L));
        }
        return sumXY / (double)count - sumX * sumY / (double)(count * count);
    }

    @Override
    public String toExplainString() {
        StringBuilder stringBuilder = new StringBuilder(this.getType().getName()).append('(');
        int numArguments = this.getInputExpressions().size();
        if (numArguments > 0) {
            stringBuilder.append(this.getInputExpressions().get(0).toString());
            for (int i = 1; i < numArguments; ++i) {
                stringBuilder.append(", ").append(this.getInputExpressions().get(i).toString());
            }
        }
        return stringBuilder.append(')').toString();
    }
}

