/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import com.dynatrace.hash4j.distinctcount.UltraLogLog;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.segment.local.utils.UltraLogLogUtils;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.RoaringBitmap;

public class DistinctCountULLAggregationFunction
extends BaseSingleInputAggregationFunction<UltraLogLog, Comparable> {
    protected final int _p;

    public DistinctCountULLAggregationFunction(List<ExpressionContext> arguments) {
        super(arguments.get(0));
        int numExpressions = arguments.size();
        Preconditions.checkArgument((numExpressions <= 2 ? 1 : 0) != 0, (String)"DistinctCountHLLPlus expects 1 or 2 arguments, got: %s", (int)numExpressions);
        this._p = arguments.size() == 2 ? arguments.get(1).getLiteral().getIntValue() : 12;
    }

    public int getP() {
        return this._p;
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.DISTINCTCOUNTULL;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
        if (storedType == FieldSpec.DataType.BYTES) {
            byte[][] bytesValues = blockValSet.getBytesValuesSV();
            try {
                UltraLogLog ull = (UltraLogLog)aggregationResultHolder.getResult();
                if (ull == null) {
                    ull = ObjectSerDeUtils.ULTRA_LOG_LOG_OBJECT_SER_DE.deserialize(bytesValues[0]);
                    aggregationResultHolder.setValue(ull);
                } else {
                    ull.add(ObjectSerDeUtils.ULTRA_LOG_LOG_OBJECT_SER_DE.deserialize(bytesValues[0]));
                }
                for (int i = 1; i < length; ++i) {
                    ull.add(ObjectSerDeUtils.ULTRA_LOG_LOG_OBJECT_SER_DE.deserialize(bytesValues[i]));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Caught exception while merging UltraLogLogs", e);
            }
            return;
        }
        Dictionary dictionary = blockValSet.getDictionary();
        if (dictionary != null) {
            int[] dictIds = blockValSet.getDictionaryIdsSV();
            DistinctCountULLAggregationFunction.getDictIdBitmap(aggregationResultHolder, dictionary).addN(dictIds, 0, length);
            return;
        }
        UltraLogLog ull = this.getULL(aggregationResultHolder);
        switch (storedType) {
            case INT: {
                int[] intValues = blockValSet.getIntValuesSV();
                for (int i = 0; i < length; ++i) {
                    UltraLogLogUtils.hashObject((Object)intValues[i]).ifPresent(arg_0 -> ((UltraLogLog)ull).add(arg_0));
                }
                break;
            }
            case LONG: {
                long[] longValues = blockValSet.getLongValuesSV();
                for (int i = 0; i < length; ++i) {
                    UltraLogLogUtils.hashObject((Object)longValues[i]).ifPresent(arg_0 -> ((UltraLogLog)ull).add(arg_0));
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = blockValSet.getFloatValuesSV();
                for (int i = 0; i < length; ++i) {
                    UltraLogLogUtils.hashObject((Object)Float.valueOf(floatValues[i])).ifPresent(arg_0 -> ((UltraLogLog)ull).add(arg_0));
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = blockValSet.getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    UltraLogLogUtils.hashObject((Object)doubleValues[i]).ifPresent(arg_0 -> ((UltraLogLog)ull).add(arg_0));
                }
                break;
            }
            case STRING: {
                String[] stringValues = blockValSet.getStringValuesSV();
                for (int i = 0; i < length; ++i) {
                    UltraLogLogUtils.hashObject((Object)stringValues[i]).ifPresent(arg_0 -> ((UltraLogLog)ull).add(arg_0));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT_ULL aggregation function: " + storedType);
            }
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
        if (storedType == FieldSpec.DataType.BYTES) {
            byte[][] bytesValues = blockValSet.getBytesValuesSV();
            try {
                for (int i = 0; i < length; ++i) {
                    UltraLogLog value = ObjectSerDeUtils.ULTRA_LOG_LOG_OBJECT_SER_DE.deserialize(bytesValues[i]);
                    int groupKey = groupKeyArray[i];
                    UltraLogLog ull = (UltraLogLog)groupByResultHolder.getResult(groupKey);
                    if (ull != null) {
                        ull.add(value);
                        continue;
                    }
                    groupByResultHolder.setValueForKey(groupKey, value);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Caught exception while merging UltraLogLog", e);
            }
            return;
        }
        Dictionary dictionary = blockValSet.getDictionary();
        if (dictionary != null) {
            int[] dictIds = blockValSet.getDictionaryIdsSV();
            for (int i = 0; i < length; ++i) {
                DistinctCountULLAggregationFunction.getDictIdBitmap(groupByResultHolder, groupKeyArray[i], dictionary).add(dictIds[i]);
            }
            return;
        }
        switch (storedType) {
            case INT: {
                int[] intValues = blockValSet.getIntValuesSV();
                for (int i = 0; i < length; ++i) {
                    UltraLogLogUtils.hashObject((Object)intValues[i]).ifPresent(arg_0 -> ((UltraLogLog)this.getULL(groupByResultHolder, groupKeyArray[i])).add(arg_0));
                }
                break;
            }
            case LONG: {
                long[] longValues = blockValSet.getLongValuesSV();
                for (int i = 0; i < length; ++i) {
                    UltraLogLogUtils.hashObject((Object)longValues[i]).ifPresent(arg_0 -> ((UltraLogLog)this.getULL(groupByResultHolder, groupKeyArray[i])).add(arg_0));
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = blockValSet.getFloatValuesSV();
                for (int i = 0; i < length; ++i) {
                    UltraLogLogUtils.hashObject((Object)Float.valueOf(floatValues[i])).ifPresent(arg_0 -> ((UltraLogLog)this.getULL(groupByResultHolder, groupKeyArray[i])).add(arg_0));
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = blockValSet.getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    UltraLogLogUtils.hashObject((Object)doubleValues[i]).ifPresent(arg_0 -> ((UltraLogLog)this.getULL(groupByResultHolder, groupKeyArray[i])).add(arg_0));
                }
                break;
            }
            case STRING: {
                String[] stringValues = blockValSet.getStringValuesSV();
                for (int i = 0; i < length; ++i) {
                    UltraLogLogUtils.hashObject((Object)stringValues[i]).ifPresent(arg_0 -> ((UltraLogLog)this.getULL(groupByResultHolder, groupKeyArray[i])).add(arg_0));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT_ULL aggregation function: " + storedType);
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
        if (storedType == FieldSpec.DataType.BYTES) {
            byte[][] bytesValues = blockValSet.getBytesValuesSV();
            try {
                for (int i = 0; i < length; ++i) {
                    UltraLogLog value = ObjectSerDeUtils.ULTRA_LOG_LOG_OBJECT_SER_DE.deserialize(bytesValues[i]);
                    for (int groupKey : groupKeysArray[i]) {
                        UltraLogLog ull = (UltraLogLog)groupByResultHolder.getResult(groupKey);
                        if (ull != null) {
                            ull.add(value);
                            continue;
                        }
                        groupByResultHolder.setValueForKey(groupKey, ObjectSerDeUtils.ULTRA_LOG_LOG_OBJECT_SER_DE.deserialize(bytesValues[i]));
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Caught exception while merging UltraLogLog", e);
            }
            return;
        }
        Dictionary dictionary = blockValSet.getDictionary();
        if (dictionary != null) {
            int[] dictIds = blockValSet.getDictionaryIdsSV();
            for (int i = 0; i < length; ++i) {
                DistinctCountULLAggregationFunction.setDictIdForGroupKeys(groupByResultHolder, groupKeysArray[i], dictionary, dictIds[i]);
            }
            return;
        }
        switch (storedType) {
            case INT: {
                int[] intValues = blockValSet.getIntValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], intValues[i]);
                }
                break;
            }
            case LONG: {
                long[] longValues = blockValSet.getLongValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], longValues[i]);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = blockValSet.getFloatValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], Float.valueOf(floatValues[i]));
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = blockValSet.getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], doubleValues[i]);
                }
                break;
            }
            case STRING: {
                String[] stringValues = blockValSet.getStringValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], stringValues[i]);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT_HLL_PLUS aggregation function: " + storedType);
            }
        }
    }

    @Override
    public UltraLogLog extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        Object result = aggregationResultHolder.getResult();
        if (result == null) {
            return UltraLogLog.create((int)this._p);
        }
        if (result instanceof DictIdsWrapper) {
            return this.convertToULL((DictIdsWrapper)result);
        }
        return (UltraLogLog)result;
    }

    @Override
    public UltraLogLog extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        Object result = groupByResultHolder.getResult(groupKey);
        if (result == null) {
            return UltraLogLog.create((int)this._p);
        }
        if (result instanceof DictIdsWrapper) {
            return this.convertToULL((DictIdsWrapper)result);
        }
        return (UltraLogLog)result;
    }

    @Override
    public UltraLogLog merge(UltraLogLog intermediateResult1, UltraLogLog intermediateResult2) {
        int largerP = Math.max(intermediateResult1.getP(), intermediateResult2.getP());
        UltraLogLog merged = UltraLogLog.create((int)largerP);
        merged.add(intermediateResult1);
        merged.add(intermediateResult2);
        return merged;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.LONG;
    }

    @Override
    public Comparable extractFinalResult(UltraLogLog intermediateResult) {
        return Long.valueOf(Math.round(intermediateResult.getDistinctCountEstimate()));
    }

    @Override
    public Comparable mergeFinalResult(Comparable finalResult1, Comparable finalResult2) {
        return Long.valueOf((Long)finalResult1 + (Long)finalResult2);
    }

    @Override
    public boolean canUseStarTree(Map<String, Object> functionParameters) {
        Object p = functionParameters.get("p");
        if (p != null) {
            return this._p == Integer.parseInt(String.valueOf(p));
        }
        return this._p == 12;
    }

    protected static RoaringBitmap getDictIdBitmap(AggregationResultHolder aggregationResultHolder, Dictionary dictionary) {
        DictIdsWrapper dictIdsWrapper = (DictIdsWrapper)aggregationResultHolder.getResult();
        if (dictIdsWrapper == null) {
            dictIdsWrapper = new DictIdsWrapper(dictionary);
            aggregationResultHolder.setValue(dictIdsWrapper);
        }
        return dictIdsWrapper._dictIdBitmap;
    }

    protected UltraLogLog getULL(AggregationResultHolder aggregationResultHolder) {
        UltraLogLog ull = (UltraLogLog)aggregationResultHolder.getResult();
        if (ull == null) {
            ull = UltraLogLog.create((int)this._p);
            aggregationResultHolder.setValue(ull);
        }
        return ull;
    }

    protected static RoaringBitmap getDictIdBitmap(GroupByResultHolder groupByResultHolder, int groupKey, Dictionary dictionary) {
        DictIdsWrapper dictIdsWrapper = (DictIdsWrapper)groupByResultHolder.getResult(groupKey);
        if (dictIdsWrapper == null) {
            dictIdsWrapper = new DictIdsWrapper(dictionary);
            groupByResultHolder.setValueForKey(groupKey, dictIdsWrapper);
        }
        return dictIdsWrapper._dictIdBitmap;
    }

    protected UltraLogLog getULL(GroupByResultHolder groupByResultHolder, int groupKey) {
        UltraLogLog ull = (UltraLogLog)groupByResultHolder.getResult(groupKey);
        if (ull == null) {
            ull = UltraLogLog.create((int)this._p);
            groupByResultHolder.setValueForKey(groupKey, ull);
        }
        return ull;
    }

    private static void setDictIdForGroupKeys(GroupByResultHolder groupByResultHolder, int[] groupKeys, Dictionary dictionary, int dictId) {
        for (int groupKey : groupKeys) {
            DistinctCountULLAggregationFunction.getDictIdBitmap(groupByResultHolder, groupKey, dictionary).add(dictId);
        }
    }

    private void setValueForGroupKeys(GroupByResultHolder groupByResultHolder, int[] groupKeys, Object value) {
        for (int groupKey : groupKeys) {
            UltraLogLogUtils.hashObject((Object)value).ifPresent(arg_0 -> ((UltraLogLog)this.getULL(groupByResultHolder, groupKey)).add(arg_0));
        }
    }

    private UltraLogLog convertToULL(DictIdsWrapper dictIdsWrapper) {
        UltraLogLog ull = UltraLogLog.create((int)this._p);
        Dictionary dictionary = dictIdsWrapper._dictionary;
        RoaringBitmap dictIdBitmap = dictIdsWrapper._dictIdBitmap;
        PeekableIntIterator iterator = dictIdBitmap.getIntIterator();
        while (iterator.hasNext()) {
            UltraLogLogUtils.hashObject((Object)dictionary.get(iterator.next())).ifPresent(arg_0 -> ((UltraLogLog)ull).add(arg_0));
        }
        return ull;
    }

    private static final class DictIdsWrapper {
        final Dictionary _dictionary;
        final RoaringBitmap _dictIdBitmap;

        private DictIdsWrapper(Dictionary dictionary) {
            this._dictionary = dictionary;
            this._dictIdBitmap = new RoaringBitmap();
        }
    }
}

