/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.core.query.aggregation.function.FirstWithTimeAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.segment.local.customobject.IntLongPair;
import org.apache.pinot.segment.local.customobject.ValueLongPair;
import org.roaringbitmap.IntIterator;

public class FirstIntValueWithTimeAggregationFunction
extends FirstWithTimeAggregationFunction<Integer> {
    private static final ValueLongPair<Integer> DEFAULT_VALUE_TIME_PAIR = new IntLongPair(Integer.valueOf(Integer.MIN_VALUE), Long.MAX_VALUE);
    private final boolean _isBoolean;

    public FirstIntValueWithTimeAggregationFunction(ExpressionContext dataCol, ExpressionContext timeCol, boolean nullHandlingEnabled, boolean isBoolean) {
        super(dataCol, timeCol, ObjectSerDeUtils.INT_LONG_PAIR_SER_DE, nullHandlingEnabled);
        this._isBoolean = isBoolean;
    }

    @Override
    public ValueLongPair<Integer> constructValueLongPair(Integer value, long time) {
        return new IntLongPair(value, time);
    }

    @Override
    public ValueLongPair<Integer> getDefaultValueTimePair() {
        return DEFAULT_VALUE_TIME_PAIR;
    }

    @Override
    public Integer readCell(BlockValSet block, int docId) {
        return block.getIntValuesSV()[docId];
    }

    @Override
    public void aggregateGroupResultWithRawDataSv(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, BlockValSet blockValSet, BlockValSet timeValSet) {
        int[] intValues = blockValSet.getIntValuesSV();
        long[] timeValues = timeValSet.getLongValuesSV();
        IntIterator nullIdxIterator = this.orNullIterator(blockValSet, timeValSet);
        this.forEachNotNull(length, nullIdxIterator, (int from, int to) -> {
            for (int i = from; i < to; ++i) {
                int data = intValues[i];
                long time = timeValues[i];
                this.setGroupByResult(groupKeyArray[i], groupByResultHolder, data, time);
            }
        });
    }

    @Override
    public void aggregateGroupResultWithRawDataMv(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, BlockValSet blockValSet, BlockValSet timeValSet) {
        int[] intValues = blockValSet.getIntValuesSV();
        long[] timeValues = timeValSet.getLongValuesSV();
        IntIterator nullIdxIterator = this.orNullIterator(blockValSet, timeValSet);
        this.forEachNotNull(length, nullIdxIterator, (int from, int to) -> {
            for (int i = from; i < to; ++i) {
                int value = intValues[i];
                long time = timeValues[i];
                for (int groupKey : groupKeysArray[i]) {
                    this.setGroupByResult(groupKey, groupByResultHolder, value, time);
                }
            }
        });
    }

    @Override
    public String getResultColumnName() {
        if (this._isBoolean) {
            return this.getType().getName().toLowerCase() + "(" + this._expression + "," + this._timeCol + ",'BOOLEAN')";
        }
        return this.getType().getName().toLowerCase() + "(" + this._expression + "," + this._timeCol + ",'INT')";
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        if (this._isBoolean) {
            return DataSchema.ColumnDataType.BOOLEAN;
        }
        return DataSchema.ColumnDataType.INT;
    }
}

