/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.util.List;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.core.query.aggregation.utils.StatisticalAggregationFunctionUtils;
import org.apache.pinot.segment.local.customobject.PinotFourthMoment;
import org.apache.pinot.segment.spi.AggregationFunctionType;

public class FourthMomentAggregationFunction
extends BaseSingleInputAggregationFunction<PinotFourthMoment, Double> {
    private final Type _type;

    public FourthMomentAggregationFunction(List<ExpressionContext> arguments, Type type) {
        super(FourthMomentAggregationFunction.verifySingleArgument(arguments, type.name()));
        this._type = type;
    }

    @Override
    public AggregationFunctionType getType() {
        switch (this._type) {
            case KURTOSIS: {
                return AggregationFunctionType.KURTOSIS;
            }
            case SKEWNESS: {
                return AggregationFunctionType.SKEWNESS;
            }
            case MOMENT: {
                return AggregationFunctionType.FOURTHMOMENT;
            }
        }
        throw new IllegalArgumentException("Unexpected type " + this._type);
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[] values = StatisticalAggregationFunctionUtils.getValSet(blockValSetMap, this._expression);
        PinotFourthMoment m4 = (PinotFourthMoment)aggregationResultHolder.getResult();
        if (m4 == null) {
            m4 = new PinotFourthMoment();
            aggregationResultHolder.setValue(m4);
        }
        for (int i = 0; i < length; ++i) {
            m4.increment(values[i]);
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[] values = StatisticalAggregationFunctionUtils.getValSet(blockValSetMap, this._expression);
        for (int i = 0; i < length; ++i) {
            PinotFourthMoment m4 = (PinotFourthMoment)groupByResultHolder.getResult(groupKeyArray[i]);
            if (m4 == null) {
                m4 = new PinotFourthMoment();
                groupByResultHolder.setValueForKey(groupKeyArray[i], m4);
            }
            m4.increment(values[i]);
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[] values = StatisticalAggregationFunctionUtils.getValSet(blockValSetMap, this._expression);
        for (int i = 0; i < length; ++i) {
            for (int groupKey : groupKeysArray[i]) {
                PinotFourthMoment m4 = (PinotFourthMoment)groupByResultHolder.getResult(groupKey);
                if (m4 == null) {
                    m4 = new PinotFourthMoment();
                    groupByResultHolder.setValueForKey(groupKey, m4);
                }
                m4.increment(values[i]);
            }
        }
    }

    @Override
    public PinotFourthMoment extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        PinotFourthMoment m4 = (PinotFourthMoment)aggregationResultHolder.getResult();
        if (m4 == null) {
            return new PinotFourthMoment();
        }
        return m4;
    }

    @Override
    public PinotFourthMoment extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        PinotFourthMoment m4 = (PinotFourthMoment)groupByResultHolder.getResult(groupKey);
        if (m4 == null) {
            return new PinotFourthMoment();
        }
        return m4;
    }

    @Override
    public PinotFourthMoment merge(PinotFourthMoment intermediateResult1, PinotFourthMoment intermediateResult2) {
        intermediateResult1.combine(intermediateResult2);
        return intermediateResult1;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.DOUBLE;
    }

    @Override
    public Double extractFinalResult(PinotFourthMoment m4) {
        if (m4 == null) {
            return null;
        }
        switch (this._type) {
            case KURTOSIS: {
                return m4.kurtosis();
            }
            case SKEWNESS: {
                return m4.skew();
            }
            case MOMENT: {
                throw new UnsupportedOperationException("Fourth moment cannot be used as aggregation function directly");
            }
        }
        throw new IllegalStateException("Unexpected value: " + this._type);
    }

    static enum Type {
        KURTOSIS,
        SKEWNESS,
        MOMENT;

    }
}

