/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.datasketches.frequencies.LongsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.segment.local.customobject.SerializedFrequentLongsSketch;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;

public class FrequentLongsSketchAggregationFunction
extends BaseSingleInputAggregationFunction<LongsSketch, Comparable<?>> {
    protected static final int DEFAULT_MAX_MAP_SIZE = 256;
    protected int _maxMapSize;

    public FrequentLongsSketchAggregationFunction(List<ExpressionContext> arguments) {
        super(arguments.get(0));
        int numArguments = arguments.size();
        Preconditions.checkArgument((numArguments == 1 || numArguments == 2 ? 1 : 0) != 0, (Object)"Expecting 1 or 2 arguments for FrequentLongsSketch function: FREQUENTITEMSSKETCH(column, maxMapSize");
        this._maxMapSize = numArguments == 2 ? arguments.get(1).getLiteral().getIntValue() : 256;
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.FREQUENTLONGSSKETCH;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet valueSet = blockValSetMap.get(this._expression);
        FieldSpec.DataType valueType = valueSet.getValueType();
        LongsSketch sketch = this.getOrCreateSketch(aggregationResultHolder);
        switch (valueType) {
            case BYTES: {
                LongsSketch[] deserializedSketches = this.deserializeSketches(blockValSetMap.get(this._expression).getBytesValuesSV());
                sketch = this.getOrCreateSketch(aggregationResultHolder);
                for (LongsSketch colSketch : deserializedSketches) {
                    sketch.merge(colSketch);
                }
                break;
            }
            case INT: 
            case LONG: {
                long[] lArray = valueSet.getLongValuesSV();
                int n = lArray.length;
                for (int i = 0; i < n; ++i) {
                    Long val = lArray[i];
                    sketch.update(val.longValue());
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot aggregate on non int/long types");
            }
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet valueSet = blockValSetMap.get(this._expression);
        FieldSpec.DataType valueType = valueSet.getValueType();
        switch (valueType) {
            case BYTES: {
                LongsSketch[] deserializedSketches = this.deserializeSketches(blockValSetMap.get(this._expression).getBytesValuesSV());
                for (int i = 0; i < length; ++i) {
                    LongsSketch sketch = this.getOrCreateSketch(groupByResultHolder, groupKeyArray[i]);
                    sketch.merge(deserializedSketches[i]);
                }
                break;
            }
            case INT: 
            case LONG: {
                long[] values = valueSet.getLongValuesSV();
                for (int i = 0; i < length; ++i) {
                    LongsSketch sketch = this.getOrCreateSketch(groupByResultHolder, groupKeyArray[i]);
                    sketch.update(values[i]);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot aggregate on non int/long types");
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet valueSet = blockValSetMap.get(this._expression);
        FieldSpec.DataType valueType = valueSet.getValueType();
        switch (valueType) {
            case BYTES: {
                LongsSketch[] deserializedSketches = this.deserializeSketches(blockValSetMap.get(this._expression).getBytesValuesSV());
                for (int i = 0; i < length; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        LongsSketch sketch = this.getOrCreateSketch(groupByResultHolder, groupKey);
                        sketch.merge(deserializedSketches[i]);
                    }
                }
                break;
            }
            case INT: 
            case LONG: {
                long[] values = valueSet.getLongValuesSV();
                for (int i = 0; i < length; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        LongsSketch sketch = this.getOrCreateSketch(groupByResultHolder, groupKey);
                        sketch.update(values[i]);
                    }
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot aggregate on non int/long types");
            }
        }
    }

    protected LongsSketch getOrCreateSketch(AggregationResultHolder aggregationResultHolder) {
        LongsSketch sketch = (LongsSketch)aggregationResultHolder.getResult();
        if (sketch == null) {
            sketch = new LongsSketch(this._maxMapSize);
            aggregationResultHolder.setValue(sketch);
        }
        return sketch;
    }

    protected LongsSketch getOrCreateSketch(GroupByResultHolder groupByResultHolder, int groupKey) {
        LongsSketch sketch = (LongsSketch)groupByResultHolder.getResult(groupKey);
        if (sketch == null) {
            sketch = new LongsSketch(this._maxMapSize);
            groupByResultHolder.setValueForKey(groupKey, sketch);
        }
        return sketch;
    }

    protected LongsSketch[] deserializeSketches(byte[][] serializedSketches) {
        LongsSketch[] sketches = new LongsSketch[serializedSketches.length];
        for (int i = 0; i < serializedSketches.length; ++i) {
            sketches[i] = LongsSketch.getInstance((Memory)Memory.wrap((byte[])serializedSketches[i]));
        }
        return sketches;
    }

    @Override
    public LongsSketch extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        return (LongsSketch)aggregationResultHolder.getResult();
    }

    @Override
    public LongsSketch extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        return (LongsSketch)groupByResultHolder.getResult(groupKey);
    }

    @Override
    public LongsSketch merge(LongsSketch sketch1, LongsSketch sketch2) {
        LongsSketch union = new LongsSketch(this._maxMapSize);
        if (sketch1 != null) {
            union.merge(sketch1);
        }
        if (sketch2 != null) {
            union.merge(sketch2);
        }
        return union;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.STRING;
    }

    @Override
    public String getResultColumnName() {
        return AggregationFunctionType.FREQUENTLONGSSKETCH.getName().toLowerCase() + "(" + this._expression + ")";
    }

    @Override
    public Comparable<?> extractFinalResult(LongsSketch sketch) {
        return new SerializedFrequentLongsSketch(sketch);
    }
}

