/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.segment.local.customobject.SerializedFrequentStringsSketch;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;

public class FrequentStringsSketchAggregationFunction
extends BaseSingleInputAggregationFunction<ItemsSketch<String>, Comparable<?>> {
    protected static final int DEFAULT_MAX_MAP_SIZE = 256;
    protected int _maxMapSize;

    public FrequentStringsSketchAggregationFunction(List<ExpressionContext> arguments) {
        super(arguments.get(0));
        int numArguments = arguments.size();
        Preconditions.checkArgument((numArguments == 1 || numArguments == 2 ? 1 : 0) != 0, (Object)"Expecting 1 or 2 arguments for FrequentItemsSketch function: FREQUENTSTRINGSSKETCH(column, maxMapSize");
        this._maxMapSize = numArguments == 2 ? arguments.get(1).getLiteral().getIntValue() : 256;
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.FREQUENTSTRINGSSKETCH;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet valueSet = blockValSetMap.get(this._expression);
        FieldSpec.DataType valueType = valueSet.getValueType();
        ItemsSketch<String> sketch = this.getOrCreateSketch(aggregationResultHolder);
        if (valueType == FieldSpec.DataType.BYTES) {
            ItemsSketch<String>[] deserializedSketches = this.deserializeSketches(blockValSetMap.get(this._expression).getBytesValuesSV());
            sketch = this.getOrCreateSketch(aggregationResultHolder);
            for (ItemsSketch<String> colSketch : deserializedSketches) {
                sketch.merge(colSketch);
            }
        } else {
            for (String val : valueSet.getStringValuesSV()) {
                sketch.update((Object)val);
            }
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet valueSet = blockValSetMap.get(this._expression);
        FieldSpec.DataType valueType = valueSet.getValueType();
        if (valueType == FieldSpec.DataType.BYTES) {
            ItemsSketch<String>[] deserializedSketches = this.deserializeSketches(blockValSetMap.get(this._expression).getBytesValuesSV());
            for (int i = 0; i < length; ++i) {
                ItemsSketch<String> sketch = this.getOrCreateSketch(groupByResultHolder, groupKeyArray[i]);
                sketch.merge(deserializedSketches[i]);
            }
        } else {
            String[] values = valueSet.getStringValuesSV();
            for (int i = 0; i < length; ++i) {
                ItemsSketch<String> sketch = this.getOrCreateSketch(groupByResultHolder, groupKeyArray[i]);
                sketch.update((Object)values[i]);
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet valueSet = blockValSetMap.get(this._expression);
        FieldSpec.DataType valueType = valueSet.getValueType();
        if (valueType == FieldSpec.DataType.BYTES) {
            ItemsSketch<String>[] deserializedSketches = this.deserializeSketches(blockValSetMap.get(this._expression).getBytesValuesSV());
            for (int i = 0; i < length; ++i) {
                for (int groupKey : groupKeysArray[i]) {
                    ItemsSketch<String> sketch = this.getOrCreateSketch(groupByResultHolder, groupKey);
                    sketch.merge(deserializedSketches[i]);
                }
            }
        } else {
            String[] values = valueSet.getStringValuesSV();
            for (int i = 0; i < length; ++i) {
                for (int groupKey : groupKeysArray[i]) {
                    ItemsSketch<String> sketch = this.getOrCreateSketch(groupByResultHolder, groupKey);
                    sketch.update((Object)values[i]);
                }
            }
        }
    }

    protected ItemsSketch<String> getOrCreateSketch(AggregationResultHolder aggregationResultHolder) {
        ItemsSketch sketch = (ItemsSketch)aggregationResultHolder.getResult();
        if (sketch == null) {
            sketch = new ItemsSketch(this._maxMapSize);
            aggregationResultHolder.setValue(sketch);
        }
        return sketch;
    }

    protected ItemsSketch<String> getOrCreateSketch(GroupByResultHolder groupByResultHolder, int groupKey) {
        ItemsSketch sketch = (ItemsSketch)groupByResultHolder.getResult(groupKey);
        if (sketch == null) {
            sketch = new ItemsSketch(this._maxMapSize);
            groupByResultHolder.setValueForKey(groupKey, sketch);
        }
        return sketch;
    }

    protected ItemsSketch<String>[] deserializeSketches(byte[][] serializedSketches) {
        ItemsSketch[] sketches = new ItemsSketch[serializedSketches.length];
        for (int i = 0; i < serializedSketches.length; ++i) {
            sketches[i] = ItemsSketch.getInstance((Memory)Memory.wrap((byte[])serializedSketches[i]), (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        }
        return sketches;
    }

    @Override
    public ItemsSketch<String> extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        return (ItemsSketch)aggregationResultHolder.getResult();
    }

    @Override
    public ItemsSketch<String> extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        return (ItemsSketch)groupByResultHolder.getResult(groupKey);
    }

    @Override
    public ItemsSketch<String> merge(ItemsSketch<String> sketch1, ItemsSketch<String> sketch2) {
        ItemsSketch union = new ItemsSketch(this._maxMapSize);
        if (sketch1 != null) {
            union.merge(sketch1);
        }
        if (sketch2 != null) {
            union.merge(sketch2);
        }
        return union;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.STRING;
    }

    @Override
    public String getResultColumnName() {
        return AggregationFunctionType.FREQUENTSTRINGSSKETCH.getName().toLowerCase() + "(" + this._expression + ")";
    }

    @Override
    public Comparable<?> extractFinalResult(ItemsSketch<String> sketch) {
        return new SerializedFrequentStringsSketch(sketch);
    }
}

