/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.core.query.utils.idset.IdSet;
import org.apache.pinot.core.query.utils.idset.IdSets;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;

public class IdSetAggregationFunction
extends BaseSingleInputAggregationFunction<IdSet, String> {
    private static final char PARAMETER_DELIMITER = ';';
    private static final char PARAMETER_KEY_VALUE_SEPARATOR = '=';
    private static final String UPPER_CASE_SIZE_THRESHOLD_IN_BYTES = "SIZETHRESHOLDINBYTES";
    private static final String UPPER_CASE_EXPECTED_INSERTIONS = "EXPECTEDINSERTIONS";
    private static final String UPPER_CASE_FPP = "FPP";
    private final int _sizeThresholdInBytes;
    private final int _expectedInsertions;
    private final double _fpp;

    public IdSetAggregationFunction(List<ExpressionContext> arguments) {
        super(arguments.get(0));
        if (arguments.size() == 1) {
            this._sizeThresholdInBytes = 0x800000;
            this._expectedInsertions = 5000000;
            this._fpp = 0.03;
        } else {
            String[] keyValuePairs;
            ExpressionContext parametersExpression = arguments.get(1);
            Preconditions.checkArgument((parametersExpression.getType() == ExpressionContext.Type.LITERAL ? 1 : 0) != 0, (Object)"Second argument of IdSet must be literal (parameters)");
            int sizeThresholdInBytes = 0x800000;
            int expectedInsertions = 5000000;
            double fpp = 0.03;
            String parametersString = parametersExpression.getLiteral().getStringValue();
            StringUtils.deleteWhitespace((String)parametersString);
            block10: for (String keyValuePair : keyValuePairs = StringUtils.split((String)parametersString, (char)';')) {
                String[] keyAndValue = StringUtils.split((String)keyValuePair, (char)'=');
                Preconditions.checkArgument((keyAndValue.length == 2 ? 1 : 0) != 0, (String)"Invalid parameter: %s", (Object)keyValuePair);
                String key = keyAndValue[0];
                String value = keyAndValue[1];
                switch (key.toUpperCase()) {
                    case "SIZETHRESHOLDINBYTES": {
                        sizeThresholdInBytes = Integer.parseInt(value);
                        continue block10;
                    }
                    case "EXPECTEDINSERTIONS": {
                        expectedInsertions = Integer.parseInt(value);
                        continue block10;
                    }
                    case "FPP": {
                        fpp = Double.parseDouble(value);
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid parameter key: " + key);
                    }
                }
            }
            this._sizeThresholdInBytes = sizeThresholdInBytes;
            this._expectedInsertions = expectedInsertions;
            this._fpp = fpp;
        }
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.IDSET;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        block32: {
            IdSet idSet;
            FieldSpec.DataType storedType;
            BlockValSet blockValSet;
            block31: {
                blockValSet = blockValSetMap.get(this._expression);
                storedType = blockValSet.getValueType().getStoredType();
                idSet = this.getIdSet(aggregationResultHolder, storedType);
                if (!blockValSet.isSingleValue()) break block31;
                switch (storedType) {
                    case INT: {
                        int[] intValuesSV = blockValSet.getIntValuesSV();
                        for (int i = 0; i < length; ++i) {
                            idSet.add(intValuesSV[i]);
                        }
                        break block32;
                    }
                    case LONG: {
                        long[] longValuesSV = blockValSet.getLongValuesSV();
                        for (int i = 0; i < length; ++i) {
                            idSet.add(longValuesSV[i]);
                        }
                        break block32;
                    }
                    case FLOAT: {
                        float[] floatValuesSV = blockValSet.getFloatValuesSV();
                        for (int i = 0; i < length; ++i) {
                            idSet.add(floatValuesSV[i]);
                        }
                        break block32;
                    }
                    case DOUBLE: {
                        double[] doubleValuesSV = blockValSet.getDoubleValuesSV();
                        for (int i = 0; i < length; ++i) {
                            idSet.add(doubleValuesSV[i]);
                        }
                        break block32;
                    }
                    case STRING: {
                        String[] stringValuesSV = blockValSet.getStringValuesSV();
                        for (int i = 0; i < length; ++i) {
                            idSet.add(stringValuesSV[i]);
                        }
                        break block32;
                    }
                    case BYTES: {
                        byte[][] bytesValuesSV = blockValSet.getBytesValuesSV();
                        for (int i = 0; i < length; ++i) {
                            idSet.add(bytesValuesSV[i]);
                        }
                        break block32;
                    }
                    default: {
                        throw new IllegalStateException("Illegal SV data type for ID_SET aggregation function: " + storedType);
                    }
                }
            }
            switch (storedType) {
                case INT: {
                    int[][] intValuesMV = blockValSet.getIntValuesMV();
                    for (int i = 0; i < length; ++i) {
                        for (int intValue : intValuesMV[i]) {
                            idSet.add(intValue);
                        }
                    }
                    break;
                }
                case LONG: {
                    long[][] longValuesMV = blockValSet.getLongValuesMV();
                    for (int i = 0; i < length; ++i) {
                        for (long longValue : longValuesMV[i]) {
                            idSet.add(longValue);
                        }
                    }
                    break;
                }
                case FLOAT: {
                    float[][] floatValuesMV = blockValSet.getFloatValuesMV();
                    for (int i = 0; i < length; ++i) {
                        for (float floatValue : floatValuesMV[i]) {
                            idSet.add(floatValue);
                        }
                    }
                    break;
                }
                case DOUBLE: {
                    double[][] doubleValuesMV = blockValSet.getDoubleValuesMV();
                    for (int i = 0; i < length; ++i) {
                        for (double doubleValue : doubleValuesMV[i]) {
                            idSet.add(doubleValue);
                        }
                    }
                    break;
                }
                case STRING: {
                    String[][] stringValuesMV = blockValSet.getStringValuesMV();
                    for (int i = 0; i < length; ++i) {
                        for (String stringValue : stringValuesMV[i]) {
                            idSet.add(stringValue);
                        }
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal MV data type for ID_SET aggregation function: " + storedType);
                }
            }
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        block32: {
            FieldSpec.DataType storedType;
            BlockValSet blockValSet;
            block31: {
                blockValSet = blockValSetMap.get(this._expression);
                storedType = blockValSet.getValueType().getStoredType();
                if (!blockValSet.isSingleValue()) break block31;
                switch (storedType) {
                    case INT: {
                        int[] intValuesSV = blockValSet.getIntValuesSV();
                        for (int i = 0; i < length; ++i) {
                            this.getIdSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.INT).add(intValuesSV[i]);
                        }
                        break block32;
                    }
                    case LONG: {
                        long[] longValuesSV = blockValSet.getLongValuesSV();
                        for (int i = 0; i < length; ++i) {
                            this.getIdSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.LONG).add(longValuesSV[i]);
                        }
                        break block32;
                    }
                    case FLOAT: {
                        float[] floatValuesSV = blockValSet.getFloatValuesSV();
                        for (int i = 0; i < length; ++i) {
                            this.getIdSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.FLOAT).add(floatValuesSV[i]);
                        }
                        break block32;
                    }
                    case DOUBLE: {
                        double[] doubleValuesSV = blockValSet.getDoubleValuesSV();
                        for (int i = 0; i < length; ++i) {
                            this.getIdSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.DOUBLE).add(doubleValuesSV[i]);
                        }
                        break block32;
                    }
                    case STRING: {
                        String[] stringValuesSV = blockValSet.getStringValuesSV();
                        for (int i = 0; i < length; ++i) {
                            this.getIdSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.STRING).add(stringValuesSV[i]);
                        }
                        break block32;
                    }
                    case BYTES: {
                        byte[][] bytesValuesSV = blockValSet.getBytesValuesSV();
                        for (int i = 0; i < length; ++i) {
                            this.getIdSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.BYTES).add(bytesValuesSV[i]);
                        }
                        break block32;
                    }
                    default: {
                        throw new IllegalStateException("Illegal SV data type for ID_SET aggregation function: " + storedType);
                    }
                }
            }
            switch (storedType) {
                case INT: {
                    int[][] intValuesMV = blockValSet.getIntValuesMV();
                    for (int i = 0; i < length; ++i) {
                        IdSet idSet = this.getIdSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.INT);
                        for (int intValue : intValuesMV[i]) {
                            idSet.add(intValue);
                        }
                    }
                    break;
                }
                case LONG: {
                    long[][] longValuesMV = blockValSet.getLongValuesMV();
                    for (int i = 0; i < length; ++i) {
                        IdSet idSet = this.getIdSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.LONG);
                        for (long longValue : longValuesMV[i]) {
                            idSet.add(longValue);
                        }
                    }
                    break;
                }
                case FLOAT: {
                    float[][] floatValuesMV = blockValSet.getFloatValuesMV();
                    for (int i = 0; i < length; ++i) {
                        IdSet idSet = this.getIdSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.FLOAT);
                        for (float floatValue : floatValuesMV[i]) {
                            idSet.add(floatValue);
                        }
                    }
                    break;
                }
                case DOUBLE: {
                    double[][] doubleValuesMV = blockValSet.getDoubleValuesMV();
                    for (int i = 0; i < length; ++i) {
                        IdSet idSet = this.getIdSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.DOUBLE);
                        for (double doubleValue : doubleValuesMV[i]) {
                            idSet.add(doubleValue);
                        }
                    }
                    break;
                }
                case STRING: {
                    String[][] stringValuesMV = blockValSet.getStringValuesMV();
                    for (int i = 0; i < length; ++i) {
                        IdSet idSet = this.getIdSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.STRING);
                        for (String stringValue : stringValuesMV[i]) {
                            idSet.add(stringValue);
                        }
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal MV data type for ID_SET aggregation function: " + storedType);
                }
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        block43: {
            FieldSpec.DataType storedType;
            BlockValSet blockValSet;
            block42: {
                blockValSet = blockValSetMap.get(this._expression);
                storedType = blockValSet.getValueType().getStoredType();
                if (!blockValSet.isSingleValue()) break block42;
                switch (storedType) {
                    case INT: {
                        int[] intValuesSV = blockValSet.getIntValuesSV();
                        for (int i = 0; i < length; ++i) {
                            int intValue = intValuesSV[i];
                            for (int groupKey : groupKeysArray[i]) {
                                this.getIdSet(groupByResultHolder, groupKey, FieldSpec.DataType.INT).add(intValue);
                            }
                        }
                        break block43;
                    }
                    case LONG: {
                        long[] longValuesSV = blockValSet.getLongValuesSV();
                        for (int i = 0; i < length; ++i) {
                            long longValue = longValuesSV[i];
                            for (int groupKey : groupKeysArray[i]) {
                                this.getIdSet(groupByResultHolder, groupKey, FieldSpec.DataType.LONG).add(longValue);
                            }
                        }
                        break block43;
                    }
                    case FLOAT: {
                        float[] floatValuesSV = blockValSet.getFloatValuesSV();
                        for (int i = 0; i < length; ++i) {
                            float floatValue = floatValuesSV[i];
                            for (int groupKey : groupKeysArray[i]) {
                                this.getIdSet(groupByResultHolder, groupKey, FieldSpec.DataType.FLOAT).add(floatValue);
                            }
                        }
                        break block43;
                    }
                    case DOUBLE: {
                        double[] doubleValuesSV = blockValSet.getDoubleValuesSV();
                        for (int i = 0; i < length; ++i) {
                            double doubleValue = doubleValuesSV[i];
                            for (int groupKey : groupKeysArray[i]) {
                                this.getIdSet(groupByResultHolder, groupKey, FieldSpec.DataType.DOUBLE).add(doubleValue);
                            }
                        }
                        break block43;
                    }
                    case STRING: {
                        String[] stringValuesSV = blockValSet.getStringValuesSV();
                        for (int i = 0; i < length; ++i) {
                            String stringValue = stringValuesSV[i];
                            for (int groupKey : groupKeysArray[i]) {
                                this.getIdSet(groupByResultHolder, groupKey, FieldSpec.DataType.STRING).add(stringValue);
                            }
                        }
                        break block43;
                    }
                    case BYTES: {
                        byte[][] bytesValuesSV = blockValSet.getBytesValuesSV();
                        for (int i = 0; i < length; ++i) {
                            byte[] bytesValue = bytesValuesSV[i];
                            for (int groupKey : groupKeysArray[i]) {
                                this.getIdSet(groupByResultHolder, groupKey, FieldSpec.DataType.BYTES).add(bytesValue);
                            }
                        }
                        break block43;
                    }
                    default: {
                        throw new IllegalStateException("Illegal SV data type for ID_SET aggregation function: " + storedType);
                    }
                }
            }
            switch (storedType) {
                case INT: {
                    int[][] intValuesMV = blockValSet.getIntValuesMV();
                    for (int i = 0; i < length; ++i) {
                        int[] intValues = intValuesMV[i];
                        for (int groupKey : groupKeysArray[i]) {
                            IdSet idSet = this.getIdSet(groupByResultHolder, groupKey, FieldSpec.DataType.INT);
                            for (int intValue : intValues) {
                                idSet.add(intValue);
                            }
                        }
                    }
                    break;
                }
                case LONG: {
                    long[][] longValuesMV = blockValSet.getLongValuesMV();
                    for (int i = 0; i < length; ++i) {
                        long[] longValues = longValuesMV[i];
                        for (int groupKey : groupKeysArray[i]) {
                            IdSet idSet = this.getIdSet(groupByResultHolder, groupKey, FieldSpec.DataType.LONG);
                            for (long longValue : longValues) {
                                idSet.add(longValue);
                            }
                        }
                    }
                    break;
                }
                case FLOAT: {
                    float[][] floatValuesMV = blockValSet.getFloatValuesMV();
                    for (int i = 0; i < length; ++i) {
                        float[] floatValues = floatValuesMV[i];
                        for (int groupKey : groupKeysArray[i]) {
                            IdSet idSet = this.getIdSet(groupByResultHolder, groupKey, FieldSpec.DataType.FLOAT);
                            for (float floatValue : floatValues) {
                                idSet.add(floatValue);
                            }
                        }
                    }
                    break;
                }
                case DOUBLE: {
                    double[][] doubleValuesMV = blockValSet.getDoubleValuesMV();
                    for (int i = 0; i < length; ++i) {
                        double[] doubleValues = doubleValuesMV[i];
                        for (int groupKey : groupKeysArray[i]) {
                            IdSet idSet = this.getIdSet(groupByResultHolder, groupKey, FieldSpec.DataType.DOUBLE);
                            for (double doubleValue : doubleValues) {
                                idSet.add(doubleValue);
                            }
                        }
                    }
                    break;
                }
                case STRING: {
                    String[][] stringValuesMV = blockValSet.getStringValuesMV();
                    for (int i = 0; i < length; ++i) {
                        String[] stringValues = stringValuesMV[i];
                        for (int groupKey : groupKeysArray[i]) {
                            IdSet idSet = this.getIdSet(groupByResultHolder, groupKey, FieldSpec.DataType.STRING);
                            for (String stringValue : stringValues) {
                                idSet.add(stringValue);
                            }
                        }
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal MV data type for ID_SET aggregation function: " + storedType);
                }
            }
        }
    }

    @Override
    public IdSet extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        IdSet idSet = (IdSet)aggregationResultHolder.getResult();
        return idSet != null ? idSet : IdSets.emptyIdSet();
    }

    @Override
    public IdSet extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        IdSet idSet = (IdSet)groupByResultHolder.getResult(groupKey);
        return idSet != null ? idSet : IdSets.emptyIdSet();
    }

    @Override
    public IdSet merge(IdSet intermediateResult1, IdSet intermediateResult2) {
        return IdSets.merge(intermediateResult1, intermediateResult2, this._sizeThresholdInBytes, this._expectedInsertions, this._fpp);
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.STRING;
    }

    @Override
    public String extractFinalResult(IdSet intermediateResult) {
        try {
            return intermediateResult.toBase64String();
        }
        catch (IOException e) {
            throw new RuntimeException("Caught exception while serializing IdSet", e);
        }
    }

    private IdSet getIdSet(AggregationResultHolder aggregationResultHolder, FieldSpec.DataType valueType) {
        IdSet idSet = (IdSet)aggregationResultHolder.getResult();
        if (idSet == null) {
            idSet = IdSets.create(valueType, this._sizeThresholdInBytes, this._expectedInsertions, this._fpp);
            aggregationResultHolder.setValue(idSet);
        }
        return idSet;
    }

    private IdSet getIdSet(GroupByResultHolder groupByResultHolder, int groupKey, FieldSpec.DataType valueType) {
        IdSet idSet = (IdSet)groupByResultHolder.getResult(groupKey);
        if (idSet == null) {
            idSet = IdSets.create(valueType, this._sizeThresholdInBytes, this._expectedInsertions, this._fpp);
            groupByResultHolder.setValueForKey(groupKey, idSet);
        }
        return idSet;
    }
}

