/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import com.google.common.base.Preconditions;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.Sketches;
import org.apache.datasketches.tuple.SummaryDeserializer;
import org.apache.datasketches.tuple.aninteger.IntegerSummary;
import org.apache.datasketches.tuple.aninteger.IntegerSummaryDeserializer;
import org.apache.datasketches.tuple.aninteger.IntegerSummarySetOperations;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.segment.local.customobject.CustomObjectAccumulator;
import org.apache.pinot.segment.local.customobject.TupleIntSketchAccumulator;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;

public class IntegerTupleSketchAggregationFunction
extends BaseSingleInputAggregationFunction<TupleIntSketchAccumulator, Comparable> {
    private static final int DEFAULT_ACCUMULATOR_THRESHOLD = 2;
    final ExpressionContext _expressionContext;
    final IntegerSummarySetOperations _setOps;
    protected int _accumulatorThreshold = 2;
    protected int _nominalEntries;

    public IntegerTupleSketchAggregationFunction(List<ExpressionContext> arguments, IntegerSummary.Mode mode) {
        super(arguments.get(0));
        Preconditions.checkArgument((arguments.size() <= 2 ? 1 : 0) != 0, (String)"Tuple Sketch Aggregation Function expects at most 2 arguments, got: %s", (int)arguments.size());
        this._expressionContext = arguments.get(0);
        this._setOps = new IntegerSummarySetOperations(mode, mode);
        if (arguments.size() == 2) {
            ExpressionContext secondArgument = arguments.get(1);
            Preconditions.checkArgument((secondArgument.getType() == ExpressionContext.Type.LITERAL ? 1 : 0) != 0, (String)"Tuple Sketch Aggregation Function expects the second argument to be a literal (parameters), but got: ", (Object)secondArgument.getType());
            if (secondArgument.getLiteral().getType() == FieldSpec.DataType.STRING) {
                Parameters parameters = new Parameters(secondArgument.getLiteral().getStringValue());
                this._accumulatorThreshold = parameters.getAccumulatorThreshold();
                this._nominalEntries = parameters.getNominalEntries();
            } else {
                this._nominalEntries = secondArgument.getLiteral().getIntValue();
            }
        } else {
            this._nominalEntries = (int)Math.pow(2.0, 14.0);
        }
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.DISTINCTCOUNTRAWINTEGERSUMTUPLESKETCH;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
        if (storedType == FieldSpec.DataType.BYTES) {
            byte[][] bytesValues = blockValSet.getBytesValuesSV();
            try {
                Sketch<IntegerSummary>[] sketches;
                TupleIntSketchAccumulator tupleIntSketchAccumulator = this.getAccumulator(aggregationResultHolder);
                for (Sketch<IntegerSummary> sketch : sketches = this.deserializeSketches(bytesValues, length)) {
                    tupleIntSketchAccumulator.apply(sketch);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Caught exception while aggregating Tuple Sketches", e);
            }
        } else {
            throw new IllegalStateException("Illegal data type for " + this.getType() + " aggregation function: " + storedType);
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
        if (storedType == FieldSpec.DataType.BYTES) {
            byte[][] bytesValues = blockValSet.getBytesValuesSV();
            try {
                Sketch<IntegerSummary>[] sketches = this.deserializeSketches(bytesValues, length);
                for (int i = 0; i < length; ++i) {
                    TupleIntSketchAccumulator tupleIntSketchAccumulator = this.getAccumulator(groupByResultHolder, groupKeyArray[i]);
                    Sketch<IntegerSummary> sketch = sketches[i];
                    tupleIntSketchAccumulator.apply(sketch);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Caught exception while aggregating Tuple Sketches", e);
            }
        } else {
            throw new IllegalStateException("Illegal data type for INTEGER_TUPLE_SKETCH_UNION aggregation function: " + storedType);
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
        boolean singleValue = blockValSet.isSingleValue();
        if (singleValue && storedType == FieldSpec.DataType.BYTES) {
            byte[][] bytesValues = blockValSetMap.get(this._expression).getBytesValuesSV();
            try {
                Sketch<IntegerSummary>[] sketches = this.deserializeSketches(bytesValues, length);
                for (int i = 0; i < length; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        this.getAccumulator(groupByResultHolder, groupKey).apply(sketches[i]);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Caught exception while aggregating Tuple Sketches", e);
            }
        } else {
            throw new IllegalStateException("Illegal data type for INTEGER_TUPLE_SKETCH_UNION aggregation function: " + storedType);
        }
    }

    @Override
    public TupleIntSketchAccumulator extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        TupleIntSketchAccumulator result = (TupleIntSketchAccumulator)aggregationResultHolder.getResult();
        if (result == null) {
            return new TupleIntSketchAccumulator(this._setOps, this._nominalEntries, this._accumulatorThreshold);
        }
        return result;
    }

    @Override
    public TupleIntSketchAccumulator extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        return (TupleIntSketchAccumulator)groupByResultHolder.getResult(groupKey);
    }

    @Override
    public TupleIntSketchAccumulator merge(TupleIntSketchAccumulator intermediateResult1, TupleIntSketchAccumulator intermediateResult2) {
        if (intermediateResult1 == null || intermediateResult1.isEmpty()) {
            return intermediateResult2;
        }
        if (intermediateResult2 == null || intermediateResult2.isEmpty()) {
            return intermediateResult1;
        }
        intermediateResult1.setThreshold(this._accumulatorThreshold);
        intermediateResult1.setNominalEntries(this._nominalEntries);
        intermediateResult1.setSetOperations(this._setOps);
        intermediateResult1.merge((CustomObjectAccumulator)intermediateResult2);
        return intermediateResult1;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.STRING;
    }

    @Override
    public Comparable extractFinalResult(TupleIntSketchAccumulator accumulator) {
        accumulator.setNominalEntries(this._nominalEntries);
        accumulator.setSetOperations(this._setOps);
        accumulator.setThreshold(this._accumulatorThreshold);
        return Base64.getEncoder().encodeToString(accumulator.getResult().toByteArray());
    }

    @Override
    public boolean canUseStarTree(Map<String, Object> functionParameters) {
        Object nominalEntriesParam = functionParameters.get("nominalEntries");
        int starTreeNominalEntries = nominalEntriesParam != null ? Integer.parseInt(String.valueOf(nominalEntriesParam)) : (int)Math.pow(2.0, 14.0);
        return this._nominalEntries <= starTreeNominalEntries;
    }

    private TupleIntSketchAccumulator getAccumulator(AggregationResultHolder aggregationResultHolder) {
        TupleIntSketchAccumulator accumulator = (TupleIntSketchAccumulator)aggregationResultHolder.getResult();
        if (accumulator == null) {
            accumulator = new TupleIntSketchAccumulator(this._setOps, this._nominalEntries, this._accumulatorThreshold);
            aggregationResultHolder.setValue(accumulator);
        }
        return accumulator;
    }

    private TupleIntSketchAccumulator getAccumulator(GroupByResultHolder groupByResultHolder, int groupKey) {
        TupleIntSketchAccumulator accumulator = (TupleIntSketchAccumulator)groupByResultHolder.getResult(groupKey);
        if (accumulator == null) {
            accumulator = new TupleIntSketchAccumulator(this._setOps, this._nominalEntries, this._accumulatorThreshold);
            groupByResultHolder.setValueForKey(groupKey, accumulator);
        }
        return accumulator;
    }

    private Sketch<IntegerSummary>[] deserializeSketches(byte[][] serializedSketches, int length) {
        Sketch[] sketches = new Sketch[length];
        for (int i = 0; i < length; ++i) {
            sketches[i] = Sketches.heapifySketch((Memory)Memory.wrap((byte[])serializedSketches[i]), (SummaryDeserializer)new IntegerSummaryDeserializer());
        }
        return sketches;
    }

    private static class Parameters {
        private static final char PARAMETER_DELIMITER = ';';
        private static final char PARAMETER_KEY_VALUE_SEPARATOR = '=';
        private static final String NOMINAL_ENTRIES_KEY = "nominalEntries";
        private static final String ACCUMULATOR_THRESHOLD_KEY = "accumulatorThreshold";
        private int _nominalEntries = (int)Math.pow(2.0, 14.0);
        private int _accumulatorThreshold = 2;

        Parameters(String parametersString) {
            String[] keyValuePairs;
            StringUtils.deleteWhitespace((String)parametersString);
            for (String keyValuePair : keyValuePairs = StringUtils.split((String)parametersString, (char)';')) {
                String[] keyAndValue = StringUtils.split((String)keyValuePair, (char)'=');
                Preconditions.checkArgument((keyAndValue.length == 2 ? 1 : 0) != 0, (String)"Invalid parameter: %s", (Object)keyValuePair);
                String key = keyAndValue[0];
                String value = keyAndValue[1];
                if (key.equalsIgnoreCase(NOMINAL_ENTRIES_KEY)) {
                    this._nominalEntries = Integer.parseInt(value);
                    continue;
                }
                if (key.equalsIgnoreCase(ACCUMULATOR_THRESHOLD_KEY)) {
                    this._accumulatorThreshold = Integer.parseInt(value);
                    continue;
                }
                throw new IllegalArgumentException("Invalid parameter key: " + key);
            }
        }

        int getNominalEntries() {
            return this._nominalEntries;
        }

        int getAccumulatorThreshold() {
            return this._accumulatorThreshold;
        }
    }
}

