/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.core.query.aggregation.function.LastWithTimeAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.segment.local.customobject.FloatLongPair;
import org.apache.pinot.segment.local.customobject.ValueLongPair;
import org.roaringbitmap.IntIterator;

public class LastFloatValueWithTimeAggregationFunction
extends LastWithTimeAggregationFunction<Float> {
    private static final ValueLongPair<Float> DEFAULT_VALUE_TIME_PAIR = new FloatLongPair(Float.valueOf(Float.NaN), Long.MIN_VALUE);

    public LastFloatValueWithTimeAggregationFunction(ExpressionContext dataCol, ExpressionContext timeCol, boolean nullHandlingEnabled) {
        super(dataCol, timeCol, ObjectSerDeUtils.FLOAT_LONG_PAIR_SER_DE, nullHandlingEnabled);
    }

    @Override
    public ValueLongPair<Float> constructValueLongPair(Float value, long time) {
        return new FloatLongPair(value, time);
    }

    @Override
    public ValueLongPair<Float> getDefaultValueTimePair() {
        return DEFAULT_VALUE_TIME_PAIR;
    }

    @Override
    public Float readCell(BlockValSet block, int docId) {
        return Float.valueOf(block.getFloatValuesSV()[docId]);
    }

    @Override
    public void aggregateGroupResultWithRawDataSv(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, BlockValSet blockValSet, BlockValSet timeValSet) {
        float[] floatValues = blockValSet.getFloatValuesSV();
        long[] timeValues = timeValSet.getLongValuesSV();
        IntIterator nullIdxIterator = this.orNullIterator(blockValSet, timeValSet);
        this.forEachNotNull(length, nullIdxIterator, (int from, int to) -> {
            for (int i = from; i < to; ++i) {
                float data = floatValues[i];
                long time = timeValues[i];
                this.setGroupByResult(groupKeyArray[i], groupByResultHolder, Float.valueOf(data), time);
            }
        });
    }

    @Override
    public void aggregateGroupResultWithRawDataMv(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, BlockValSet blockValSet, BlockValSet timeValSet) {
        float[] floatValues = blockValSet.getFloatValuesSV();
        long[] timeValues = timeValSet.getLongValuesSV();
        IntIterator nullIdxIterator = this.orNullIterator(blockValSet, timeValSet);
        this.forEachNotNull(length, nullIdxIterator, (int from, int to) -> {
            for (int i = from; i < to; ++i) {
                float value = floatValues[i];
                long time = timeValues[i];
                for (int groupKey : groupKeysArray[i]) {
                    this.setGroupByResult(groupKey, groupByResultHolder, Float.valueOf(value), time);
                }
            }
        });
    }

    @Override
    public String getResultColumnName() {
        return this.getType().getName().toLowerCase() + "(" + this._expression + "," + this._timeCol + ",'FLOAT')";
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.FLOAT;
    }
}

