/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.NullableSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.segment.local.customobject.IntLongPair;
import org.apache.pinot.segment.local.customobject.ValueLongPair;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.IntIterator;

public abstract class LastWithTimeAggregationFunction<V extends Comparable<V>>
extends NullableSingleInputAggregationFunction<ValueLongPair<V>, V> {
    protected final ExpressionContext _timeCol;
    private final ObjectSerDeUtils.ObjectSerDe<? extends ValueLongPair<V>> _objectSerDe;

    public LastWithTimeAggregationFunction(ExpressionContext dataCol, ExpressionContext timeCol, ObjectSerDeUtils.ObjectSerDe<? extends ValueLongPair<V>> objectSerDe, boolean nullHandlingEnabled) {
        super(dataCol, nullHandlingEnabled);
        this._timeCol = timeCol;
        this._objectSerDe = objectSerDe;
    }

    public abstract ValueLongPair<V> constructValueLongPair(V var1, long var2);

    public abstract ValueLongPair<V> getDefaultValueTimePair();

    public abstract V readCell(BlockValSet var1, int var2);

    public abstract void aggregateGroupResultWithRawDataSv(int var1, int[] var2, GroupByResultHolder var3, BlockValSet var4, BlockValSet var5);

    public abstract void aggregateGroupResultWithRawDataMv(int var1, int[][] var2, GroupByResultHolder var3, BlockValSet var4, BlockValSet var5);

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.LASTWITHTIME;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        BlockValSet blockTimeSet = blockValSetMap.get(this._timeCol);
        if (blockValSet.getValueType() != FieldSpec.DataType.BYTES) {
            IntLongPair defaultPair = new IntLongPair(Integer.valueOf(Integer.MIN_VALUE), Long.MIN_VALUE);
            long[] timeValues = blockTimeSet.getLongValuesSV();
            IntIterator nullIdxIterator = this.orNullIterator(blockValSet, blockTimeSet);
            IntLongPair bestPair = this.foldNotNull(length, nullIdxIterator, defaultPair, (A pair, int from, int to) -> {
                IntLongPair actualPair = pair;
                for (int i = from; i < to; ++i) {
                    long time = timeValues[i];
                    if (time < actualPair.getTime()) continue;
                    actualPair = new IntLongPair(Integer.valueOf(i), time);
                }
                return actualPair;
            });
            Comparable<Object> bestValue = (Integer)bestPair.getValue() < 0 ? this.getDefaultValueTimePair().getValue() : this.readCell(blockValSet, (Integer)bestPair.getValue());
            this.setAggregationResult(aggregationResultHolder, bestValue, bestPair.getTime());
        } else {
            ValueLongPair<V> defaultValueLongPair = this.getDefaultValueTimePair();
            Comparable lastData = defaultValueLongPair.getValue();
            long lastTime = defaultValueLongPair.getTime();
            byte[][] bytesValues = blockValSet.getBytesValuesSV();
            for (int i = 0; i < length; ++i) {
                ValueLongPair<V> lastWithTimePair = this._objectSerDe.deserialize(bytesValues[i]);
                Comparable data = lastWithTimePair.getValue();
                long time = lastWithTimePair.getTime();
                if (time < lastTime) continue;
                lastTime = time;
                lastData = data;
            }
            this.setAggregationResult(aggregationResultHolder, lastData, lastTime);
        }
    }

    protected void setAggregationResult(AggregationResultHolder aggregationResultHolder, V data, long time) {
        ValueLongPair lastWithTimePair = (ValueLongPair)aggregationResultHolder.getResult();
        if (lastWithTimePair == null || time >= lastWithTimePair.getTime()) {
            aggregationResultHolder.setValue(this.constructValueLongPair(data, time));
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        BlockValSet timeValSet = blockValSetMap.get(this._timeCol);
        if (blockValSet.getValueType() != FieldSpec.DataType.BYTES) {
            this.aggregateGroupResultWithRawDataSv(length, groupKeyArray, groupByResultHolder, blockValSet, timeValSet);
        } else {
            byte[][] bytesValues = blockValSet.getBytesValuesSV();
            for (int i = 0; i < length; ++i) {
                ValueLongPair<V> lastWithTimePair = this._objectSerDe.deserialize(bytesValues[i]);
                this.setGroupByResult(groupKeyArray[i], groupByResultHolder, lastWithTimePair.getValue(), lastWithTimePair.getTime());
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        BlockValSet timeValSet = blockValSetMap.get(this._timeCol);
        if (blockValSet.getValueType() != FieldSpec.DataType.BYTES) {
            this.aggregateGroupResultWithRawDataMv(length, groupKeysArray, groupByResultHolder, blockValSet, timeValSet);
        } else {
            byte[][] bytesValues = blockValSet.getBytesValuesSV();
            for (int i = 0; i < length; ++i) {
                ValueLongPair<V> lastWithTimePair = this._objectSerDe.deserialize(bytesValues[i]);
                Comparable data = lastWithTimePair.getValue();
                long time = lastWithTimePair.getTime();
                for (int groupKey : groupKeysArray[i]) {
                    this.setGroupByResult(groupKey, groupByResultHolder, data, time);
                }
            }
        }
    }

    protected void setGroupByResult(int groupKey, GroupByResultHolder groupByResultHolder, V data, long time) {
        ValueLongPair lastWithTimePair = (ValueLongPair)groupByResultHolder.getResult(groupKey);
        if (lastWithTimePair == null || time >= lastWithTimePair.getTime()) {
            groupByResultHolder.setValueForKey(groupKey, this.constructValueLongPair(data, time));
        }
    }

    @Override
    public ValueLongPair<V> extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        ValueLongPair lastWithTimePair = (ValueLongPair)aggregationResultHolder.getResult();
        if (lastWithTimePair == null) {
            return this.getDefaultValueTimePair();
        }
        return lastWithTimePair;
    }

    @Override
    public ValueLongPair<V> extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        ValueLongPair lastWithTimePair = (ValueLongPair)groupByResultHolder.getResult(groupKey);
        if (lastWithTimePair == null) {
            return this.getDefaultValueTimePair();
        }
        return lastWithTimePair;
    }

    @Override
    public ValueLongPair<V> merge(ValueLongPair<V> intermediateResult1, ValueLongPair<V> intermediateResult2) {
        if (intermediateResult1.getTime() >= intermediateResult2.getTime()) {
            return intermediateResult1;
        }
        return intermediateResult2;
    }

    @Override
    public List<ExpressionContext> getInputExpressions() {
        return Arrays.asList(this._expression, this._timeCol);
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public V extractFinalResult(ValueLongPair<V> intermediateResult) {
        return (V)intermediateResult.getValue();
    }
}

