/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.DoubleAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.NullableSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.DoubleGroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;

public class MaxAggregationFunction
extends NullableSingleInputAggregationFunction<Double, Double> {
    private static final double DEFAULT_INITIAL_VALUE = Double.NEGATIVE_INFINITY;

    public MaxAggregationFunction(List<ExpressionContext> arguments, boolean nullHandlingEnabled) {
        this(MaxAggregationFunction.verifySingleArgument(arguments, "MAX"), nullHandlingEnabled);
    }

    protected MaxAggregationFunction(ExpressionContext expression, boolean nullHandlingEnabled) {
        super(expression, nullHandlingEnabled);
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.MAX;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        if (this._nullHandlingEnabled) {
            return new ObjectAggregationResultHolder();
        }
        return new DoubleAggregationResultHolder(Double.NEGATIVE_INFINITY);
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        if (this._nullHandlingEnabled) {
            return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
        }
        return new DoubleGroupByResultHolder(initialCapacity, maxCapacity, Double.NEGATIVE_INFINITY);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        switch (blockValSet.getValueType().getStoredType()) {
            case INT: {
                int[] values = blockValSet.getIntValuesSV();
                Integer max = this.foldNotNull(length, blockValSet, null, (A acum, int from, int to) -> {
                    int innerMax = values[from];
                    for (int i = from; i < to; ++i) {
                        innerMax = Math.max(innerMax, values[i]);
                    }
                    return acum == null ? innerMax : Math.max(acum, innerMax);
                });
                this.updateAggregationResultHolder(aggregationResultHolder, max);
                break;
            }
            case LONG: {
                long[] values = blockValSet.getLongValuesSV();
                Long max = this.foldNotNull(length, blockValSet, null, (A acum, int from, int to) -> {
                    long innerMax = values[from];
                    for (int i = from; i < to; ++i) {
                        innerMax = Math.max(innerMax, values[i]);
                    }
                    return acum == null ? innerMax : Math.max(acum, innerMax);
                });
                this.updateAggregationResultHolder(aggregationResultHolder, max);
                break;
            }
            case FLOAT: {
                float[] values = blockValSet.getFloatValuesSV();
                Float max = this.foldNotNull(length, blockValSet, null, (A acum, int from, int to) -> {
                    float innerMax = values[from];
                    for (int i = from; i < to; ++i) {
                        innerMax = Math.max(innerMax, values[i]);
                    }
                    return Float.valueOf(acum == null ? innerMax : Math.max(acum.floatValue(), innerMax));
                });
                this.updateAggregationResultHolder(aggregationResultHolder, max);
                break;
            }
            case DOUBLE: {
                double[] values = blockValSet.getDoubleValuesSV();
                Double max = this.foldNotNull(length, blockValSet, null, (A acum, int from, int to) -> {
                    double innerMax = values[from];
                    for (int i = from; i < to; ++i) {
                        innerMax = Math.max(innerMax, values[i]);
                    }
                    return acum == null ? innerMax : Math.max(acum, innerMax);
                });
                this.updateAggregationResultHolder(aggregationResultHolder, max);
                break;
            }
            case BIG_DECIMAL: {
                BigDecimal[] values = blockValSet.getBigDecimalValuesSV();
                BigDecimal max = this.foldNotNull(length, blockValSet, null, (A acum, int from, int to) -> {
                    BigDecimal innerMax = values[from];
                    for (int i = from; i < to; ++i) {
                        innerMax = innerMax.max(values[i]);
                    }
                    return acum == null ? innerMax : acum.max(innerMax);
                });
                this.updateAggregationResultHolder(aggregationResultHolder, max);
                break;
            }
            default: {
                throw new IllegalStateException("Cannot compute max for non-numeric type: " + blockValSet.getValueType());
            }
        }
    }

    private void updateAggregationResultHolder(AggregationResultHolder aggregationResultHolder, Number max) {
        if (max != null) {
            if (this._nullHandlingEnabled) {
                Double otherMax = (Double)aggregationResultHolder.getResult();
                aggregationResultHolder.setValue(otherMax == null ? max.doubleValue() : Math.max(max.doubleValue(), otherMax));
            } else {
                double otherMax = aggregationResultHolder.getDoubleResult();
                aggregationResultHolder.setValue(Math.max(max.doubleValue(), otherMax));
            }
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        double[] valueArray = blockValSet.getDoubleValuesSV();
        if (this._nullHandlingEnabled) {
            this.forEachNotNull(length, blockValSet, (int from, int to) -> {
                for (int i = from; i < to; ++i) {
                    double value = valueArray[i];
                    int groupKey = groupKeyArray[i];
                    Double result = (Double)groupByResultHolder.getResult(groupKey);
                    if (result != null && !(value > result)) continue;
                    groupByResultHolder.setValueForKey(groupKey, value);
                }
            });
        } else {
            for (int i = 0; i < length; ++i) {
                double value = valueArray[i];
                int groupKey = groupKeyArray[i];
                if (!(value > groupByResultHolder.getDoubleResult(groupKey))) continue;
                groupByResultHolder.setValueForKey(groupKey, value);
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        double[] valueArray = blockValSet.getDoubleValuesSV();
        if (this._nullHandlingEnabled) {
            this.forEachNotNull(length, blockValSet, (int from, int to) -> {
                for (int i = from; i < to; ++i) {
                    double value = valueArray[i];
                    for (int groupKey : groupKeysArray[i]) {
                        Double result = (Double)groupByResultHolder.getResult(groupKey);
                        if (result != null && !(value > result)) continue;
                        groupByResultHolder.setValueForKey(groupKey, value);
                    }
                }
            });
        } else {
            for (int i = 0; i < length; ++i) {
                double value = valueArray[i];
                for (int groupKey : groupKeysArray[i]) {
                    if (!(value > groupByResultHolder.getDoubleResult(groupKey))) continue;
                    groupByResultHolder.setValueForKey(groupKey, value);
                }
            }
        }
    }

    @Override
    public Double extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        if (this._nullHandlingEnabled) {
            return (Double)aggregationResultHolder.getResult();
        }
        return aggregationResultHolder.getDoubleResult();
    }

    @Override
    public Double extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        if (this._nullHandlingEnabled) {
            return (Double)groupByResultHolder.getResult(groupKey);
        }
        return groupByResultHolder.getDoubleResult(groupKey);
    }

    @Override
    public Double merge(Double intermediateMaxResult1, Double intermediateMaxResult2) {
        if (this._nullHandlingEnabled) {
            if (intermediateMaxResult1 == null) {
                return intermediateMaxResult2;
            }
            if (intermediateMaxResult2 == null) {
                return intermediateMaxResult1;
            }
        }
        if (intermediateMaxResult1 > intermediateMaxResult2) {
            return intermediateMaxResult1;
        }
        return intermediateMaxResult2;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.DOUBLE;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.DOUBLE;
    }

    @Override
    public Double extractFinalResult(Double intermediateResult) {
        return intermediateResult;
    }

    @Override
    public Double mergeFinalResult(Double finalResult1, Double finalResult2) {
        return this.merge(finalResult1, finalResult2);
    }
}

