/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.DoubleAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.NullableSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.DoubleGroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;

public class MinAggregationFunction
extends NullableSingleInputAggregationFunction<Double, Double> {
    private static final double DEFAULT_VALUE = Double.POSITIVE_INFINITY;

    public MinAggregationFunction(List<ExpressionContext> arguments, boolean nullHandlingEnabled) {
        this(MinAggregationFunction.verifySingleArgument(arguments, "MIN"), nullHandlingEnabled);
    }

    protected MinAggregationFunction(ExpressionContext expression, boolean nullHandlingEnabled) {
        super(expression, nullHandlingEnabled);
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.MIN;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        if (this._nullHandlingEnabled) {
            return new ObjectAggregationResultHolder();
        }
        return new DoubleAggregationResultHolder(Double.POSITIVE_INFINITY);
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        if (this._nullHandlingEnabled) {
            return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
        }
        return new DoubleGroupByResultHolder(initialCapacity, maxCapacity, Double.POSITIVE_INFINITY);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        switch (blockValSet.getValueType().getStoredType()) {
            case INT: {
                int[] values = blockValSet.getIntValuesSV();
                Integer min = this.foldNotNull(length, blockValSet, null, (A acum, int from, int to) -> {
                    int innerMin = values[from];
                    for (int i = from; i < to; ++i) {
                        innerMin = Math.min(innerMin, values[i]);
                    }
                    return acum == null ? innerMin : Math.min(acum, innerMin);
                });
                this.updateAggregationResultHolder(aggregationResultHolder, min);
                break;
            }
            case LONG: {
                long[] values = blockValSet.getLongValuesSV();
                Long min = this.foldNotNull(length, blockValSet, null, (A acum, int from, int to) -> {
                    long innerMin = values[from];
                    for (int i = from; i < to; ++i) {
                        innerMin = Math.min(innerMin, values[i]);
                    }
                    return acum == null ? innerMin : Math.min(acum, innerMin);
                });
                this.updateAggregationResultHolder(aggregationResultHolder, min);
                break;
            }
            case FLOAT: {
                float[] values = blockValSet.getFloatValuesSV();
                Float min = this.foldNotNull(length, blockValSet, null, (A acum, int from, int to) -> {
                    float innerMin = values[from];
                    for (int i = from; i < to; ++i) {
                        innerMin = Math.min(innerMin, values[i]);
                    }
                    return Float.valueOf(acum == null ? innerMin : Math.min(acum.floatValue(), innerMin));
                });
                this.updateAggregationResultHolder(aggregationResultHolder, min);
                break;
            }
            case DOUBLE: {
                double[] values = blockValSet.getDoubleValuesSV();
                Double min = this.foldNotNull(length, blockValSet, null, (A acum, int from, int to) -> {
                    double innerMin = values[from];
                    for (int i = from; i < to; ++i) {
                        innerMin = Math.min(innerMin, values[i]);
                    }
                    return acum == null ? innerMin : Math.min(acum, innerMin);
                });
                this.updateAggregationResultHolder(aggregationResultHolder, min);
                break;
            }
            case BIG_DECIMAL: {
                BigDecimal[] values = blockValSet.getBigDecimalValuesSV();
                BigDecimal min = this.foldNotNull(length, blockValSet, null, (A acum, int from, int to) -> {
                    BigDecimal innerMin = values[from];
                    for (int i = from; i < to; ++i) {
                        innerMin = innerMin.min(values[i]);
                    }
                    return acum == null ? innerMin : acum.min(innerMin);
                });
                this.updateAggregationResultHolder(aggregationResultHolder, min);
                break;
            }
            default: {
                throw new IllegalStateException("Cannot compute min for non-numeric type: " + blockValSet.getValueType());
            }
        }
    }

    private void updateAggregationResultHolder(AggregationResultHolder aggregationResultHolder, Number min) {
        if (min != null) {
            if (this._nullHandlingEnabled) {
                Double otherMin = (Double)aggregationResultHolder.getResult();
                aggregationResultHolder.setValue(otherMin == null ? min.doubleValue() : Math.min(min.doubleValue(), otherMin));
            } else {
                double otherMin = aggregationResultHolder.getDoubleResult();
                aggregationResultHolder.setValue(Math.min(min.doubleValue(), otherMin));
            }
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        double[] valueArray = blockValSet.getDoubleValuesSV();
        if (this._nullHandlingEnabled) {
            this.forEachNotNull(length, blockValSet, (int from, int to) -> {
                for (int i = from; i < to; ++i) {
                    double value = valueArray[i];
                    int groupKey = groupKeyArray[i];
                    Double result = (Double)groupByResultHolder.getResult(groupKey);
                    if (result != null && !(value < result)) continue;
                    groupByResultHolder.setValueForKey(groupKey, value);
                }
            });
        } else {
            for (int i = 0; i < length; ++i) {
                double value = valueArray[i];
                int groupKey = groupKeyArray[i];
                if (!(value < groupByResultHolder.getDoubleResult(groupKey))) continue;
                groupByResultHolder.setValueForKey(groupKey, value);
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        double[] valueArray = blockValSet.getDoubleValuesSV();
        if (this._nullHandlingEnabled) {
            this.forEachNotNull(length, blockValSet, (int from, int to) -> {
                for (int i = from; i < to; ++i) {
                    double value = valueArray[i];
                    for (int groupKey : groupKeysArray[i]) {
                        Double result = (Double)groupByResultHolder.getResult(groupKey);
                        if (result != null && !(value < result)) continue;
                        groupByResultHolder.setValueForKey(groupKey, value);
                    }
                }
            });
        } else {
            for (int i = 0; i < length; ++i) {
                double value = valueArray[i];
                for (int groupKey : groupKeysArray[i]) {
                    if (!(value < groupByResultHolder.getDoubleResult(groupKey))) continue;
                    groupByResultHolder.setValueForKey(groupKey, value);
                }
            }
        }
    }

    @Override
    public Double extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        if (this._nullHandlingEnabled) {
            return (Double)aggregationResultHolder.getResult();
        }
        return aggregationResultHolder.getDoubleResult();
    }

    @Override
    public Double extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        if (this._nullHandlingEnabled) {
            return (Double)groupByResultHolder.getResult(groupKey);
        }
        return groupByResultHolder.getDoubleResult(groupKey);
    }

    @Override
    public Double merge(Double intermediateMinResult1, Double intermediateMinResult2) {
        if (this._nullHandlingEnabled) {
            if (intermediateMinResult1 == null) {
                return intermediateMinResult2;
            }
            if (intermediateMinResult2 == null) {
                return intermediateMinResult1;
            }
        }
        if (intermediateMinResult1 < intermediateMinResult2) {
            return intermediateMinResult1;
        }
        return intermediateMinResult2;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.DOUBLE;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.DOUBLE;
    }

    @Override
    public Double extractFinalResult(Double intermediateResult) {
        return intermediateResult;
    }

    @Override
    public Double mergeFinalResult(Double finalResult1, Double finalResult2) {
        return this.merge(finalResult1, finalResult2);
    }
}

