/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.RoaringBitmap;

public abstract class NullableSingleInputAggregationFunction<I, F extends Comparable>
extends BaseSingleInputAggregationFunction<I, F> {
    protected final boolean _nullHandlingEnabled;

    public NullableSingleInputAggregationFunction(ExpressionContext expression, boolean nullHandlingEnabled) {
        super(expression);
        this._nullHandlingEnabled = nullHandlingEnabled;
    }

    public void forEachNotNull(int length, BlockValSet blockValSet, BatchConsumer consumer) {
        if (!this._nullHandlingEnabled) {
            consumer.consume(0, length);
            return;
        }
        RoaringBitmap roaringBitmap = blockValSet.getNullBitmap();
        if (roaringBitmap == null) {
            consumer.consume(0, length);
            return;
        }
        if (!roaringBitmap.contains(0L, (long)length)) {
            this.forEachNotNull(length, (IntIterator)roaringBitmap.getIntIterator(), consumer);
        }
    }

    public void forEachNotNull(int length, IntIterator nullIndexIterator, BatchConsumer consumer) {
        int prev = 0;
        while (nullIndexIterator.hasNext() && prev < length) {
            int nextNull = Math.min(nullIndexIterator.next(), length);
            if (nextNull > prev) {
                consumer.consume(prev, nextNull);
            }
            prev = nextNull + 1;
        }
        if (prev < length) {
            consumer.consume(prev, length);
        }
    }

    public <A> A foldNotNull(int length, BlockValSet blockValSet, A initialAcum, Reducer<A> reducer) {
        return this.foldNotNull(length, this._nullHandlingEnabled ? blockValSet.getNullBitmap() : null, initialAcum, reducer);
    }

    public <A> A foldNotNull(int length, @Nullable RoaringBitmap roaringBitmap, A initialAcum, Reducer<A> reducer) {
        if (this._nullHandlingEnabled && roaringBitmap != null && roaringBitmap.contains(0L, (long)length)) {
            return initialAcum;
        }
        PeekableIntIterator intIterator = roaringBitmap == null ? null : roaringBitmap.getIntIterator();
        return this.foldNotNull(length, (IntIterator)intIterator, initialAcum, reducer);
    }

    public <A> A foldNotNull(int length, @Nullable IntIterator nullIndexIterator, A initialAcum, Reducer<A> reducer) {
        A acum = initialAcum;
        if (length == 0) {
            return acum;
        }
        if (!this._nullHandlingEnabled || nullIndexIterator == null || !nullIndexIterator.hasNext()) {
            return reducer.apply(initialAcum, 0, length);
        }
        int prev = 0;
        while (nullIndexIterator.hasNext() && prev < length) {
            int nextNull = Math.min(nullIndexIterator.next(), length);
            if (nextNull > prev) {
                acum = reducer.apply(acum, prev, nextNull);
            }
            prev = nextNull + 1;
        }
        if (prev < length) {
            acum = reducer.apply(acum, prev, length);
        }
        return acum;
    }

    public IntIterator orNullIterator(BlockValSet valSet1, BlockValSet valSet2) {
        if (!this._nullHandlingEnabled) {
            return EmptyIntIterator.INSTANCE;
        }
        RoaringBitmap nullBlock1 = valSet1.getNullBitmap();
        RoaringBitmap nullBlock2 = valSet2.getNullBitmap();
        if (nullBlock1 == null) {
            return nullBlock2 == null ? EmptyIntIterator.INSTANCE : nullBlock2.getIntIterator();
        }
        if (nullBlock2 == null) {
            return nullBlock1.getIntIterator();
        }
        return new MinIntIterator((IntIterator)nullBlock1.getIntIterator(), (IntIterator)nullBlock2.getIntIterator());
    }

    public static class MinIntIterator
    implements IntIterator {
        private final IntIterator _it1;
        private final IntIterator _it2;
        private int _next1 = -1;
        private int _next2 = -1;

        public MinIntIterator(IntIterator it1, IntIterator it2) {
            this._it1 = it1;
            this._it2 = it2;
        }

        public IntIterator clone() {
            return new MinIntIterator(this._it1.clone(), this._it2.clone());
        }

        public boolean hasNext() {
            return this._next1 > 0 || this._next2 > 0 || this._it1.hasNext() || this._it2.hasNext();
        }

        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this._next1 < 0) {
                if (this._it1.hasNext()) {
                    this._next1 = this._it1.next();
                } else {
                    if (this._next2 >= 0) {
                        return this.consume2();
                    }
                    return this._it2.next();
                }
            }
            if (this._next2 < 0) {
                if (this._it2.hasNext()) {
                    this._next2 = this._it2.next();
                } else {
                    if (this._next1 >= 0) {
                        return this.consume1();
                    }
                    return this._it1.next();
                }
            }
            assert (this._next1 >= 0 && this._next2 >= 0);
            if (this._next1 <= this._next2) {
                return this.consume1();
            }
            return this.consume2();
        }

        private int consume1() {
            int nextVal = this._next1;
            this._next1 = -1;
            return nextVal;
        }

        private int consume2() {
            int nextVal = this._next2;
            this._next2 = -1;
            return nextVal;
        }
    }

    public static class EmptyIntIterator
    implements IntIterator {
        public static final EmptyIntIterator INSTANCE = new EmptyIntIterator();

        private EmptyIntIterator() {
        }

        public IntIterator clone() {
            return this;
        }

        public boolean hasNext() {
            return false;
        }

        public int next() {
            throw new NoSuchElementException();
        }
    }

    @FunctionalInterface
    public static interface Reducer<A> {
        public A apply(A var1, int var2, int var3);
    }

    @FunctionalInterface
    public static interface BatchConsumer {
        public void consume(int var1, int var2);
    }
}

