/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.ParentAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.core.query.aggregation.utils.exprminmax.ExprMinMaxMeasuringValSetWrapper;
import org.apache.pinot.core.query.aggregation.utils.exprminmax.ExprMinMaxObject;
import org.apache.pinot.core.query.aggregation.utils.exprminmax.ExprMinMaxProjectionValSetWrapper;
import org.apache.pinot.segment.spi.AggregationFunctionType;

public class ParentExprMinMaxAggregationFunction
extends ParentAggregationFunction<ExprMinMaxObject, ExprMinMaxObject> {
    private final List<ExpressionContext> _measuringColumns;
    private final List<ExpressionContext> _projectionColumns;
    private final boolean _isMax;
    private final ExpressionContext _functionIdContext;
    private final ExpressionContext _numMeasuringColumnContext;
    private final int _numMeasuringColumns;
    private final int _numProjectionColumns;
    private final ThreadLocal<List<ExprMinMaxMeasuringValSetWrapper>> _exprMinMaxWrapperMeasuringColumnSets = ThreadLocal.withInitial(ArrayList::new);
    private final ThreadLocal<List<ExprMinMaxProjectionValSetWrapper>> _exprMinMaxWrapperProjectionColumnSets = ThreadLocal.withInitial(ArrayList::new);
    private final ThreadLocal<DataSchema> _measuringColumnSchema = new ThreadLocal();
    private final ThreadLocal<DataSchema> _projectionColumnSchema = new ThreadLocal();
    private final ThreadLocal<Boolean> _schemaInitialized = ThreadLocal.withInitial(() -> false);

    public ParentExprMinMaxAggregationFunction(List<ExpressionContext> arguments, boolean isMax) {
        super(arguments);
        this._isMax = isMax;
        this._functionIdContext = arguments.get(0);
        this._numMeasuringColumnContext = arguments.get(1);
        this._numMeasuringColumns = this._numMeasuringColumnContext.getLiteral().getIntValue();
        this._measuringColumns = arguments.subList(2, 2 + this._numMeasuringColumns);
        this._projectionColumns = arguments.subList(2 + this._numMeasuringColumns, arguments.size());
        this._numProjectionColumns = this._projectionColumns.size();
    }

    @Override
    public AggregationFunctionType getType() {
        return this._isMax ? AggregationFunctionType.EXPRMAX : AggregationFunctionType.EXPRMIN;
    }

    @Override
    public List<ExpressionContext> getInputExpressions() {
        ArrayList<ExpressionContext> expressionContexts = new ArrayList<ExpressionContext>();
        expressionContexts.add(this._functionIdContext);
        expressionContexts.add(this._numMeasuringColumnContext);
        expressionContexts.addAll(this._measuringColumns);
        expressionContexts.addAll(this._projectionColumns);
        return expressionContexts;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        ExprMinMaxObject exprMinMaxObject = (ExprMinMaxObject)aggregationResultHolder.getResult();
        if (exprMinMaxObject == null) {
            this.initializeWithNewDataBlocks(blockValSetMap);
            exprMinMaxObject = new ExprMinMaxObject(this._measuringColumnSchema.get(), this._projectionColumnSchema.get());
        }
        ArrayList<Integer> rowIds = new ArrayList<Integer>();
        for (int i = 0; i < length; ++i) {
            int compareResult = exprMinMaxObject.compareAndSetKey(this._exprMinMaxWrapperMeasuringColumnSets.get(), i, this._isMax);
            if (compareResult == 0) {
                rowIds.add(i);
                continue;
            }
            if (compareResult <= 0) continue;
            rowIds.clear();
            rowIds.add(i);
        }
        for (Integer rowId : rowIds) {
            exprMinMaxObject.addVal(this._exprMinMaxWrapperProjectionColumnSets.get(), rowId);
        }
        aggregationResultHolder.setValue(exprMinMaxObject);
    }

    private void initializeWithNewDataBlocks(Map<ExpressionContext, BlockValSet> blockValSetMap) {
        if (blockValSetMap == null) {
            this.initializeForEmptyDocSet();
            return;
        }
        if (this._schemaInitialized.get().booleanValue()) {
            int i;
            for (i = 0; i < this._numMeasuringColumns; ++i) {
                this._exprMinMaxWrapperMeasuringColumnSets.get().get(i).setNewBlock(blockValSetMap.get(this._measuringColumns.get(i)));
            }
            for (i = 0; i < this._numProjectionColumns; ++i) {
                this._exprMinMaxWrapperProjectionColumnSets.get().get(i).setNewBlock(blockValSetMap.get(this._projectionColumns.get(i)));
            }
            return;
        }
        this._schemaInitialized.set(true);
        this.initializeMeasuringColumnValSet(blockValSetMap);
        this.initializeProjectionColumnValSet(blockValSetMap);
    }

    private void initializeProjectionColumnValSet(Map<ExpressionContext, BlockValSet> blockValSetMap) {
        List<ExprMinMaxProjectionValSetWrapper> exprMinMaxWrapperProjectionColumnSets = this._exprMinMaxWrapperProjectionColumnSets.get();
        String[] projectionColNames = new String[this._projectionColumns.size()];
        DataSchema.ColumnDataType[] projectionColTypes = new DataSchema.ColumnDataType[this._projectionColumns.size()];
        block22: for (int i = 0; i < this._projectionColumns.size(); ++i) {
            projectionColNames[i] = this._projectionColumns.get(i).toString();
            ExpressionContext projectionColumn = this._projectionColumns.get(i);
            BlockValSet blockValSet = blockValSetMap.get(projectionColumn);
            if (blockValSet.isSingleValue()) {
                switch (blockValSet.getValueType()) {
                    case INT: {
                        exprMinMaxWrapperProjectionColumnSets.add(new ExprMinMaxProjectionValSetWrapper(true, DataSchema.ColumnDataType.INT, blockValSet));
                        projectionColTypes[i] = DataSchema.ColumnDataType.INT;
                        continue block22;
                    }
                    case BOOLEAN: {
                        exprMinMaxWrapperProjectionColumnSets.add(new ExprMinMaxProjectionValSetWrapper(true, DataSchema.ColumnDataType.BOOLEAN, blockValSet));
                        projectionColTypes[i] = DataSchema.ColumnDataType.INT;
                        continue block22;
                    }
                    case LONG: {
                        exprMinMaxWrapperProjectionColumnSets.add(new ExprMinMaxProjectionValSetWrapper(true, DataSchema.ColumnDataType.LONG, blockValSet));
                        projectionColTypes[i] = DataSchema.ColumnDataType.LONG;
                        continue block22;
                    }
                    case TIMESTAMP: {
                        exprMinMaxWrapperProjectionColumnSets.add(new ExprMinMaxProjectionValSetWrapper(true, DataSchema.ColumnDataType.TIMESTAMP, blockValSet));
                        projectionColTypes[i] = DataSchema.ColumnDataType.LONG;
                        continue block22;
                    }
                    case FLOAT: {
                        exprMinMaxWrapperProjectionColumnSets.add(new ExprMinMaxProjectionValSetWrapper(true, DataSchema.ColumnDataType.FLOAT, blockValSet));
                        projectionColTypes[i] = DataSchema.ColumnDataType.FLOAT;
                        continue block22;
                    }
                    case DOUBLE: {
                        exprMinMaxWrapperProjectionColumnSets.add(new ExprMinMaxProjectionValSetWrapper(true, DataSchema.ColumnDataType.DOUBLE, blockValSet));
                        projectionColTypes[i] = DataSchema.ColumnDataType.DOUBLE;
                        continue block22;
                    }
                    case STRING: {
                        exprMinMaxWrapperProjectionColumnSets.add(new ExprMinMaxProjectionValSetWrapper(true, DataSchema.ColumnDataType.STRING, blockValSet));
                        projectionColTypes[i] = DataSchema.ColumnDataType.STRING;
                        continue block22;
                    }
                    case JSON: {
                        exprMinMaxWrapperProjectionColumnSets.add(new ExprMinMaxProjectionValSetWrapper(true, DataSchema.ColumnDataType.JSON, blockValSet));
                        projectionColTypes[i] = DataSchema.ColumnDataType.STRING;
                        continue block22;
                    }
                    case BYTES: {
                        exprMinMaxWrapperProjectionColumnSets.add(new ExprMinMaxProjectionValSetWrapper(true, DataSchema.ColumnDataType.BYTES, blockValSet));
                        projectionColTypes[i] = DataSchema.ColumnDataType.BYTES;
                        continue block22;
                    }
                    case BIG_DECIMAL: {
                        exprMinMaxWrapperProjectionColumnSets.add(new ExprMinMaxProjectionValSetWrapper(true, DataSchema.ColumnDataType.BIG_DECIMAL, blockValSet));
                        projectionColTypes[i] = DataSchema.ColumnDataType.BIG_DECIMAL;
                        continue block22;
                    }
                    default: {
                        throw new IllegalStateException("Cannot compute exprminMax projection on non-comparable type: " + blockValSet.getValueType());
                    }
                }
            }
            switch (blockValSet.getValueType()) {
                case INT: {
                    exprMinMaxWrapperProjectionColumnSets.add(new ExprMinMaxProjectionValSetWrapper(false, DataSchema.ColumnDataType.INT_ARRAY, blockValSet));
                    projectionColTypes[i] = DataSchema.ColumnDataType.INT_ARRAY;
                    continue block22;
                }
                case BOOLEAN: {
                    exprMinMaxWrapperProjectionColumnSets.add(new ExprMinMaxProjectionValSetWrapper(false, DataSchema.ColumnDataType.BOOLEAN_ARRAY, blockValSet));
                    projectionColTypes[i] = DataSchema.ColumnDataType.INT_ARRAY;
                    continue block22;
                }
                case LONG: {
                    exprMinMaxWrapperProjectionColumnSets.add(new ExprMinMaxProjectionValSetWrapper(false, DataSchema.ColumnDataType.LONG_ARRAY, blockValSet));
                    projectionColTypes[i] = DataSchema.ColumnDataType.LONG_ARRAY;
                    continue block22;
                }
                case TIMESTAMP: {
                    exprMinMaxWrapperProjectionColumnSets.add(new ExprMinMaxProjectionValSetWrapper(false, DataSchema.ColumnDataType.TIMESTAMP_ARRAY, blockValSet));
                    projectionColTypes[i] = DataSchema.ColumnDataType.LONG_ARRAY;
                    continue block22;
                }
                case FLOAT: {
                    exprMinMaxWrapperProjectionColumnSets.add(new ExprMinMaxProjectionValSetWrapper(false, DataSchema.ColumnDataType.FLOAT_ARRAY, blockValSet));
                    projectionColTypes[i] = DataSchema.ColumnDataType.FLOAT_ARRAY;
                    continue block22;
                }
                case DOUBLE: {
                    exprMinMaxWrapperProjectionColumnSets.add(new ExprMinMaxProjectionValSetWrapper(false, DataSchema.ColumnDataType.DOUBLE_ARRAY, blockValSet));
                    projectionColTypes[i] = DataSchema.ColumnDataType.DOUBLE_ARRAY;
                    continue block22;
                }
                case STRING: {
                    exprMinMaxWrapperProjectionColumnSets.add(new ExprMinMaxProjectionValSetWrapper(false, DataSchema.ColumnDataType.STRING_ARRAY, blockValSet));
                    projectionColTypes[i] = DataSchema.ColumnDataType.STRING_ARRAY;
                    continue block22;
                }
                case BYTES: {
                    exprMinMaxWrapperProjectionColumnSets.add(new ExprMinMaxProjectionValSetWrapper(false, DataSchema.ColumnDataType.BYTES_ARRAY, blockValSet));
                    projectionColTypes[i] = DataSchema.ColumnDataType.BYTES_ARRAY;
                    continue block22;
                }
                default: {
                    throw new IllegalStateException("Cannot compute exprminMax projection on non-comparable type: " + blockValSet.getValueType());
                }
            }
        }
        this._projectionColumnSchema.set(new DataSchema(projectionColNames, projectionColTypes));
    }

    private void initializeMeasuringColumnValSet(Map<ExpressionContext, BlockValSet> blockValSetMap) {
        List<ExprMinMaxMeasuringValSetWrapper> exprMinMaxWrapperMeasuringColumnSets = this._exprMinMaxWrapperMeasuringColumnSets.get();
        String[] measuringColNames = new String[this._numMeasuringColumns];
        DataSchema.ColumnDataType[] measuringColTypes = new DataSchema.ColumnDataType[this._numMeasuringColumns];
        block10: for (int i = 0; i < this._numMeasuringColumns; ++i) {
            measuringColNames[i] = this._measuringColumns.get(i).toString();
            ExpressionContext measuringColumn = this._measuringColumns.get(i);
            BlockValSet blockValSet = blockValSetMap.get(measuringColumn);
            Preconditions.checkState((boolean)blockValSet.isSingleValue(), (Object)"ExprMinMax only supports single-valued measuring columns");
            switch (blockValSet.getValueType()) {
                case INT: {
                    exprMinMaxWrapperMeasuringColumnSets.add(new ExprMinMaxMeasuringValSetWrapper(true, DataSchema.ColumnDataType.INT, blockValSet));
                    measuringColTypes[i] = DataSchema.ColumnDataType.INT;
                    continue block10;
                }
                case BOOLEAN: {
                    exprMinMaxWrapperMeasuringColumnSets.add(new ExprMinMaxMeasuringValSetWrapper(true, DataSchema.ColumnDataType.BOOLEAN, blockValSet));
                    measuringColTypes[i] = DataSchema.ColumnDataType.INT;
                    continue block10;
                }
                case LONG: {
                    exprMinMaxWrapperMeasuringColumnSets.add(new ExprMinMaxMeasuringValSetWrapper(true, DataSchema.ColumnDataType.LONG, blockValSet));
                    measuringColTypes[i] = DataSchema.ColumnDataType.LONG;
                    continue block10;
                }
                case TIMESTAMP: {
                    exprMinMaxWrapperMeasuringColumnSets.add(new ExprMinMaxMeasuringValSetWrapper(true, DataSchema.ColumnDataType.TIMESTAMP, blockValSet));
                    measuringColTypes[i] = DataSchema.ColumnDataType.LONG;
                    continue block10;
                }
                case FLOAT: {
                    exprMinMaxWrapperMeasuringColumnSets.add(new ExprMinMaxMeasuringValSetWrapper(true, DataSchema.ColumnDataType.FLOAT, blockValSet));
                    measuringColTypes[i] = DataSchema.ColumnDataType.FLOAT;
                    continue block10;
                }
                case DOUBLE: {
                    exprMinMaxWrapperMeasuringColumnSets.add(new ExprMinMaxMeasuringValSetWrapper(true, DataSchema.ColumnDataType.DOUBLE, blockValSet));
                    measuringColTypes[i] = DataSchema.ColumnDataType.DOUBLE;
                    continue block10;
                }
                case STRING: {
                    exprMinMaxWrapperMeasuringColumnSets.add(new ExprMinMaxMeasuringValSetWrapper(true, DataSchema.ColumnDataType.STRING, blockValSet));
                    measuringColTypes[i] = DataSchema.ColumnDataType.STRING;
                    continue block10;
                }
                case BIG_DECIMAL: {
                    exprMinMaxWrapperMeasuringColumnSets.add(new ExprMinMaxMeasuringValSetWrapper(true, DataSchema.ColumnDataType.BIG_DECIMAL, blockValSet));
                    measuringColTypes[i] = DataSchema.ColumnDataType.BIG_DECIMAL;
                    continue block10;
                }
                default: {
                    throw new IllegalStateException("Cannot compute exprminMax measuring on non-comparable type: " + blockValSet.getValueType());
                }
            }
        }
        this._measuringColumnSchema.set(new DataSchema(measuringColNames, measuringColTypes));
    }

    private void initializeForEmptyDocSet() {
        if (this._schemaInitialized.get().booleanValue()) {
            return;
        }
        this._schemaInitialized.set(true);
        String[] measuringColNames = new String[this._numMeasuringColumns];
        DataSchema.ColumnDataType[] measuringColTypes = new DataSchema.ColumnDataType[this._numMeasuringColumns];
        for (int i = 0; i < this._numMeasuringColumns; ++i) {
            measuringColNames[i] = this._measuringColumns.get(i).toString();
            measuringColTypes[i] = DataSchema.ColumnDataType.STRING;
        }
        String[] projectionColNames = new String[this._numProjectionColumns];
        DataSchema.ColumnDataType[] projectionColTypes = new DataSchema.ColumnDataType[this._numProjectionColumns];
        for (int i = 0; i < this._numProjectionColumns; ++i) {
            projectionColNames[i] = this._projectionColumns.get(i).toString();
            projectionColTypes[i] = DataSchema.ColumnDataType.STRING;
        }
        this._measuringColumnSchema.set(new DataSchema(measuringColNames, measuringColTypes));
        this._projectionColumnSchema.set(new DataSchema(projectionColNames, projectionColTypes));
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        this.initializeWithNewDataBlocks(blockValSetMap);
        for (int i = 0; i < length; ++i) {
            int groupKey = groupKeyArray[i];
            this.updateGroupByResult(groupByResultHolder, i, groupKey);
        }
    }

    private void updateGroupByResult(GroupByResultHolder groupByResultHolder, int i, int groupKey) {
        int compareResult;
        ExprMinMaxObject exprMinMaxObject = (ExprMinMaxObject)groupByResultHolder.getResult(groupKey);
        if (exprMinMaxObject == null) {
            exprMinMaxObject = new ExprMinMaxObject(this._measuringColumnSchema.get(), this._projectionColumnSchema.get());
            groupByResultHolder.setValueForKey(groupKey, exprMinMaxObject);
        }
        if ((compareResult = exprMinMaxObject.compareAndSetKey(this._exprMinMaxWrapperMeasuringColumnSets.get(), i, this._isMax)) == 0) {
            exprMinMaxObject.addVal(this._exprMinMaxWrapperProjectionColumnSets.get(), i);
        } else if (compareResult > 0) {
            exprMinMaxObject.setToNewVal(this._exprMinMaxWrapperProjectionColumnSets.get(), i);
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        this.initializeWithNewDataBlocks(blockValSetMap);
        for (int i = 0; i < length; ++i) {
            for (int groupKey : groupKeysArray[i]) {
                this.updateGroupByResult(groupByResultHolder, i, groupKey);
            }
        }
    }

    @Override
    public ExprMinMaxObject extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        ExprMinMaxObject exprMinMaxObject = (ExprMinMaxObject)aggregationResultHolder.getResult();
        if (exprMinMaxObject == null) {
            this.initializeWithNewDataBlocks(null);
            return new ExprMinMaxObject(this._measuringColumnSchema.get(), this._projectionColumnSchema.get());
        }
        return exprMinMaxObject;
    }

    @Override
    public ExprMinMaxObject extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        return (ExprMinMaxObject)groupByResultHolder.getResult(groupKey);
    }

    @Override
    public ExprMinMaxObject merge(ExprMinMaxObject intermediateResult1, ExprMinMaxObject intermediateResult2) {
        return intermediateResult1.merge(intermediateResult2, this._isMax);
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public ExprMinMaxObject extractFinalResult(ExprMinMaxObject exprMinMaxObject) {
        return exprMinMaxObject;
    }
}

