/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.util.List;
import java.util.Map;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllSketch;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.PercentileKLLAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;

public class PercentileKLLMVAggregationFunction
extends PercentileKLLAggregationFunction {
    public PercentileKLLMVAggregationFunction(List<ExpressionContext> arguments) {
        super(arguments, false);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet valueSet = blockValSetMap.get(this._expression);
        FieldSpec.DataType valueType = valueSet.getValueType();
        KllDoublesSketch sketch = this.getOrCreateSketch(aggregationResultHolder);
        if (valueType == FieldSpec.DataType.BYTES) {
            KllDoublesSketch[] deserializedSketches = this.deserializeSketches(blockValSetMap.get(this._expression).getBytesValuesSV());
            for (int i = 0; i < length; ++i) {
                sketch.merge((KllSketch)deserializedSketches[i]);
            }
        } else {
            double[][] values = valueSet.getDoubleValuesMV();
            for (int i = 0; i < length; ++i) {
                for (double val : values[i]) {
                    sketch.update(val);
                }
            }
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet valueSet = blockValSetMap.get(this._expression);
        FieldSpec.DataType valueType = valueSet.getValueType();
        if (valueType == FieldSpec.DataType.BYTES) {
            KllDoublesSketch[] deserializedSketches = this.deserializeSketches(blockValSetMap.get(this._expression).getBytesValuesSV());
            for (int i = 0; i < length; ++i) {
                KllDoublesSketch sketch = this.getOrCreateSketch(groupByResultHolder, groupKeyArray[i]);
                sketch.merge((KllSketch)deserializedSketches[i]);
            }
        } else {
            double[][] values = valueSet.getDoubleValuesMV();
            for (int i = 0; i < length; ++i) {
                KllDoublesSketch sketch = this.getOrCreateSketch(groupByResultHolder, groupKeyArray[i]);
                for (double val : values[i]) {
                    sketch.update(val);
                }
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet valueSet = blockValSetMap.get(this._expression);
        FieldSpec.DataType valueType = valueSet.getValueType();
        if (valueType == FieldSpec.DataType.BYTES) {
            KllDoublesSketch[] deserializedSketches = this.deserializeSketches(blockValSetMap.get(this._expression).getBytesValuesSV());
            for (int i = 0; i < length; ++i) {
                for (int groupKey : groupKeysArray[i]) {
                    KllDoublesSketch sketch = this.getOrCreateSketch(groupByResultHolder, groupKey);
                    sketch.merge((KllSketch)deserializedSketches[i]);
                }
            }
        } else {
            double[][] values = valueSet.getDoubleValuesMV();
            for (int i = 0; i < length; ++i) {
                for (int groupKey : groupKeysArray[i]) {
                    KllDoublesSketch sketch = this.getOrCreateSketch(groupByResultHolder, groupKey);
                    for (double val : values[i]) {
                        sketch.update(val);
                    }
                }
            }
        }
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.PERCENTILEKLLMV;
    }

    @Override
    public String getResultColumnName() {
        return AggregationFunctionType.PERCENTILEKLLMV.getName().toLowerCase() + "(" + this._expression + ", " + this._percentile + ")";
    }
}

