/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import com.tdunning.math.stats.TDigest;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.NullableSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;

public class PercentileTDigestAggregationFunction
extends NullableSingleInputAggregationFunction<TDigest, Double> {
    public static final int DEFAULT_TDIGEST_COMPRESSION = 100;
    protected final int _version;
    protected final double _percentile;
    protected final int _compressionFactor;

    public PercentileTDigestAggregationFunction(ExpressionContext expression, int percentile, boolean nullHandlingEnabled) {
        super(expression, nullHandlingEnabled);
        this._version = 0;
        this._percentile = percentile;
        this._compressionFactor = 100;
    }

    public PercentileTDigestAggregationFunction(ExpressionContext expression, double percentile, boolean nullHandlingEnabled) {
        super(expression, nullHandlingEnabled);
        this._version = 1;
        this._percentile = percentile;
        this._compressionFactor = 100;
    }

    public PercentileTDigestAggregationFunction(ExpressionContext expression, double percentile, int compressionFactor, boolean nullHandlingEnabled) {
        super(expression, nullHandlingEnabled);
        this._version = 1;
        this._percentile = percentile;
        this._compressionFactor = compressionFactor;
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.PERCENTILETDIGEST;
    }

    @Override
    public String getResultColumnName() {
        return this._version == 0 ? AggregationFunctionType.PERCENTILETDIGEST.getName().toLowerCase() + (int)this._percentile + "(" + this._expression + ")" : (this._compressionFactor == 100 ? AggregationFunctionType.PERCENTILETDIGEST.getName().toLowerCase() + "(" + this._expression + ", " + this._percentile + ")" : AggregationFunctionType.PERCENTILETDIGEST.getName().toLowerCase() + "(" + this._expression + ", " + this._percentile + ", " + this._compressionFactor + ")");
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        if (blockValSet.getValueType() != FieldSpec.DataType.BYTES) {
            double[] doubleValues = blockValSet.getDoubleValuesSV();
            TDigest tDigest2 = PercentileTDigestAggregationFunction.getDefaultTDigest(aggregationResultHolder, this._compressionFactor);
            this.forEachNotNull(length, blockValSet, (int from, int to) -> {
                for (int i = from; i < to; ++i) {
                    tDigest2.add(doubleValues[i]);
                }
            });
        } else {
            byte[][] bytesValues = blockValSet.getBytesValuesSV();
            this.foldNotNull(length, blockValSet, (TDigest)aggregationResultHolder.getResult(), (A tDigest, int from, int toEx) -> {
                if (tDigest != null) {
                    for (int i = from; i < toEx; ++i) {
                        tDigest.add(ObjectSerDeUtils.TDIGEST_SER_DE.deserialize(bytesValues[i]));
                    }
                } else {
                    tDigest = ObjectSerDeUtils.TDIGEST_SER_DE.deserialize(bytesValues[0]);
                    aggregationResultHolder.setValue(tDigest);
                    for (int i = 1; i < length; ++i) {
                        tDigest.add(ObjectSerDeUtils.TDIGEST_SER_DE.deserialize(bytesValues[i]));
                    }
                }
                return tDigest;
            });
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        if (blockValSet.getValueType() != FieldSpec.DataType.BYTES) {
            double[] doubleValues = blockValSet.getDoubleValuesSV();
            this.forEachNotNull(length, blockValSet, (int from, int to) -> {
                for (int i = from; i < to; ++i) {
                    PercentileTDigestAggregationFunction.getDefaultTDigest(groupByResultHolder, groupKeyArray[i], this._compressionFactor).add(doubleValues[i]);
                }
            });
        } else {
            byte[][] bytesValues = blockValSet.getBytesValuesSV();
            this.forEachNotNull(length, blockValSet, (int from, int to) -> {
                for (int i = from; i < to; ++i) {
                    TDigest value = ObjectSerDeUtils.TDIGEST_SER_DE.deserialize(bytesValues[i]);
                    int groupKey = groupKeyArray[i];
                    TDigest tDigest = (TDigest)groupByResultHolder.getResult(groupKey);
                    if (tDigest != null) {
                        tDigest.add(value);
                        continue;
                    }
                    groupByResultHolder.setValueForKey(groupKey, value);
                }
            });
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        if (blockValSet.getValueType() != FieldSpec.DataType.BYTES) {
            double[] doubleValues = blockValSet.getDoubleValuesSV();
            this.forEachNotNull(length, blockValSet, (int from, int to) -> {
                for (int i = from; i < to; ++i) {
                    double value = doubleValues[i];
                    for (int groupKey : groupKeysArray[i]) {
                        PercentileTDigestAggregationFunction.getDefaultTDigest(groupByResultHolder, groupKey, this._compressionFactor).add(value);
                    }
                }
            });
        } else {
            byte[][] bytesValues = blockValSet.getBytesValuesSV();
            this.forEachNotNull(length, blockValSet, (int from, int to) -> {
                for (int i = from; i < to; ++i) {
                    TDigest value = ObjectSerDeUtils.TDIGEST_SER_DE.deserialize(bytesValues[i]);
                    for (int groupKey : groupKeysArray[i]) {
                        TDigest tDigest = (TDigest)groupByResultHolder.getResult(groupKey);
                        if (tDigest != null) {
                            tDigest.add(value);
                            continue;
                        }
                        groupByResultHolder.setValueForKey(groupKey, ObjectSerDeUtils.TDIGEST_SER_DE.deserialize(bytesValues[i]));
                    }
                }
            });
        }
    }

    @Override
    public TDigest extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        TDigest tDigest = (TDigest)aggregationResultHolder.getResult();
        if (tDigest == null) {
            return TDigest.createMergingDigest((double)this._compressionFactor);
        }
        return tDigest;
    }

    @Override
    public TDigest extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        TDigest tDigest = (TDigest)groupByResultHolder.getResult(groupKey);
        if (tDigest == null) {
            return TDigest.createMergingDigest((double)this._compressionFactor);
        }
        return tDigest;
    }

    @Override
    public TDigest merge(TDigest intermediateResult1, TDigest intermediateResult2) {
        if (intermediateResult1.size() == 0L) {
            return intermediateResult2;
        }
        if (intermediateResult2.size() == 0L) {
            return intermediateResult1;
        }
        intermediateResult1.add(intermediateResult2);
        return intermediateResult1;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.DOUBLE;
    }

    @Override
    public Double extractFinalResult(TDigest intermediateResult) {
        return intermediateResult.quantile(this._percentile / 100.0);
    }

    @Override
    public boolean canUseStarTree(Map<String, Object> functionParameters) {
        Object compressionFactor = functionParameters.get("compressionFactor");
        if (compressionFactor != null) {
            return this._compressionFactor == Integer.parseInt(String.valueOf(compressionFactor));
        }
        return this._compressionFactor == 100;
    }

    protected static TDigest getDefaultTDigest(AggregationResultHolder aggregationResultHolder, int compressionFactor) {
        TDigest tDigest = (TDigest)aggregationResultHolder.getResult();
        if (tDigest == null) {
            tDigest = TDigest.createMergingDigest((double)compressionFactor);
            aggregationResultHolder.setValue(tDigest);
        }
        return tDigest;
    }

    protected static TDigest getDefaultTDigest(GroupByResultHolder groupByResultHolder, int groupKey, int compressionFactor) {
        TDigest tDigest = (TDigest)groupByResultHolder.getResult(groupKey);
        if (tDigest == null) {
            tDigest = TDigest.createMergingDigest((double)compressionFactor);
            groupByResultHolder.setValueForKey(groupKey, tDigest);
        }
        return tDigest;
    }
}

