/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.DoubleAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.NullableSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.DoubleGroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;

public class SumAggregationFunction
extends NullableSingleInputAggregationFunction<Double, Double> {
    private static final double DEFAULT_VALUE = 0.0;

    public SumAggregationFunction(List<ExpressionContext> arguments, boolean nullHandlingEnabled) {
        this(SumAggregationFunction.verifySingleArgument(arguments, "SUM"), nullHandlingEnabled);
    }

    protected SumAggregationFunction(ExpressionContext expression, boolean nullHandlingEnabled) {
        super(expression, nullHandlingEnabled);
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.SUM;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        if (this._nullHandlingEnabled) {
            return new ObjectAggregationResultHolder();
        }
        return new DoubleAggregationResultHolder(0.0);
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        if (this._nullHandlingEnabled) {
            return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
        }
        return new DoubleGroupByResultHolder(initialCapacity, maxCapacity, 0.0);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        Double sum;
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        switch (blockValSet.getValueType().getStoredType()) {
            case INT: {
                int[] values = blockValSet.getIntValuesSV();
                sum = this.foldNotNull(length, blockValSet, null, (A acum, int from, int to) -> {
                    double innerSum = 0.0;
                    for (int i = from; i < to; ++i) {
                        innerSum += (double)values[i];
                    }
                    return acum == null ? innerSum : acum + innerSum;
                });
                break;
            }
            case LONG: {
                long[] values = blockValSet.getLongValuesSV();
                sum = this.foldNotNull(length, blockValSet, null, (A acum, int from, int to) -> {
                    double innerSum = 0.0;
                    for (int i = from; i < to; ++i) {
                        innerSum += (double)values[i];
                    }
                    return acum == null ? innerSum : acum + innerSum;
                });
                break;
            }
            case FLOAT: {
                float[] values = blockValSet.getFloatValuesSV();
                sum = this.foldNotNull(length, blockValSet, null, (A acum, int from, int to) -> {
                    double innerSum = 0.0;
                    for (int i = from; i < to; ++i) {
                        innerSum += (double)values[i];
                    }
                    return acum == null ? innerSum : acum + innerSum;
                });
                break;
            }
            case DOUBLE: {
                double[] values = blockValSet.getDoubleValuesSV();
                sum = this.foldNotNull(length, blockValSet, null, (A acum, int from, int to) -> {
                    double innerSum = 0.0;
                    for (int i = from; i < to; ++i) {
                        innerSum += values[i];
                    }
                    return acum == null ? innerSum : acum + innerSum;
                });
                break;
            }
            case BIG_DECIMAL: {
                BigDecimal[] values = blockValSet.getBigDecimalValuesSV();
                BigDecimal decimalSum = this.foldNotNull(length, blockValSet, null, (A acum, int from, int to) -> {
                    BigDecimal innerSum = BigDecimal.ZERO;
                    for (int i = from; i < to; ++i) {
                        innerSum = innerSum.add(values[i]);
                    }
                    return acum == null ? innerSum : acum.add(innerSum);
                });
                sum = decimalSum == null ? null : Double.valueOf(decimalSum.doubleValue());
                break;
            }
            default: {
                throw new IllegalStateException("Cannot compute sum for non-numeric type: " + blockValSet.getValueType());
            }
        }
        this.updateAggregationResultHolder(aggregationResultHolder, sum);
    }

    private void updateAggregationResultHolder(AggregationResultHolder aggregationResultHolder, Double sum) {
        if (sum != null) {
            if (this._nullHandlingEnabled) {
                Double otherSum = (Double)aggregationResultHolder.getResult();
                aggregationResultHolder.setValue(otherSum == null ? sum : sum + otherSum);
            } else {
                double otherSum = aggregationResultHolder.getDoubleResult();
                aggregationResultHolder.setValue(sum + otherSum);
            }
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        double[] valueArray = blockValSet.getDoubleValuesSV();
        if (this._nullHandlingEnabled) {
            this.forEachNotNull(length, blockValSet, (int from, int to) -> {
                for (int i = from; i < to; ++i) {
                    int groupKey;
                    Double result = (Double)groupByResultHolder.getResult(groupKey = groupKeyArray[i]);
                    groupByResultHolder.setValueForKey(groupKey, result == null ? valueArray[i] : result + valueArray[i]);
                }
            });
        } else {
            for (int i = 0; i < length; ++i) {
                int groupKey = groupKeyArray[i];
                groupByResultHolder.setValueForKey(groupKey, groupByResultHolder.getDoubleResult(groupKey) + valueArray[i]);
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        double[] valueArray = blockValSet.getDoubleValuesSV();
        if (this._nullHandlingEnabled) {
            this.forEachNotNull(length, blockValSet, (int from, int to) -> {
                for (int i = from; i < to; ++i) {
                    int[] nArray = groupKeysArray[i];
                    int n = nArray.length;
                    for (int j = 0; j < n; ++j) {
                        int groupKey;
                        Double result = (Double)groupByResultHolder.getResult(groupKey = nArray[j]);
                        groupByResultHolder.setValueForKey(groupKey, result == null ? valueArray[i] : result + valueArray[i]);
                    }
                }
            });
        } else {
            for (int i = 0; i < length; ++i) {
                double value = valueArray[i];
                for (int groupKey : groupKeysArray[i]) {
                    groupByResultHolder.setValueForKey(groupKey, groupByResultHolder.getDoubleResult(groupKey) + value);
                }
            }
        }
    }

    @Override
    public Double extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        if (this._nullHandlingEnabled) {
            return (Double)aggregationResultHolder.getResult();
        }
        return aggregationResultHolder.getDoubleResult();
    }

    @Override
    public Double extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        if (this._nullHandlingEnabled) {
            return (Double)groupByResultHolder.getResult(groupKey);
        }
        return groupByResultHolder.getDoubleResult(groupKey);
    }

    @Override
    public Double merge(Double intermediateResult1, Double intermediateResult2) {
        if (this._nullHandlingEnabled) {
            if (intermediateResult1 == null) {
                return intermediateResult2;
            }
            if (intermediateResult2 == null) {
                return intermediateResult1;
            }
        }
        return intermediateResult1 + intermediateResult2;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.DOUBLE;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.DOUBLE;
    }

    @Override
    public Double extractFinalResult(Double intermediateResult) {
        return intermediateResult;
    }

    @Override
    public Double mergeFinalResult(Double finalResult1, Double finalResult2) {
        return this.merge(finalResult1, finalResult2);
    }
}

