/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.util.List;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.NullableSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.core.query.aggregation.utils.StatisticalAggregationFunctionUtils;
import org.apache.pinot.segment.local.customobject.VarianceTuple;
import org.apache.pinot.segment.spi.AggregationFunctionType;

public class VarianceAggregationFunction
extends NullableSingleInputAggregationFunction<VarianceTuple, Double> {
    private static final double DEFAULT_FINAL_RESULT = Double.NEGATIVE_INFINITY;
    protected final boolean _isSample;
    protected final boolean _isStdDev;

    public VarianceAggregationFunction(List<ExpressionContext> arguments, boolean isSample, boolean isStdDev, boolean nullHandlingEnabled) {
        super(VarianceAggregationFunction.verifySingleArgument(arguments, VarianceAggregationFunction.getFunctionName(isSample, isStdDev)), nullHandlingEnabled);
        this._isSample = isSample;
        this._isStdDev = isStdDev;
    }

    private static String getFunctionName(boolean isSample, boolean isStdDev) {
        return isSample ? (isStdDev ? "STD_DEV_SAMP" : "VAR_SAMP") : (isStdDev ? "STD_DEV_POP" : "VAR_POP");
    }

    @Override
    public AggregationFunctionType getType() {
        if (this._isSample) {
            return this._isStdDev ? AggregationFunctionType.STDDEVSAMP : AggregationFunctionType.VARSAMP;
        }
        return this._isStdDev ? AggregationFunctionType.STDDEVPOP : AggregationFunctionType.VARPOP;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[] values = StatisticalAggregationFunctionUtils.getValSet(blockValSetMap, this._expression);
        VarianceTuple varianceTuple = new VarianceTuple(0L, 0.0, 0.0);
        this.forEachNotNull(length, blockValSetMap.get(this._expression), (int from, int to) -> {
            for (int i = from; i < to; ++i) {
                varianceTuple.apply(values[i]);
            }
        });
        if (this._nullHandlingEnabled && varianceTuple.getCount() == 0L) {
            return;
        }
        this.setAggregationResult(aggregationResultHolder, varianceTuple.getCount(), varianceTuple.getSum(), varianceTuple.getM2());
    }

    protected void setAggregationResult(AggregationResultHolder aggregationResultHolder, long count, double sum, double m2) {
        VarianceTuple varianceTuple = (VarianceTuple)aggregationResultHolder.getResult();
        if (varianceTuple == null) {
            aggregationResultHolder.setValue(new VarianceTuple(count, sum, m2));
        } else {
            varianceTuple.apply(count, sum, m2);
        }
    }

    protected void setGroupByResult(int groupKey, GroupByResultHolder groupByResultHolder, long count, double sum, double m2) {
        VarianceTuple varianceTuple = (VarianceTuple)groupByResultHolder.getResult(groupKey);
        if (varianceTuple == null) {
            groupByResultHolder.setValueForKey(groupKey, new VarianceTuple(count, sum, m2));
        } else {
            varianceTuple.apply(count, sum, m2);
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[] values = StatisticalAggregationFunctionUtils.getValSet(blockValSetMap, this._expression);
        this.forEachNotNull(length, blockValSetMap.get(this._expression), (int from, int to) -> {
            for (int i = from; i < to; ++i) {
                this.setGroupByResult(groupKeyArray[i], groupByResultHolder, 1L, values[i], 0.0);
            }
        });
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[] values = StatisticalAggregationFunctionUtils.getValSet(blockValSetMap, this._expression);
        this.forEachNotNull(length, blockValSetMap.get(this._expression), (int from, int to) -> {
            for (int i = from; i < to; ++i) {
                for (int groupKey : groupKeysArray[i]) {
                    this.setGroupByResult(groupKey, groupByResultHolder, 1L, values[i], 0.0);
                }
            }
        });
    }

    @Override
    public VarianceTuple extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        VarianceTuple varianceTuple = (VarianceTuple)aggregationResultHolder.getResult();
        if (varianceTuple == null) {
            return this._nullHandlingEnabled ? null : new VarianceTuple(0L, 0.0, 0.0);
        }
        return varianceTuple;
    }

    @Override
    public VarianceTuple extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        return (VarianceTuple)groupByResultHolder.getResult(groupKey);
    }

    @Override
    public VarianceTuple merge(VarianceTuple intermediateResult1, VarianceTuple intermediateResult2) {
        if (this._nullHandlingEnabled) {
            if (intermediateResult1 == null) {
                return intermediateResult2;
            }
            if (intermediateResult2 == null) {
                return intermediateResult1;
            }
        }
        intermediateResult1.apply(intermediateResult2);
        return intermediateResult1;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.DOUBLE;
    }

    @Override
    public Double extractFinalResult(VarianceTuple varianceTuple) {
        if (varianceTuple == null) {
            return null;
        }
        long count = varianceTuple.getCount();
        if (count == 0L) {
            return Double.NEGATIVE_INFINITY;
        }
        double variance = varianceTuple.getM2();
        if (this._isSample) {
            if (count - 1L == 0L) {
                return Double.NEGATIVE_INFINITY;
            }
            double sampleVar = variance / (double)(count - 1L);
            return this._isStdDev ? Math.sqrt(sampleVar) : sampleVar;
        }
        double popVar = variance / (double)count;
        return this._isStdDev ? Math.sqrt(popVar) : popVar;
    }
}

