/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.array;

import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.array.BaseArrayAggDoubleFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;

public class ArrayAggDistinctDoubleFunction
extends BaseArrayAggDoubleFunction<DoubleOpenHashSet> {
    public ArrayAggDistinctDoubleFunction(ExpressionContext expression, boolean nullHandlingEnabled) {
        super(expression, nullHandlingEnabled);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        double[] value = blockValSet.getDoubleValuesSV();
        DoubleOpenHashSet valueArray = new DoubleOpenHashSet(length);
        this.forEachNotNull(length, blockValSet, (int from, int to) -> {
            for (int i = from; i < to; ++i) {
                valueArray.add(value[i]);
            }
        });
        aggregationResultHolder.setValue(valueArray);
    }

    @Override
    protected void setGroupByResult(GroupByResultHolder resultHolder, int groupKey, double value) {
        DoubleOpenHashSet valueSet = (DoubleOpenHashSet)resultHolder.getResult(groupKey);
        if (valueSet == null) {
            valueSet = new DoubleOpenHashSet();
            resultHolder.setValueForKey(groupKey, valueSet);
        }
        valueSet.add(value);
    }
}

