/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.array;

import it.unimi.dsi.fastutil.floats.FloatOpenHashSet;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.array.BaseArrayAggFloatFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;

public class ArrayAggDistinctFloatFunction
extends BaseArrayAggFloatFunction<FloatOpenHashSet> {
    public ArrayAggDistinctFloatFunction(ExpressionContext expression, boolean nullHandlingEnabled) {
        super(expression, nullHandlingEnabled);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        float[] value = blockValSet.getFloatValuesSV();
        FloatOpenHashSet valueArray = new FloatOpenHashSet(length);
        this.forEachNotNull(length, blockValSet, (int from, int to) -> {
            for (int i = from; i < to; ++i) {
                valueArray.add(value[i]);
            }
        });
        aggregationResultHolder.setValue(valueArray);
    }

    @Override
    protected void setGroupByResult(GroupByResultHolder resultHolder, int groupKey, float value) {
        FloatOpenHashSet valueSet = (FloatOpenHashSet)resultHolder.getResult(groupKey);
        if (valueSet == null) {
            valueSet = new FloatOpenHashSet();
            resultHolder.setValueForKey(groupKey, valueSet);
        }
        valueSet.add(value);
    }
}

