/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.array;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.array.BaseArrayAggStringFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;

public class ArrayAggDistinctStringFunction
extends BaseArrayAggStringFunction<ObjectOpenHashSet<String>> {
    public ArrayAggDistinctStringFunction(ExpressionContext expression, boolean nullHandlingEnabled) {
        super(expression, nullHandlingEnabled);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        String[] value = blockValSet.getStringValuesSV();
        ObjectOpenHashSet valueArray = new ObjectOpenHashSet(length);
        this.forEachNotNull(length, blockValSet, (int from, int to) -> valueArray.addAll(Arrays.asList(value).subList(from, to)));
        aggregationResultHolder.setValue(valueArray);
    }

    @Override
    protected void setGroupByResult(GroupByResultHolder resultHolder, int groupKey, String value) {
        ObjectOpenHashSet valueSet = (ObjectOpenHashSet)resultHolder.getResult(groupKey);
        if (valueSet == null) {
            valueSet = new ObjectOpenHashSet();
            resultHolder.setValueForKey(groupKey, valueSet);
        }
        valueSet.add((Object)value);
    }
}

