/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.array;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.array.BaseArrayAggDoubleFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;

public class ArrayAggDoubleFunction
extends BaseArrayAggDoubleFunction<DoubleArrayList> {
    public ArrayAggDoubleFunction(ExpressionContext expression, boolean nullHandlingEnabled) {
        super(expression, nullHandlingEnabled);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        double[] value = blockValSet.getDoubleValuesSV();
        DoubleArrayList valueArray = new DoubleArrayList(length);
        this.forEachNotNull(length, blockValSet, (int from, int to) -> {
            for (int i = from; i < to; ++i) {
                valueArray.add(value[i]);
            }
        });
        aggregationResultHolder.setValue(valueArray);
    }

    @Override
    protected void setGroupByResult(GroupByResultHolder resultHolder, int groupKey, double value) {
        DoubleArrayList valueArray = (DoubleArrayList)resultHolder.getResult(groupKey);
        if (valueArray == null) {
            valueArray = new DoubleArrayList();
            resultHolder.setValueForKey(groupKey, valueArray);
        }
        valueArray.add(value);
    }
}

