/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.array;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.array.BaseArrayAggIntFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.spi.data.FieldSpec;

public class ArrayAggIntFunction
extends BaseArrayAggIntFunction<IntArrayList> {
    public ArrayAggIntFunction(ExpressionContext expression, FieldSpec.DataType dataType, boolean nullHandlingEnabled) {
        super(expression, dataType, nullHandlingEnabled);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        int[] value = blockValSet.getIntValuesSV();
        IntArrayList valueArray = new IntArrayList(length);
        this.forEachNotNull(length, blockValSet, (int from, int to) -> {
            for (int i = from; i < to; ++i) {
                valueArray.add(value[i]);
            }
        });
        aggregationResultHolder.setValue(valueArray);
    }

    @Override
    protected void setGroupByResult(GroupByResultHolder resultHolder, int groupKey, int value) {
        IntArrayList valueArray = (IntArrayList)resultHolder.getResult(groupKey);
        if (valueArray == null) {
            valueArray = new IntArrayList();
            resultHolder.setValueForKey(groupKey, valueArray);
        }
        valueArray.add(value);
    }
}

