/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.array;

import it.unimi.dsi.fastutil.doubles.AbstractDoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.function.array.BaseArrayAggFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.spi.data.FieldSpec;

public abstract class BaseArrayAggDoubleFunction<I extends AbstractDoubleCollection>
extends BaseArrayAggFunction<I, DoubleArrayList> {
    public BaseArrayAggDoubleFunction(ExpressionContext expression, boolean nullHandlingEnabled) {
        super(expression, FieldSpec.DataType.DOUBLE, nullHandlingEnabled);
    }

    abstract void setGroupByResult(GroupByResultHolder var1, int var2, double var3);

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        double[] values = blockValSet.getDoubleValuesSV();
        this.forEachNotNull(length, blockValSet, (int from, int to) -> {
            for (int i = from; i < to; ++i) {
                this.setGroupByResult(groupByResultHolder, groupKeyArray[i], values[i]);
            }
        });
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        double[] values = blockValSet.getDoubleValuesSV();
        this.forEachNotNull(length, blockValSet, (int from, int to) -> {
            for (int i = from; i < to; ++i) {
                int[] groupKeys;
                for (int groupKey : groupKeys = groupKeysArray[i]) {
                    this.setGroupByResult(groupByResultHolder, groupKey, values[i]);
                }
            }
        });
    }

    @Override
    public I merge(I intermediateResult1, I intermediateResult2) {
        if (intermediateResult1 == null) {
            return intermediateResult2;
        }
        if (intermediateResult2 == null) {
            return intermediateResult1;
        }
        intermediateResult1.addAll(intermediateResult2);
        return intermediateResult1;
    }

    @Override
    public DoubleArrayList extractFinalResult(I doubleArrayList) {
        if (doubleArrayList == null) {
            return new DoubleArrayList();
        }
        return new DoubleArrayList(doubleArrayList);
    }
}

