/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.array;

import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.NullableSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;

public abstract class BaseArrayAggFunction<I, F extends Comparable>
extends NullableSingleInputAggregationFunction<I, F> {
    private final DataSchema.ColumnDataType _resultColumnType;

    public BaseArrayAggFunction(ExpressionContext expression, FieldSpec.DataType dataType, boolean nullHandlingEnabled) {
        super(expression, nullHandlingEnabled);
        this._resultColumnType = DataSchema.ColumnDataType.fromDataTypeMV((FieldSpec.DataType)dataType);
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.ARRAYAGG;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return this._resultColumnType;
    }

    @Override
    public I extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        return (I)aggregationResultHolder.getResult();
    }

    @Override
    public I extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        return (I)groupByResultHolder.getResult(groupKey);
    }
}

