/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.array;

import it.unimi.dsi.fastutil.objects.AbstractObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import java.util.Iterator;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.function.array.BaseArrayAggFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.spi.data.FieldSpec;

public abstract class BaseArrayAggStringFunction<I extends AbstractObjectCollection<String>>
extends BaseArrayAggFunction<I, ObjectArrayList<String>> {
    public BaseArrayAggStringFunction(ExpressionContext expression, boolean nullHandlingEnabled) {
        super(expression, FieldSpec.DataType.STRING, nullHandlingEnabled);
    }

    abstract void setGroupByResult(GroupByResultHolder var1, int var2, String var3);

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        String[] values = blockValSet.getStringValuesSV();
        this.forEachNotNull(length, blockValSet, (int from, int to) -> {
            for (int i = from; i < to; ++i) {
                this.setGroupByResult(groupByResultHolder, groupKeyArray[i], values[i]);
            }
        });
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        String[] values = blockValSet.getStringValuesSV();
        this.forEachNotNull(length, blockValSet, (int from, int to) -> {
            for (int i = from; i < to; ++i) {
                int[] groupKeys;
                for (int groupKey : groupKeys = groupKeysArray[i]) {
                    this.setGroupByResult(groupByResultHolder, groupKey, values[i]);
                }
            }
        });
    }

    @Override
    public I merge(I intermediateResult1, I intermediateResult2) {
        if (intermediateResult1 == null) {
            return intermediateResult2;
        }
        if (intermediateResult2 == null) {
            return intermediateResult1;
        }
        intermediateResult1.addAll(intermediateResult2);
        return intermediateResult1;
    }

    @Override
    public ObjectArrayList<String> extractFinalResult(I stringArrayList) {
        if (stringArrayList == null) {
            return new ObjectArrayList();
        }
        Object[] stringArray = new String[stringArrayList.size()];
        ObjectIterators.unwrap((Iterator)stringArrayList.iterator(), (Object[])stringArray);
        return ObjectArrayList.wrap((Object[])stringArray);
    }
}

