/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.array;

import it.unimi.dsi.fastutil.objects.AbstractObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.NullableSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;

public class ListAggFunction
extends NullableSingleInputAggregationFunction<AbstractObjectCollection<String>, String> {
    private final String _separator;

    public ListAggFunction(ExpressionContext expression, String separator, boolean nullHandlingEnabled) {
        super(expression, nullHandlingEnabled);
        this._separator = separator;
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.LISTAGG;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        AbstractObjectCollection<String> valueSet = this.getObjectCollection(aggregationResultHolder);
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        String[] values = blockValSet.getStringValuesSV();
        this.forEachNotNull(length, blockValSet, (int from, int to) -> valueSet.addAll(Arrays.asList(values).subList(from, to)));
    }

    protected AbstractObjectCollection<String> getObjectCollection(AggregationResultHolder aggregationResultHolder) {
        ObjectArrayList valueSet = (ObjectArrayList)aggregationResultHolder.getResult();
        if (valueSet == null) {
            valueSet = new ObjectArrayList();
            aggregationResultHolder.setValue(valueSet);
        }
        return valueSet;
    }

    protected AbstractObjectCollection<String> getObjectCollection(GroupByResultHolder groupByResultHolder, int groupKey) {
        ObjectArrayList valueSet = (ObjectArrayList)groupByResultHolder.getResult(groupKey);
        if (valueSet == null) {
            valueSet = new ObjectArrayList();
            groupByResultHolder.setValueForKey(groupKey, valueSet);
        }
        return valueSet;
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        String[] values = blockValSet.getStringValuesSV();
        this.forEachNotNull(length, blockValSet, (int from, int to) -> {
            for (int i = from; i < to; ++i) {
                AbstractObjectCollection<String> groupValueList = this.getObjectCollection(groupByResultHolder, groupKeyArray[i]);
                groupValueList.add((Object)values[i]);
            }
        });
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        String[] values = blockValSet.getStringValuesSV();
        this.forEachNotNull(length, blockValSet, (int from, int to) -> {
            for (int i = from; i < to; ++i) {
                for (int groupKey : groupKeysArray[i]) {
                    AbstractObjectCollection<String> groupValueList = this.getObjectCollection(groupByResultHolder, groupKey);
                    groupValueList.add((Object)values[i]);
                }
            }
        });
    }

    @Override
    public AbstractObjectCollection<String> extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        return (AbstractObjectCollection)aggregationResultHolder.getResult();
    }

    @Override
    public AbstractObjectCollection<String> extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        return (AbstractObjectCollection)groupByResultHolder.getResult(groupKey);
    }

    @Override
    public AbstractObjectCollection<String> merge(AbstractObjectCollection<String> intermediateResult1, AbstractObjectCollection<String> intermediateResult2) {
        if (intermediateResult1 == null) {
            return intermediateResult2;
        }
        if (intermediateResult2 == null) {
            return intermediateResult1;
        }
        intermediateResult1.addAll(intermediateResult2);
        return intermediateResult1;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.STRING;
    }

    @Override
    public String extractFinalResult(AbstractObjectCollection<String> strings) {
        if (strings == null) {
            return null;
        }
        return StringUtils.join(strings, (String)this._separator);
    }
}

