/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.array;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;

public class SumArrayLongAggregationFunction
extends BaseSingleInputAggregationFunction<LongArrayList, LongArrayList> {
    public SumArrayLongAggregationFunction(List<ExpressionContext> arguments) {
        super(SumArrayLongAggregationFunction.verifySingleArgument(arguments, "SUM_ARRAY"));
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.SUMARRAYLONG;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        long[][] values = blockValSetMap.get(this._expression).getLongValuesMV();
        if (aggregationResultHolder.getResult() == null) {
            aggregationResultHolder.setValue(new LongArrayList());
        }
        LongArrayList result = (LongArrayList)aggregationResultHolder.getResult();
        for (int i = 0; i < length; ++i) {
            long[] value = values[i];
            this.aggregateMerge(value, result);
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        long[][] valuesArray = blockValSetMap.get(this._expression).getLongValuesMV();
        for (int i = 0; i < length; ++i) {
            long[] values = valuesArray[i];
            int groupKey = groupKeyArray[i];
            this.setGroupByResult(groupByResultHolder, values, groupKey);
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        long[][] valuesArray = blockValSetMap.get(this._expression).getLongValuesMV();
        for (int i = 0; i < length; ++i) {
            int[] groupKeys;
            long[] values = valuesArray[i];
            for (int groupKey : groupKeys = groupKeysArray[i]) {
                this.setGroupByResult(groupByResultHolder, values, groupKey);
            }
        }
    }

    private void setGroupByResult(GroupByResultHolder groupByResultHolder, long[] values, int groupKey) {
        LongArrayList sumList = (LongArrayList)groupByResultHolder.getResult(groupKey);
        if (sumList == null) {
            sumList = new LongArrayList();
            groupByResultHolder.setValueForKey(groupKey, sumList);
        }
        this.aggregateMerge(values, sumList);
    }

    private void aggregateMerge(long[] values, LongArrayList sumList) {
        int j;
        for (j = sumList.size(); j < values.length; ++j) {
            sumList.add(0L);
        }
        for (j = 0; j < values.length; ++j) {
            sumList.set(j, sumList.getLong(j) + values[j]);
        }
    }

    @Override
    public LongArrayList extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        return (LongArrayList)aggregationResultHolder.getResult();
    }

    @Override
    public LongArrayList extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        return (LongArrayList)groupByResultHolder.getResult(groupKey);
    }

    @Override
    public LongArrayList merge(LongArrayList intermediateResult1, LongArrayList intermediateResult2) {
        if (intermediateResult1.size() < intermediateResult2.size()) {
            for (int i = 0; i < intermediateResult1.size(); ++i) {
                intermediateResult2.set(i, intermediateResult1.getLong(i) + intermediateResult2.getLong(i));
            }
            return intermediateResult2;
        }
        for (int i = 0; i < intermediateResult2.size(); ++i) {
            intermediateResult1.set(i, intermediateResult1.getLong(i) + intermediateResult2.getLong(i));
        }
        return intermediateResult1;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.LONG_ARRAY;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.LONG_ARRAY;
    }

    @Override
    public LongArrayList extractFinalResult(LongArrayList result) {
        return result;
    }
}

