/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.funnel;

import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.core.query.aggregation.function.funnel.DictIdsWrapper;
import org.apache.pinot.core.query.aggregation.function.funnel.ResultExtractionStrategy;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.RoaringBitmap;

class BitmapResultExtractionStrategy
implements ResultExtractionStrategy<DictIdsWrapper, List<RoaringBitmap>> {
    protected final int _numSteps;

    BitmapResultExtractionStrategy(int numSteps) {
        this._numSteps = numSteps;
    }

    @Override
    public List<RoaringBitmap> extractIntermediateResult(DictIdsWrapper dictIdsWrapper) {
        Dictionary dictionary = dictIdsWrapper._dictionary;
        ArrayList<RoaringBitmap> result = new ArrayList<RoaringBitmap>(this._numSteps);
        for (RoaringBitmap dictIdBitmap : dictIdsWrapper._stepsBitmaps) {
            result.add(this.convertToValueBitmap(dictionary, dictIdBitmap));
        }
        return result;
    }

    private RoaringBitmap convertToValueBitmap(Dictionary dictionary, RoaringBitmap dictIdBitmap) {
        RoaringBitmap valueBitmap = new RoaringBitmap();
        PeekableIntIterator iterator = dictIdBitmap.getIntIterator();
        FieldSpec.DataType storedType = dictionary.getValueType();
        switch (storedType) {
            case INT: {
                while (iterator.hasNext()) {
                    valueBitmap.add(dictionary.getIntValue(iterator.next()));
                }
                break;
            }
            case LONG: {
                while (iterator.hasNext()) {
                    valueBitmap.add(Long.hashCode(dictionary.getLongValue(iterator.next())));
                }
                break;
            }
            case FLOAT: {
                while (iterator.hasNext()) {
                    valueBitmap.add(Float.hashCode(dictionary.getFloatValue(iterator.next())));
                }
                break;
            }
            case DOUBLE: {
                while (iterator.hasNext()) {
                    valueBitmap.add(Double.hashCode(dictionary.getDoubleValue(iterator.next())));
                }
                break;
            }
            case STRING: {
                while (iterator.hasNext()) {
                    valueBitmap.add(dictionary.getStringValue(iterator.next()).hashCode());
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal data type for FUNNEL_COUNT aggregation function: " + storedType);
            }
        }
        return valueBitmap;
    }
}

