/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.funnel;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.funnel.AggregationStrategy;
import org.apache.pinot.core.query.aggregation.function.funnel.FunnelCountAggregationFunction;
import org.apache.pinot.core.query.aggregation.function.funnel.MergeStrategy;
import org.apache.pinot.core.query.aggregation.function.funnel.ResultExtractionStrategy;
import org.apache.pinot.core.query.aggregation.function.funnel.SortedAggregationResult;
import org.apache.pinot.core.query.aggregation.function.funnel.SortedAggregationStrategy;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.segment.spi.index.reader.Dictionary;

public class FunnelCountSortedAggregationFunction<A>
extends FunnelCountAggregationFunction<A, List<Long>> {
    private final ExpressionContext _primaryCorrelationCol;
    private final AggregationStrategy<SortedAggregationResult> _sortedAggregationStrategy;
    private final ResultExtractionStrategy<SortedAggregationResult, List<Long>> _sortedResultExtractionStrategy;

    public FunnelCountSortedAggregationFunction(List<ExpressionContext> expressions, List<ExpressionContext> stepExpressions, List<ExpressionContext> correlateByExpressions, AggregationStrategy<A> aggregationStrategy, ResultExtractionStrategy<A, List<Long>> resultExtractionStrategy, MergeStrategy<List<Long>> mergeStrategy) {
        super(expressions, stepExpressions, correlateByExpressions, aggregationStrategy, resultExtractionStrategy, mergeStrategy);
        this._sortedAggregationStrategy = new SortedAggregationStrategy(stepExpressions, correlateByExpressions);
        this._sortedResultExtractionStrategy = SortedAggregationResult::extractResult;
        this._primaryCorrelationCol = correlateByExpressions.get(0);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        if (this.isSortedDictionary(blockValSetMap)) {
            this._sortedAggregationStrategy.aggregate(length, aggregationResultHolder, blockValSetMap);
        } else {
            super.aggregate(length, aggregationResultHolder, blockValSetMap);
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        if (this.isSortedDictionary(blockValSetMap)) {
            this._sortedAggregationStrategy.aggregateGroupBySV(length, groupKeyArray, groupByResultHolder, blockValSetMap);
        } else {
            super.aggregateGroupBySV(length, groupKeyArray, groupByResultHolder, blockValSetMap);
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        if (this.isSortedDictionary(blockValSetMap)) {
            this._sortedAggregationStrategy.aggregateGroupByMV(length, groupKeysArray, groupByResultHolder, blockValSetMap);
        } else {
            super.aggregateGroupByMV(length, groupKeysArray, groupByResultHolder, blockValSetMap);
        }
    }

    @Override
    public List<Long> extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        if (this.isSortedAggResult(aggregationResultHolder.getResult())) {
            return this._sortedResultExtractionStrategy.extractAggregationResult(aggregationResultHolder);
        }
        return (List)super.extractAggregationResult(aggregationResultHolder);
    }

    @Override
    public List<Long> extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        if (this.isSortedAggResult(groupByResultHolder.getResult(groupKey))) {
            return this._sortedResultExtractionStrategy.extractGroupByResult(groupByResultHolder, groupKey);
        }
        return (List)super.extractGroupByResult(groupByResultHolder, groupKey);
    }

    private boolean isSortedDictionary(Map<ExpressionContext, BlockValSet> blockValSetMap) {
        return this.getDictionary(blockValSetMap).isSorted();
    }

    private boolean isSortedAggResult(Object aggResult) {
        return aggResult instanceof SortedAggregationResult;
    }

    private Dictionary getDictionary(Map<ExpressionContext, BlockValSet> blockValSetMap) {
        Dictionary primaryCorrelationDictionary = blockValSetMap.get(this._primaryCorrelationCol).getDictionary();
        Preconditions.checkArgument((primaryCorrelationDictionary != null ? 1 : 0) != 0, (Object)"CORRELATE_BY column in FUNNELCOUNT aggregation function not supported for sorted setting, please use a dictionary encoded column.");
        return primaryCorrelationDictionary;
    }
}

