/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.funnel;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.List;
import org.apache.pinot.core.query.aggregation.function.funnel.MergeStrategy;

class PartitionedMergeStrategy
implements MergeStrategy<List<Long>> {
    protected final int _numSteps;

    PartitionedMergeStrategy(int numSteps) {
        this._numSteps = numSteps;
    }

    @Override
    public List<Long> merge(List<Long> a, List<Long> b) {
        LongArrayList result = this.toLongArrayList(a);
        long[] elements = result.elements();
        for (int i = 0; i < this._numSteps; ++i) {
            int n = i;
            elements[n] = elements[n] + b.get(i);
        }
        return result;
    }

    @Override
    public LongArrayList extractFinalResult(List<Long> intermediateResult) {
        return this.toLongArrayList(intermediateResult);
    }

    private LongArrayList toLongArrayList(List<Long> longList) {
        return longList instanceof LongArrayList ? ((LongArrayList)longList).clone() : new LongArrayList(longList);
    }
}

