/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.funnel;

import it.unimi.dsi.fastutil.longs.LongArrayList;

class SortedAggregationResult {
    final int _numSteps;
    final long[] _stepCounters;
    final boolean[] _correlatedSteps;
    int _lastCorrelationId = Integer.MIN_VALUE;

    SortedAggregationResult(int numSteps) {
        this._numSteps = numSteps;
        this._stepCounters = new long[this._numSteps];
        this._correlatedSteps = new boolean[this._numSteps];
    }

    public void add(int step, int correlationId) {
        if (correlationId != this._lastCorrelationId) {
            this.incrStepCounters();
            for (int n = 0; n < this._numSteps; ++n) {
                this._correlatedSteps[n] = false;
            }
            this._lastCorrelationId = correlationId;
        }
        this._correlatedSteps[step] = true;
    }

    void incrStepCounters() {
        int n = 0;
        while (n < this._numSteps && this._correlatedSteps[n]) {
            int n2 = n++;
            this._stepCounters[n2] = this._stepCounters[n2] + 1L;
        }
    }

    public LongArrayList extractResult() {
        this.incrStepCounters();
        return LongArrayList.wrap((long[])this._stepCounters);
    }
}

