/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.funnel;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.ArrayList;
import java.util.List;
import org.apache.datasketches.theta.Intersection;
import org.apache.datasketches.theta.SetOperationBuilder;
import org.apache.datasketches.theta.Sketch;
import org.apache.pinot.core.query.aggregation.function.funnel.MergeStrategy;

class ThetaSketchMergeStrategy
implements MergeStrategy<List<Sketch>> {
    protected final int _numSteps;
    final SetOperationBuilder _setOperationBuilder;

    ThetaSketchMergeStrategy(int numSteps, int nominalEntries) {
        this._numSteps = numSteps;
        this._setOperationBuilder = new SetOperationBuilder().setNominalEntries(nominalEntries);
    }

    @Override
    public List<Sketch> merge(List<Sketch> sketches1, List<Sketch> sketches2) {
        ArrayList<Sketch> mergedSketches = new ArrayList<Sketch>(this._numSteps);
        for (int i = 0; i < this._numSteps; ++i) {
            mergedSketches.add((Sketch)this._setOperationBuilder.buildUnion().union(sketches1.get(i), sketches2.get(i), false, null));
        }
        return mergedSketches;
    }

    @Override
    public LongArrayList extractFinalResult(List<Sketch> sketches) {
        long[] result = new long[this._numSteps];
        Sketch sketch = sketches.get(0);
        result[0] = Math.round(sketch.getEstimate());
        for (int i = 1; i < this._numSteps; ++i) {
            Intersection intersection = this._setOperationBuilder.buildIntersection();
            sketch = intersection.intersect(sketch, sketches.get(i));
            result[i] = Math.round(sketch.getEstimate());
        }
        return LongArrayList.wrap((long[])result);
    }
}

