/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.funnel.window;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.funnel.FunnelStepEvent;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;

public abstract class FunnelBaseAggregationFunction<F extends Comparable>
implements AggregationFunction<PriorityQueue<FunnelStepEvent>, F> {
    protected final ExpressionContext _timestampExpression;
    protected final long _windowSize;
    protected final List<ExpressionContext> _stepExpressions;
    protected final FunnelModes _modes = new FunnelModes();
    protected final int _numSteps;
    protected long _maxStepDuration = 0L;

    public FunnelBaseAggregationFunction(List<ExpressionContext> arguments) {
        int numArguments = arguments.size();
        Preconditions.checkArgument((numArguments > 3 ? 1 : 0) != 0, (String)("FUNNEL_AGG_FUNC expects >= 4 arguments, got: %s. The function can be used as " + this.getType().getName() + "(timestampExpression, windowSize, numberSteps, stepExpression, [stepExpression, ..], [mode, [mode, ... ]])"), (int)numArguments);
        this._timestampExpression = arguments.get(0);
        this._windowSize = arguments.get(1).getLiteral().getLongValue();
        Preconditions.checkArgument((this._windowSize > 0L ? 1 : 0) != 0, (Object)"Window size must be > 0");
        this._numSteps = arguments.get(2).getLiteral().getIntValue();
        Preconditions.checkArgument((numArguments >= 3 + this._numSteps ? 1 : 0) != 0, (String)("FUNNEL_AGG_FUNC expects >= " + (3 + this._numSteps) + " arguments, got: %s. The function can be used as " + this.getType().getName() + "(timestampExpression, windowSize, numberSteps, stepExpression, [stepExpression, ..], [extraArgument/mode, [extraArgument/mode, ... ]])"), (int)numArguments);
        this._stepExpressions = arguments.subList(3, 3 + this._numSteps);
        block10: for (int i = 3 + this._numSteps; i < numArguments; ++i) {
            String extraArgument = arguments.get(i).getLiteral().getStringValue().toUpperCase();
            String[] parsedExtraArguments = extraArgument.split("=");
            if (parsedExtraArguments.length == 2) {
                String key;
                switch (key = parsedExtraArguments[0].toUpperCase()) {
                    case "MAXSTEPDURATION": {
                        this._maxStepDuration = Long.parseLong(parsedExtraArguments[1]);
                        Preconditions.checkArgument((this._maxStepDuration > 0L ? 1 : 0) != 0, (Object)"MaxStepDuration must be > 0");
                        break;
                    }
                    case "MODE": {
                        for (String modeStr : parsedExtraArguments[1].split(",")) {
                            this._modes.add(Mode.valueOf(modeStr.trim()));
                        }
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException("Unrecognized arguments: " + extraArgument);
                    }
                }
                continue;
            }
            try {
                this._modes.add(Mode.valueOf(extraArgument));
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Unrecognized extra argument for funnel function: " + extraArgument, e);
            }
        }
    }

    @Override
    public String getResultColumnName() {
        return this.getType().getName().toLowerCase() + "(" + this._windowSize + ")  (" + this._timestampExpression.toString() + ", " + this._stepExpressions.stream().map(ExpressionContext::toString).collect(Collectors.joining(",")) + ")";
    }

    @Override
    public List<ExpressionContext> getInputExpressions() {
        ArrayList<ExpressionContext> inputs = new ArrayList<ExpressionContext>(1 + this._numSteps);
        inputs.add(this._timestampExpression);
        inputs.addAll(this._stepExpressions);
        return inputs;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        long[] timestampBlock = blockValSetMap.get(this._timestampExpression).getLongValuesSV();
        ArrayList<int[]> stepBlocks = new ArrayList<int[]>(this._numSteps);
        for (ExpressionContext stepExpression : this._stepExpressions) {
            stepBlocks.add(blockValSetMap.get(stepExpression).getIntValuesSV());
        }
        PriorityQueue<FunnelStepEvent> stepEvents = (PriorityQueue<FunnelStepEvent>)aggregationResultHolder.getResult();
        if (stepEvents == null) {
            stepEvents = new PriorityQueue<FunnelStepEvent>();
            aggregationResultHolder.setValue(stepEvents);
        }
        for (int i = 0; i < length; ++i) {
            boolean stepFound = false;
            for (int j = 0; j < this._numSteps; ++j) {
                if (((int[])stepBlocks.get(j))[i] != 1) continue;
                stepEvents.add(new FunnelStepEvent(timestampBlock[i], j));
                stepFound = true;
                break;
            }
            if (!this._modes.hasKeepAll() || stepFound) continue;
            stepEvents.add(new FunnelStepEvent(timestampBlock[i], -1));
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        long[] timestampBlock = blockValSetMap.get(this._timestampExpression).getLongValuesSV();
        ArrayList<int[]> stepBlocks = new ArrayList<int[]>(this._numSteps);
        for (ExpressionContext stepExpression : this._stepExpressions) {
            stepBlocks.add(blockValSetMap.get(stepExpression).getIntValuesSV());
        }
        for (int i = 0; i < length; ++i) {
            int groupKey = groupKeyArray[i];
            boolean stepFound = false;
            for (int j = 0; j < this._numSteps; ++j) {
                if (((int[])stepBlocks.get(j))[i] != 1) continue;
                PriorityQueue<FunnelStepEvent> stepEvents = FunnelBaseAggregationFunction.getFunnelStepEvents(groupByResultHolder, groupKey);
                stepEvents.add(new FunnelStepEvent(timestampBlock[i], j));
                stepFound = true;
                break;
            }
            if (!this._modes.hasKeepAll() || stepFound) continue;
            PriorityQueue<FunnelStepEvent> stepEvents = FunnelBaseAggregationFunction.getFunnelStepEvents(groupByResultHolder, groupKey);
            stepEvents.add(new FunnelStepEvent(timestampBlock[i], -1));
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        long[] timestampBlock = blockValSetMap.get(this._timestampExpression).getLongValuesSV();
        ArrayList<int[]> stepBlocks = new ArrayList<int[]>(this._numSteps);
        for (ExpressionContext stepExpression : this._stepExpressions) {
            stepBlocks.add(blockValSetMap.get(stepExpression).getIntValuesSV());
        }
        for (int i = 0; i < length; ++i) {
            int[] groupKeys = groupKeysArray[i];
            boolean stepFound = false;
            for (int j = 0; j < this._numSteps; ++j) {
                if (((int[])stepBlocks.get(j))[i] != 1) continue;
                int[] nArray = groupKeys;
                int n = nArray.length;
                for (int k = 0; k < n; ++k) {
                    int groupKey = nArray[k];
                    PriorityQueue<FunnelStepEvent> stepEvents = FunnelBaseAggregationFunction.getFunnelStepEvents(groupByResultHolder, groupKey);
                    stepEvents.add(new FunnelStepEvent(timestampBlock[i], j));
                }
                stepFound = true;
                break;
            }
            if (!this._modes.hasKeepAll() || stepFound) continue;
            for (int groupKey : groupKeys) {
                PriorityQueue<FunnelStepEvent> stepEvents = FunnelBaseAggregationFunction.getFunnelStepEvents(groupByResultHolder, groupKey);
                stepEvents.add(new FunnelStepEvent(timestampBlock[i], -1));
            }
        }
    }

    private static PriorityQueue<FunnelStepEvent> getFunnelStepEvents(GroupByResultHolder groupByResultHolder, int groupKey) {
        PriorityQueue stepEvents = (PriorityQueue)groupByResultHolder.getResult(groupKey);
        if (stepEvents == null) {
            stepEvents = new PriorityQueue();
            groupByResultHolder.setValueForKey(groupKey, stepEvents);
        }
        return stepEvents;
    }

    @Override
    public PriorityQueue<FunnelStepEvent> extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        return (PriorityQueue)aggregationResultHolder.getResult();
    }

    @Override
    public PriorityQueue<FunnelStepEvent> extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        return (PriorityQueue)groupByResultHolder.getResult(groupKey);
    }

    @Override
    public PriorityQueue<FunnelStepEvent> merge(PriorityQueue<FunnelStepEvent> intermediateResult1, PriorityQueue<FunnelStepEvent> intermediateResult2) {
        if (intermediateResult1 == null) {
            return intermediateResult2;
        }
        if (intermediateResult2 == null) {
            return intermediateResult1;
        }
        intermediateResult1.addAll(intermediateResult2);
        return intermediateResult1;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    protected void fillWindow(PriorityQueue<FunnelStepEvent> stepEvents, ArrayDeque<FunnelStepEvent> slidingWindow) {
        while (!slidingWindow.isEmpty() && slidingWindow.peek().getStep() != 0) {
            slidingWindow.pollFirst();
        }
        if (slidingWindow.isEmpty()) {
            while (!stepEvents.isEmpty() && stepEvents.peek().getStep() != 0) {
                stepEvents.poll();
            }
            if (stepEvents.isEmpty()) {
                return;
            }
            slidingWindow.addLast(stepEvents.poll());
        }
        long windowStart = slidingWindow.peek().getTimestamp();
        long windowEnd = windowStart + this._windowSize;
        while (!(stepEvents.isEmpty() || stepEvents.peek().getTimestamp() >= windowEnd || this._maxStepDuration > 0L && stepEvents.peek().getTimestamp() - slidingWindow.getLast().getTimestamp() > this._maxStepDuration)) {
            slidingWindow.addLast(stepEvents.poll());
        }
    }

    @Override
    public String toExplainString() {
        return this.getType().getName() + "{timestampExpression=" + this._timestampExpression + ", windowSize=" + this._windowSize + ", stepExpressions=" + this._stepExpressions + "}";
    }

    protected static class FunnelConfigs {
        public static final String MODE = "MODE";
        static final String MAX_STEP_DURATION = "MAXSTEPDURATION";

        protected FunnelConfigs() {
        }
    }

    protected static class FunnelModes {
        private int _bitmask = 0;

        protected FunnelModes() {
        }

        public void add(Mode mode) {
            this._bitmask |= mode.getValue();
        }

        public void remove(Mode mode) {
            this._bitmask &= ~mode.getValue();
        }

        public boolean contains(Mode mode) {
            return (this._bitmask & mode.getValue()) != 0;
        }

        public boolean hasStrictDeduplication() {
            return this.contains(Mode.STRICT_DEDUPLICATION);
        }

        public boolean hasStrictOrder() {
            return this.contains(Mode.STRICT_ORDER);
        }

        public boolean hasStrictIncrease() {
            return this.contains(Mode.STRICT_INCREASE);
        }

        public boolean hasKeepAll() {
            return this.contains(Mode.KEEP_ALL);
        }
    }

    protected static enum Mode {
        STRICT_DEDUPLICATION(1),
        STRICT_ORDER(2),
        STRICT_INCREASE(4),
        KEEP_ALL(8);

        private final int _value;

        private Mode(int value) {
            this._value = value;
        }

        public int getValue() {
            return this._value;
        }
    }
}

