/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.funnel.window;

import java.util.ArrayDeque;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.query.aggregation.function.funnel.FunnelStepEvent;
import org.apache.pinot.core.query.aggregation.function.funnel.window.FunnelBaseAggregationFunction;
import org.apache.pinot.segment.spi.AggregationFunctionType;

public class FunnelMaxStepAggregationFunction
extends FunnelBaseAggregationFunction<Integer> {
    public FunnelMaxStepAggregationFunction(List<ExpressionContext> arguments) {
        super(arguments);
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.FUNNELMAXSTEP;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.INT;
    }

    @Override
    public Integer extractFinalResult(PriorityQueue<FunnelStepEvent> stepEvents) {
        int finalMaxStep = 0;
        if (stepEvents == null || stepEvents.isEmpty()) {
            return finalMaxStep;
        }
        ArrayDeque<FunnelStepEvent> slidingWindow = new ArrayDeque<FunnelStepEvent>();
        while (!stepEvents.isEmpty()) {
            int maxSteps;
            this.fillWindow(stepEvents, slidingWindow);
            if (slidingWindow.isEmpty() || (finalMaxStep = Math.max(finalMaxStep, maxSteps = this.processWindow(slidingWindow).intValue())) == this._numSteps) break;
            if (slidingWindow.isEmpty()) continue;
            slidingWindow.pollFirst();
        }
        return finalMaxStep;
    }

    protected Integer processWindow(ArrayDeque<FunnelStepEvent> slidingWindow) {
        int maxStep = 0;
        long previousTimestamp = -1L;
        for (FunnelStepEvent event : slidingWindow) {
            int currentEventStep = event.getStep();
            if (this._modes.hasStrictDeduplication() && currentEventStep == maxStep - 1) {
                return maxStep;
            }
            if (this._modes.hasStrictOrder() && currentEventStep != maxStep) {
                return maxStep;
            }
            if (this._modes.hasStrictIncrease() && previousTimestamp == event.getTimestamp()) continue;
            if (maxStep == currentEventStep) {
                ++maxStep;
                previousTimestamp = event.getTimestamp();
            }
            if (maxStep != this._numSteps) continue;
            break;
        }
        return maxStep;
    }

    @Override
    public Integer mergeFinalResult(Integer finalResult1, Integer finalResult2) {
        return Math.max(finalResult1, finalResult2);
    }
}

