/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.groupby.utils;

import it.unimi.dsi.fastutil.floats.Float2IntOpenHashMap;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import org.apache.pinot.core.query.aggregation.groupby.utils.ValueToIdMap;

public class FloatToIdMap
implements ValueToIdMap {
    private final Float2IntOpenHashMap _valueToIdMap = new Float2IntOpenHashMap();
    private final FloatArrayList _idToValueMap;

    public FloatToIdMap() {
        this._valueToIdMap.defaultReturnValue(-1);
        this._idToValueMap = new FloatArrayList();
    }

    @Override
    public int put(float value) {
        int numValues = this._valueToIdMap.size();
        int id = this._valueToIdMap.computeIfAbsent(value, k -> numValues);
        if (id == numValues) {
            this._idToValueMap.add(value);
        }
        return id;
    }

    @Override
    public int put(Object value) {
        return this.put(((Float)value).floatValue());
    }

    @Override
    public int getId(float value) {
        return this._valueToIdMap.get(value);
    }

    @Override
    public int getId(Object value) {
        return this.getId(((Float)value).floatValue());
    }

    @Override
    public Float get(int id) {
        return Float.valueOf(this._idToValueMap.getFloat(id));
    }
}

