/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.groupby.utils;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import org.apache.pinot.core.query.aggregation.groupby.utils.ValueToIdMap;

public class IntToIdMap
implements ValueToIdMap {
    private final Int2IntOpenHashMap _valueToIdMap = new Int2IntOpenHashMap();
    private final IntArrayList _idToValueMap;

    public IntToIdMap() {
        this._valueToIdMap.defaultReturnValue(-1);
        this._idToValueMap = new IntArrayList();
    }

    @Override
    public int put(int value) {
        int numValues = this._valueToIdMap.size();
        int id = this._valueToIdMap.computeIfAbsent(value, k -> numValues);
        if (id == numValues) {
            this._idToValueMap.add(value);
        }
        return id;
    }

    @Override
    public int put(Object value) {
        return this.put((Integer)value);
    }

    @Override
    public int getId(int value) {
        return this._valueToIdMap.get(value);
    }

    @Override
    public int getId(Object value) {
        return this.getId((Integer)value);
    }

    @Override
    public Integer get(int id) {
        return this._idToValueMap.getInt(id);
    }
}

