/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.utils;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.segment.spi.AggregationFunctionType;

public class StatisticalAggregationFunctionUtils {
    private StatisticalAggregationFunctionUtils() {
    }

    public static double[] getValSet(Map<ExpressionContext, BlockValSet> blockValSetMap, ExpressionContext expression) {
        BlockValSet blockValSet = blockValSetMap.get(expression);
        Preconditions.checkState((boolean)blockValSet.isSingleValue(), (Object)"Variance, Covariance, Standard Deviation function currently only supports single-valued column");
        switch (blockValSet.getValueType().getStoredType()) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return blockValSet.getDoubleValuesSV();
            }
        }
        throw new IllegalStateException("Cannot compute variance, covariance, or standard deviation for non-numeric type: " + blockValSet.getValueType());
    }

    public static Double calculateVariance(List<Double> values, AggregationFunctionType aggregationFunctionType) {
        long count = 0L;
        double sum = 0.0;
        double variance = 0.0;
        for (Double value : values) {
            sum += value.doubleValue();
            if (++count <= 1L) continue;
            variance = StatisticalAggregationFunctionUtils.computeIntermediateVariance(count, sum, variance, value);
        }
        assert (count > 1L);
        switch (aggregationFunctionType) {
            case VARPOP: {
                return variance / (double)count;
            }
            case VARSAMP: {
                return variance / (double)(count - 1L);
            }
            case STDDEVPOP: {
                return Math.sqrt(variance / (double)count);
            }
            case STDDEVSAMP: {
                return Math.sqrt(variance / (double)(count - 1L));
            }
        }
        throw new IllegalArgumentException();
    }

    public static double computeIntermediateVariance(long count, double sum, double m2, double value) {
        double t = (double)count * value - sum;
        return m2 += t * t / (double)(count * (count - 1L));
    }
}

