/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.utils.exprminmax;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.pinot.common.datablock.DataBlock;
import org.apache.pinot.common.datablock.DataBlockEquals;
import org.apache.pinot.common.datablock.DataBlockUtils;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.datablock.DataBlockBuilder;
import org.apache.pinot.core.query.aggregation.utils.ParentAggregationFunctionResultObject;
import org.apache.pinot.core.query.aggregation.utils.exprminmax.ExprMinMaxMeasuringValSetWrapper;
import org.apache.pinot.core.query.aggregation.utils.exprminmax.ExprMinMaxProjectionValSetWrapper;
import org.apache.pinot.segment.spi.memory.CompoundDataBuffer;

public class ExprMinMaxObject
implements ParentAggregationFunctionResultObject {
    private boolean _isNull;
    private boolean _mutable;
    private final DataSchema _measuringSchema;
    private final DataSchema _projectionSchema;
    private final int _sizeOfExtremumMeasuringKeys;
    private final int _sizeOfExtremumProjectionVals;
    private Comparable[] _extremumMeasuringKeys = null;
    private final List<Object[]> _extremumProjectionValues = new ArrayList<Object[]>();
    private DataBlock _immutableMeasuringKeys;
    private DataBlock _immutableProjectionVals;

    public ExprMinMaxObject(DataSchema measuringSchema, DataSchema projectionSchema) {
        this._isNull = true;
        this._mutable = true;
        this._measuringSchema = measuringSchema;
        this._projectionSchema = projectionSchema;
        this._sizeOfExtremumMeasuringKeys = this._measuringSchema.size();
        this._sizeOfExtremumProjectionVals = this._projectionSchema.size();
    }

    public ExprMinMaxObject(ByteBuffer byteBuffer) throws IOException {
        this._mutable = false;
        this._isNull = byteBuffer.getInt() == ObjectNullState.NULL.getState();
        byteBuffer = byteBuffer.slice();
        this._immutableMeasuringKeys = DataBlockUtils.readFrom((ByteBuffer)byteBuffer);
        byteBuffer = byteBuffer.slice();
        this._immutableProjectionVals = DataBlockUtils.readFrom((ByteBuffer)byteBuffer);
        this._measuringSchema = this._immutableMeasuringKeys.getDataSchema();
        this._projectionSchema = this._immutableProjectionVals.getDataSchema();
        this._sizeOfExtremumMeasuringKeys = this._measuringSchema.size();
        this._sizeOfExtremumProjectionVals = this._projectionSchema.size();
    }

    public static ExprMinMaxObject fromBytes(byte[] bytes) throws IOException {
        return ExprMinMaxObject.fromByteBuffer(ByteBuffer.wrap(bytes));
    }

    public static ExprMinMaxObject fromByteBuffer(ByteBuffer byteBuffer) throws IOException {
        return new ExprMinMaxObject(byteBuffer);
    }

    @Nonnull
    public byte[] toBytes() throws IOException {
        int header;
        if (this._isNull) {
            header = ObjectNullState.NULL.getState();
            this._immutableMeasuringKeys = DataBlockBuilder.buildFromRows(Collections.emptyList(), this._measuringSchema);
            this._immutableProjectionVals = DataBlockBuilder.buildFromRows(Collections.emptyList(), this._projectionSchema);
        } else {
            header = ObjectNullState.NON_NULL.getState();
            this._immutableMeasuringKeys = DataBlockBuilder.buildFromRows(Collections.singletonList(this._extremumMeasuringKeys), this._measuringSchema);
            this._immutableProjectionVals = DataBlockBuilder.buildFromRows(this._extremumProjectionValues, this._projectionSchema);
        }
        List measuringKeys = DataBlockUtils.serialize((DataBlock)this._immutableMeasuringKeys);
        List projectionVals = DataBlockUtils.serialize((DataBlock)this._immutableProjectionVals);
        CompoundDataBuffer compoundDataBuffer = new CompoundDataBuffer.Builder(ByteOrder.BIG_ENDIAN).addBuffers((Iterable)measuringKeys).addBuffers((Iterable)projectionVals).build();
        long size = 4L + compoundDataBuffer.size();
        Preconditions.checkState((size <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Data size is too large: %s", (long)size);
        int sizeInt = (int)size;
        byte[] bytes = new byte[sizeInt];
        ByteBuffer buffer = ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN);
        buffer.putInt(header);
        compoundDataBuffer.copyTo(0L, bytes, 4, sizeInt - 4);
        ExprMinMaxObject exprMinMaxObject = ExprMinMaxObject.fromBytes(bytes);
        assert (DataBlockEquals.sameContent((DataBlock)exprMinMaxObject._immutableMeasuringKeys, (DataBlock)this._immutableMeasuringKeys));
        assert (DataBlockEquals.sameContent((DataBlock)exprMinMaxObject._immutableProjectionVals, (DataBlock)this._immutableProjectionVals));
        return bytes;
    }

    public int compareAndSetKey(List<ExprMinMaxMeasuringValSetWrapper> exprMinMaxWrapperValSets, int offset, boolean isMax) {
        Preconditions.checkState((boolean)this._mutable, (Object)"Cannot compare and set key after the object is serialized");
        if (!this._isNull) {
            for (int i = 0; i < this._sizeOfExtremumMeasuringKeys; ++i) {
                ExprMinMaxMeasuringValSetWrapper exprMinMaxWrapperValSet = exprMinMaxWrapperValSets.get(i);
                int result = exprMinMaxWrapperValSet.compare(offset, this._extremumMeasuringKeys[i]);
                if (result == 0) continue;
                if (isMax ? result < 0 : result > 0) {
                    for (int j = 0; j < this._sizeOfExtremumMeasuringKeys; ++j) {
                        this._extremumMeasuringKeys[j] = exprMinMaxWrapperValSets.get(j).getComparable(offset);
                    }
                    return 1;
                }
                return -1;
            }
        } else {
            this._isNull = false;
            this._extremumMeasuringKeys = new Comparable[this._sizeOfExtremumMeasuringKeys];
            for (int i = 0; i < this._sizeOfExtremumMeasuringKeys; ++i) {
                this._extremumMeasuringKeys[i] = exprMinMaxWrapperValSets.get(i).getComparable(offset);
            }
        }
        return 0;
    }

    public void setToNewVal(List<ExprMinMaxProjectionValSetWrapper> exprMinMaxProjectionValSetWrappers, int offset) {
        this._extremumProjectionValues.clear();
        this.addVal(exprMinMaxProjectionValSetWrappers, offset);
    }

    public void addVal(List<ExprMinMaxProjectionValSetWrapper> exprMinMaxProjectionValSetWrappers, int offset) {
        Object[] val = new Object[this._projectionSchema.size()];
        for (int i = 0; i < this._projectionSchema.size(); ++i) {
            val[i] = exprMinMaxProjectionValSetWrappers.get(i).getValue(offset);
        }
        this._extremumProjectionValues.add(val);
    }

    public Comparable[] getExtremumKey() {
        if (this._mutable) {
            return this._extremumMeasuringKeys;
        }
        Comparable[] extremumKeys = new Comparable[this._sizeOfExtremumMeasuringKeys];
        block8: for (int i = 0; i < this._sizeOfExtremumMeasuringKeys; ++i) {
            switch (this._measuringSchema.getColumnDataType(i)) {
                case INT: 
                case BOOLEAN: {
                    extremumKeys[i] = Integer.valueOf(this._immutableMeasuringKeys.getInt(0, i));
                    continue block8;
                }
                case LONG: 
                case TIMESTAMP: {
                    extremumKeys[i] = Long.valueOf(this._immutableMeasuringKeys.getLong(0, i));
                    continue block8;
                }
                case FLOAT: {
                    extremumKeys[i] = Float.valueOf(this._immutableMeasuringKeys.getFloat(0, i));
                    continue block8;
                }
                case DOUBLE: {
                    extremumKeys[i] = Double.valueOf(this._immutableMeasuringKeys.getDouble(0, i));
                    continue block8;
                }
                case STRING: {
                    extremumKeys[i] = this._immutableMeasuringKeys.getString(0, i);
                    continue block8;
                }
                case BIG_DECIMAL: {
                    extremumKeys[i] = this._immutableMeasuringKeys.getBigDecimal(0, i);
                    continue block8;
                }
                default: {
                    throw new IllegalStateException("Unsupported data type: " + this._measuringSchema.getColumnDataType(i));
                }
            }
        }
        return extremumKeys;
    }

    @Override
    public Object getField(int rowId, int colId) {
        if (this._mutable) {
            return this._extremumProjectionValues.get(rowId)[colId];
        }
        switch (this._projectionSchema.getColumnDataType(colId)) {
            case INT: 
            case BOOLEAN: {
                return this._immutableProjectionVals.getInt(rowId, colId);
            }
            case LONG: 
            case TIMESTAMP: {
                return this._immutableProjectionVals.getLong(rowId, colId);
            }
            case FLOAT: {
                return Float.valueOf(this._immutableProjectionVals.getFloat(rowId, colId));
            }
            case DOUBLE: {
                return this._immutableProjectionVals.getDouble(rowId, colId);
            }
            case STRING: 
            case JSON: {
                return this._immutableProjectionVals.getString(rowId, colId);
            }
            case BYTES: {
                return this._immutableProjectionVals.getBytes(rowId, colId);
            }
            case BIG_DECIMAL: {
                return this._immutableProjectionVals.getBigDecimal(rowId, colId);
            }
            case BOOLEAN_ARRAY: 
            case INT_ARRAY: {
                return this._immutableProjectionVals.getIntArray(rowId, colId);
            }
            case TIMESTAMP_ARRAY: 
            case LONG_ARRAY: {
                return this._immutableProjectionVals.getLongArray(rowId, colId);
            }
            case FLOAT_ARRAY: {
                return this._immutableProjectionVals.getFloatArray(rowId, colId);
            }
            case DOUBLE_ARRAY: {
                return this._immutableProjectionVals.getDoubleArray(rowId, colId);
            }
            case STRING_ARRAY: 
            case BYTES_ARRAY: {
                return this._immutableProjectionVals.getStringArray(rowId, colId);
            }
        }
        throw new IllegalStateException("Unsupported data type: " + this._projectionSchema.getColumnDataType(colId));
    }

    public ExprMinMaxObject merge(ExprMinMaxObject other, boolean isMax) {
        int j;
        Object[] val;
        int i;
        if (this._isNull && other._isNull) {
            return this;
        }
        if (this._isNull) {
            return other;
        }
        if (other._isNull) {
            return this;
        }
        Comparable[] key = this.getExtremumKey();
        Comparable[] otherKey = other.getExtremumKey();
        for (i = 0; i < this._sizeOfExtremumMeasuringKeys; ++i) {
            int result = key[i].compareTo(otherKey[i]);
            if (result == 0) continue;
            if (isMax) {
                return result > 0 ? this : other;
            }
            return result < 0 ? this : other;
        }
        if (!this._mutable) {
            this._mutable = true;
            for (i = 0; i < this.getNumberOfRows(); ++i) {
                val = new Object[this._sizeOfExtremumProjectionVals];
                for (j = 0; j < this._sizeOfExtremumProjectionVals; ++j) {
                    val[j] = this.getField(i, j);
                }
                this._extremumProjectionValues.add(val);
            }
        }
        for (i = 0; i < other.getNumberOfRows(); ++i) {
            val = new Object[this._sizeOfExtremumProjectionVals];
            for (j = 0; j < this._sizeOfExtremumProjectionVals; ++j) {
                val[j] = other.getField(i, j);
            }
            this._extremumProjectionValues.add(val);
        }
        return this;
    }

    @Override
    public int getNumberOfRows() {
        if (this._mutable) {
            return this._extremumProjectionValues.size();
        }
        return this._immutableProjectionVals.getNumberOfRows();
    }

    @Override
    public DataSchema getSchema() {
        return this._projectionSchema;
    }

    @Override
    public int compareTo(ParentAggregationFunctionResultObject o) {
        return this.getNumberOfRows() - o.getNumberOfRows();
    }

    static enum ObjectNullState {
        NULL(0),
        NON_NULL(1);

        final int _state;

        private ObjectNullState(int i) {
            this._state = i;
        }

        int getState() {
            return this._state;
        }
    }
}

