/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.config;

import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.pinot.core.query.config.SegmentPrunerConfig;
import org.apache.pinot.spi.env.PinotConfiguration;

public class QueryExecutorConfig {
    public static final String QUERY_PRUNER = "pruner";
    public static final String PLAN_MAKER_CLASS = "plan.maker.class";
    public static final String TIME_OUT = "timeout";
    private final PinotConfiguration _config;

    public QueryExecutorConfig(PinotConfiguration config) throws ConfigurationException {
        this._config = config;
    }

    public PinotConfiguration getConfig() {
        return this._config;
    }

    public SegmentPrunerConfig getPrunerConfig() {
        return new SegmentPrunerConfig(this._config.subset(QUERY_PRUNER));
    }

    public String getPlanMakerClass() {
        return this._config.getProperty(PLAN_MAKER_CLASS, "org.apache.pinot.core.plan.maker.InstancePlanMakerImplV2");
    }

    public long getTimeOut() {
        return this._config.getProperty(TIME_OUT, 15000L);
    }
}

